/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.stateful;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.jboss.ejb3.JndiProxyFactory;
import org.jboss.ejb3.ProxyFactory;
import org.jboss.ejb3.session.BaseSessionProxyFactory;
import org.jboss.ejb3.session.SessionContainer;
import org.jboss.logging.Logger;
import org.jboss.naming.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseStatefulProxyFactory
extends BaseSessionProxyFactory
implements ProxyFactory {
    private static final Logger log = Logger.getLogger(BaseStatefulProxyFactory.class);
    private Constructor proxyConstructor;
    protected String jndiName;
    public static final String PROXY_FACTORY_NAME = "StatefulProxyFactory";

    protected BaseStatefulProxyFactory() {
    }

    public BaseStatefulProxyFactory(SessionContainer container, String jndiName) {
        super(container);
        assert (jndiName != null) : "jndiName is null";
        this.jndiName = jndiName;
    }

    protected Object constructProxy(InvocationHandler handler) {
        try {
            return this.proxyConstructor.newInstance(handler);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
    }

    public void init() throws Exception {
        Class<?>[] interfaces = this.getInterfaces();
        Class<?> proxyClass = Proxy.getProxyClass(this.getContainer().getBeanClass().getClassLoader(), interfaces);
        this.proxyConstructor = proxyClass.getConstructor(InvocationHandler.class);
    }

    @Override
    public void start() throws Exception {
        this.init();
        Context ctx = this.getContainer().getInitialContext();
        Name name = ctx.getNameParser("").parse(this.jndiName);
        ctx = Util.createSubcontext((Context)ctx, (Name)name.getPrefix(name.size() - 1));
        String atom = name.get(name.size() - 1);
        StringRefAddr refAddr = new StringRefAddr("FACTORY", this.jndiName + PROXY_FACTORY_NAME);
        Reference ref = new Reference("java.lang.Object", refAddr, JndiProxyFactory.class.getName(), null);
        try {
            log.debug((Object)("Binding reference for " + this.getContainer().getEjbName() + " in JNDI at " + atom));
            Util.rebind((Context)ctx, (String)atom, (Object)ref);
        }
        catch (NamingException e) {
            NamingException namingException = new NamingException("Could not bind stateful proxy with ejb name " + this.getContainer().getEjbName() + " into JNDI under jndiName: " + ctx.getNameInNamespace() + "/" + atom);
            namingException.setRootCause(e);
            throw namingException;
        }
    }

    @Override
    public void stop() throws Exception {
        Util.unbind((Context)this.getContainer().getInitialContext(), (String)this.jndiName);
    }

    protected abstract Class<?>[] getInterfaces();

    protected final void initializeJndiName() {
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        try {
            this.init();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new IOException(e.getMessage());
        }
        this.jndiName = in.readUTF();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeUTF(this.jndiName);
    }
}

