/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.stateful;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.EJB;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import javax.ejb.Init;
import javax.ejb.PostActivate;
import javax.ejb.PrePassivate;
import javax.ejb.Remote;
import javax.ejb.RemoteHome;
import javax.ejb.TimerService;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.MethodInfo;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.InvocationResponse;
import org.jboss.aop.util.MethodHashing;
import org.jboss.aspects.asynch.FutureHolder;
import org.jboss.ejb3.BeanContext;
import org.jboss.ejb3.Ejb3Deployment;
import org.jboss.ejb3.ProxyFactory;
import org.jboss.ejb3.ProxyFactoryHelper;
import org.jboss.ejb3.ProxyUtils;
import org.jboss.ejb3.annotation.Cache;
import org.jboss.ejb3.annotation.Clustered;
import org.jboss.ejb3.annotation.LocalBinding;
import org.jboss.ejb3.annotation.RemoteBinding;
import org.jboss.ejb3.annotation.RemoteBindings;
import org.jboss.ejb3.cache.CacheFactoryRegistry;
import org.jboss.ejb3.cache.Ejb3CacheFactory;
import org.jboss.ejb3.cache.StatefulCache;
import org.jboss.ejb3.cache.StatefulObjectFactory;
import org.jboss.ejb3.interceptor.InterceptorInfoRepository;
import org.jboss.ejb3.proxy.EJBMetaDataImpl;
import org.jboss.ejb3.proxy.handle.HomeHandleImpl;
import org.jboss.ejb3.remoting.RemoteProxyFactory;
import org.jboss.ejb3.session.SessionContainer;
import org.jboss.ejb3.stateful.ForwardId;
import org.jboss.ejb3.stateful.StatefulBeanContext;
import org.jboss.ejb3.stateful.StatefulClusterProxyFactory;
import org.jboss.ejb3.stateful.StatefulContainerInvocation;
import org.jboss.ejb3.stateful.StatefulDelegateWrapper;
import org.jboss.ejb3.stateful.StatefulHandleImpl;
import org.jboss.ejb3.stateful.StatefulLocalProxyFactory;
import org.jboss.ejb3.stateful.StatefulRemoteInvocation;
import org.jboss.ejb3.stateful.StatefulRemoteProxyFactory;
import org.jboss.injection.Injector;
import org.jboss.injection.JndiPropertyInjector;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatefulContainer
extends SessionContainer
implements StatefulObjectFactory<StatefulBeanContext> {
    private static final Logger log = Logger.getLogger(StatefulContainer.class);
    protected StatefulCache cache;
    private StatefulDelegateWrapper mbean = new StatefulDelegateWrapper(this);

    public StatefulContainer(ClassLoader cl, String beanClassName, String ejbName, AspectManager manager, Hashtable ctxProperties, InterceptorInfoRepository interceptorRepository, Ejb3Deployment deployment) {
        super(cl, beanClassName, ejbName, manager, ctxProperties, interceptorRepository, deployment);
    }

    public StatefulBeanContext create(Class<?>[] initTypes, Object[] initValues) {
        return (StatefulBeanContext)this.createBeanContext();
    }

    @Override
    public BeanContext<?> createBeanContext() {
        return new StatefulBeanContext((SessionContainer)this, this.construct());
    }

    @Override
    protected ProxyFactory createProxyFactory(LocalBinding binding) {
        return new StatefulLocalProxyFactory((SessionContainer)this, binding);
    }

    @Override
    protected RemoteProxyFactory createRemoteProxyFactory(RemoteBinding binding) {
        Clustered clustered = this.getAnnotation(Clustered.class);
        if (clustered != null) {
            return new StatefulClusterProxyFactory(this, binding, clustered);
        }
        return new StatefulRemoteProxyFactory((SessionContainer)this, binding);
    }

    public void destroy(StatefulBeanContext obj) {
        this.invokePreDestroy(obj);
    }

    @Override
    public Object getMBean() {
        return this.mbean;
    }

    @Override
    public void start() throws Exception {
        try {
            super.start();
            Cache cacheConfig = this.getAnnotation(Cache.class);
            CacheFactoryRegistry registry = this.getCacheFactoryRegistry();
            Ejb3CacheFactory factory = registry.getCacheFactory(cacheConfig.value());
            this.cache = factory.createCache();
            this.cache.initialize(this);
            this.cache.start();
        }
        catch (Exception e) {
            try {
                this.stop();
            }
            catch (Exception ignore) {
                log.debug((Object)"Failed to cleanup after start() failure", (Throwable)ignore);
            }
            throw e;
        }
    }

    @Override
    public void stop() throws Exception {
        if (this.cache != null) {
            this.cache.stop();
        }
        super.stop();
    }

    public StatefulCache getCache() {
        return this.cache;
    }

    public CacheFactoryRegistry getCacheFactoryRegistry() {
        return this.getDeployment().getCacheFactoryRegistry();
    }

    public Object localInvoke(Object id, Method method, Object[] args) throws Throwable {
        return this.localInvoke(id, method, args, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object localHomeInvoke(Method method, Object[] args) throws Throwable {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        this.pushEnc();
        try {
            long hash = MethodHashing.calculateHash((Method)method);
            MethodInfo info = super.getMethodInfo(hash);
            if (info == null) {
                throw new RuntimeException("Could not resolve beanClass method from proxy call: " + method.toString());
            }
            Object object = this.invokeLocalHomeMethod(info, args);
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
            this.popEnc();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object localInvoke(Object id, Method method, Object[] args, FutureHolder provider) throws Throwable {
        long start = System.currentTimeMillis();
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        this.pushEnc();
        try {
            Object object;
            block16: {
                Method unadvisedMethod;
                MethodInfo info;
                block14: {
                    Object object2;
                    block15: {
                        block12: {
                            Object object3;
                            block13: {
                                long hash = MethodHashing.calculateHash((Method)method);
                                info = super.getMethodInfo(hash);
                                if (info == null) {
                                    throw new RuntimeException("Could not resolve beanClass method from proxy call: " + method.toString());
                                }
                                unadvisedMethod = info.getUnadvisedMethod();
                                try {
                                    this.invokeStats.callIn();
                                    if (unadvisedMethod == null || !this.isHomeMethod(unadvisedMethod)) break block12;
                                    object3 = this.invokeLocalHomeMethod(info, args);
                                    if (unadvisedMethod == null) break block13;
                                }
                                catch (Throwable throwable) {
                                    if (unadvisedMethod != null) {
                                        long end = System.currentTimeMillis();
                                        long elapsed = end - start;
                                        this.invokeStats.updateStats(unadvisedMethod, elapsed);
                                    }
                                    this.invokeStats.callOut();
                                    this.invokedMethod.pop();
                                    throw throwable;
                                }
                                long end = System.currentTimeMillis();
                                long elapsed = end - start;
                                this.invokeStats.updateStats(unadvisedMethod, elapsed);
                            }
                            this.invokeStats.callOut();
                            this.invokedMethod.pop();
                            return object3;
                        }
                        if (unadvisedMethod == null || !this.isEJBObjectMethod(unadvisedMethod)) break block14;
                        object2 = this.invokeEJBLocalObjectMethod(id, info, args);
                        if (unadvisedMethod == null) break block15;
                        long end = System.currentTimeMillis();
                        long elapsed = end - start;
                        this.invokeStats.updateStats(unadvisedMethod, elapsed);
                    }
                    this.invokeStats.callOut();
                    this.invokedMethod.pop();
                    return object2;
                }
                StatefulContainerInvocation nextInvocation = new StatefulContainerInvocation(info, id);
                nextInvocation.setAdvisor((Advisor)this);
                nextInvocation.setArguments(args);
                ProxyUtils.addLocalAsynchronousInfo(nextInvocation, provider);
                this.invokedMethod.push(new SessionContainer.InvokedMethod(this, true, method));
                object = nextInvocation.invokeNext();
                if (unadvisedMethod == null) break block16;
                long end = System.currentTimeMillis();
                long elapsed = end - start;
                this.invokeStats.updateStats(unadvisedMethod, elapsed);
            }
            this.invokeStats.callOut();
            this.invokedMethod.pop();
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
            this.popEnc();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object createSession(Class[] initTypes, Object[] initValues) {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        this.pushEnc();
        try {
            Thread.currentThread().setContextClassLoader(this.classloader);
            StatefulBeanContext ctx = this.getCache().create(initTypes, initValues);
            ctx.setInUse(false);
            Object object = ctx.getId();
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
            this.popEnc();
        }
    }

    @Override
    protected void destroySession(Object id) {
        this.getCache().remove(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InvocationResponse dynamicInvoke(Object target, Invocation invocation) throws Throwable {
        long start = System.currentTimeMillis();
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        StatefulContainerInvocation newSi = null;
        this.pushEnc();
        try {
            InvocationResponse response;
            block20: {
                Thread.currentThread().setContextClassLoader(this.classloader);
                StatefulRemoteInvocation si = (StatefulRemoteInvocation)invocation;
                MethodInfo info = super.getMethodInfo(si.getMethodHash());
                if (info == null) {
                    throw new RuntimeException("Could not resolve beanClass method from proxy call");
                }
                response = null;
                Method unadvisedMethod = info.getUnadvisedMethod();
                Object newId = null;
                try {
                    this.invokeStats.callIn();
                    if (info != null && unadvisedMethod != null && this.isHomeMethod(unadvisedMethod)) {
                        response = this.invokeHomeMethod(info, si);
                    } else if (info != null && unadvisedMethod != null && this.isEJBObjectMethod(unadvisedMethod)) {
                        response = this.invokeEJBObjectMethod(info, si);
                    } else {
                        if (si.getId() == null) {
                            StatefulBeanContext ctx = this.getCache().create(null, null);
                            newId = ctx.getId();
                        } else {
                            newId = si.getId();
                        }
                        newSi = new StatefulContainerInvocation(info, newId);
                        newSi.setArguments(si.getArguments());
                        newSi.setMetaData(si.getMetaData());
                        newSi.setAdvisor((Advisor)this);
                        Object rtn = null;
                        this.invokedMethod.push(new SessionContainer.InvokedMethod(this, false, unadvisedMethod));
                        rtn = newSi.invokeNext();
                        response = StatefulContainer.marshallResponse(invocation, rtn, newSi.getResponseContextInfo());
                        if (newId != null) {
                            response.addAttachment((Object)"NEW_ID", newId);
                        }
                    }
                    if (unadvisedMethod == null) break block20;
                }
                catch (Throwable throwable) {
                    InvocationResponse invocationResponse;
                    try {
                        Throwable exception = throwable;
                        if (newId != null) {
                            exception = new ForwardId(throwable, newId);
                        }
                        Map responseContext = null;
                        if (newSi != null) {
                            newSi.getResponseContextInfo();
                        }
                        invocationResponse = response = StatefulContainer.marshallException(invocation, exception, responseContext);
                        Thread.currentThread().setContextClassLoader(oldLoader);
                    }
                    catch (Throwable throwable2) {
                        throw throwable2;
                    }
                    finally {
                        if (unadvisedMethod != null) {
                            long end = System.currentTimeMillis();
                            long elapsed = end - start;
                            this.invokeStats.updateStats(unadvisedMethod, elapsed);
                        }
                        this.invokeStats.callOut();
                        this.invokedMethod.pop();
                    }
                    this.popEnc();
                    return invocationResponse;
                }
                long end = System.currentTimeMillis();
                long elapsed = end - start;
                this.invokeStats.updateStats(unadvisedMethod, elapsed);
            }
            this.invokeStats.callOut();
            this.invokedMethod.pop();
            InvocationResponse invocationResponse = response;
            return invocationResponse;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
            this.popEnc();
        }
    }

    @Override
    public TimerService getTimerService() {
        throw new UnsupportedOperationException("stateful bean doesn't support TimerService (EJB3 18.2#2)");
    }

    @Override
    public TimerService getTimerService(Object pKey) {
        return this.getTimerService();
    }

    @Override
    public void invokePostActivate(BeanContext beanContext) {
        for (Injector injector : this.injectors) {
            AccessibleObject field;
            if (!(injector instanceof JndiPropertyInjector) || (field = ((JndiPropertyInjector)injector).getAccessibleObject()).isAnnotationPresent(EJB.class) || !(field instanceof Field) || (((Field)field).getModifiers() & 0x80) <= 0) continue;
            injector.inject(beanContext);
        }
        this.callbackHandler.postActivate(beanContext);
    }

    @Override
    public void invokePrePassivate(BeanContext beanContext) {
        this.callbackHandler.prePassivate(beanContext);
    }

    @Override
    protected Class[] getHandledCallbacks() {
        return new Class[]{PostConstruct.class, PreDestroy.class, PostActivate.class, PrePassivate.class};
    }

    @Override
    public void invokeInit(Object bean, Class[] initParameterTypes, Object[] initParameterValues) {
        int numParameters = 0;
        if (initParameterTypes != null) {
            numParameters = initParameterTypes.length;
        }
        try {
            for (Method method : bean.getClass().getDeclaredMethods()) {
                if (numParameters != method.getParameterTypes().length || method.getAnnotation(Init.class) == null && this.resolveAnnotation(method, Init.class) == null) continue;
                if (initParameterTypes != null) {
                    Object[] parameters = this.getInitParameters(method, initParameterTypes, initParameterValues);
                    if (parameters == null) continue;
                    method.invoke(bean, parameters);
                    continue;
                }
                method.invoke(bean, new Object[0]);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected Object[] getInitParameters(Method method, Class[] initParameterTypes, Object[] initParameterValues) {
        if (method.getParameterTypes().length == initParameterTypes.length) {
            for (int i = 0; i < initParameterTypes.length; ++i) {
                Class actual;
                Class<?> formal = method.getParameterTypes()[i];
                if (StatefulContainer.isMethodInvocationConvertible(formal, (actual = initParameterTypes[i]) == null ? null : actual)) continue;
                return null;
            }
            return initParameterValues;
        }
        return null;
    }

    private static boolean isMethodInvocationConvertible(Class formal, Class actual) {
        if (actual == null && !formal.isPrimitive()) {
            return true;
        }
        if (actual != null && formal.isAssignableFrom(actual)) {
            return true;
        }
        if (formal.isPrimitive()) {
            if (formal == Boolean.TYPE && actual == Boolean.class) {
                return true;
            }
            if (formal == Character.TYPE && actual == Character.class) {
                return true;
            }
            if (formal == Byte.TYPE && actual == Byte.class) {
                return true;
            }
            if (formal == Short.TYPE && (actual == Short.class || actual == Byte.class)) {
                return true;
            }
            if (formal == Integer.TYPE && (actual == Integer.class || actual == Short.class || actual == Byte.class)) {
                return true;
            }
            if (formal == Long.TYPE && (actual == Long.class || actual == Integer.class || actual == Short.class || actual == Byte.class)) {
                return true;
            }
            if (formal == Float.TYPE && (actual == Float.class || actual == Long.class || actual == Integer.class || actual == Short.class || actual == Byte.class)) {
                return true;
            }
            if (formal == Double.TYPE && (actual == Double.class || actual == Float.class || actual == Long.class || actual == Integer.class || actual == Short.class || actual == Byte.class)) {
                return true;
            }
        }
        return false;
    }

    private Object invokeEJBLocalObjectMethod(Object id, MethodInfo info, Object[] args) throws Exception {
        Method unadvisedMethod = info.getUnadvisedMethod();
        if (unadvisedMethod.getName().equals("remove")) {
            this.destroySession(id);
            return null;
        }
        if (unadvisedMethod.getName().equals("getEJBLocalHome")) {
            Object bean = this.getCache().get(id).getInstance();
            return bean;
        }
        if (unadvisedMethod.getName().equals("getPrimaryKey")) {
            return id;
        }
        if (unadvisedMethod.getName().equals("isIdentical")) {
            EJBObject bean = (EJBObject)args[0];
            Object primaryKey = bean.getPrimaryKey();
            boolean isIdentical = id.equals(primaryKey);
            return isIdentical;
        }
        return null;
    }

    private Object invokeLocalHomeMethod(MethodInfo info, Object[] args) throws Exception {
        Method unadvisedMethod = info.getUnadvisedMethod();
        if (unadvisedMethod.getName().startsWith("create")) {
            Class[] initParameterTypes = new Class[]{};
            Object[] initParameterValues = new Object[]{};
            if (unadvisedMethod.getParameterTypes().length > 0) {
                initParameterTypes = unadvisedMethod.getParameterTypes();
                initParameterValues = args;
            }
            LocalBinding binding = (LocalBinding)this.resolveAnnotation(LocalBinding.class);
            StatefulLocalProxyFactory factory = new StatefulLocalProxyFactory((SessionContainer)this, binding);
            factory.init();
            Object proxy = factory.createProxy(initParameterTypes, initParameterValues);
            return proxy;
        }
        if (unadvisedMethod.getName().equals("remove")) {
            StatefulHandleImpl handle = (StatefulHandleImpl)args[0];
            this.destroySession(handle.id);
            return null;
        }
        return null;
    }

    @Override
    public Object createLocalProxy(Object id, LocalBinding binding) throws Exception {
        StatefulLocalProxyFactory factory = new StatefulLocalProxyFactory((SessionContainer)this, binding);
        factory.init();
        return factory.createProxy(id);
    }

    @Override
    public Object createRemoteProxy(Object id, RemoteBinding binding) throws Exception {
        StatefulRemoteProxyFactory factory = new StatefulRemoteProxyFactory((SessionContainer)this, binding);
        factory.init();
        if (id != null) {
            return factory.createProxy(id);
        }
        return factory.createProxy();
    }

    @Override
    public boolean isClustered() {
        return this.hasAnnotation(this.getBeanClass(), Clustered.class.getName());
    }

    protected InvocationResponse invokeHomeMethod(MethodInfo info, StatefulRemoteInvocation statefulInvocation) throws Throwable {
        Method unadvisedMethod = info.getUnadvisedMethod();
        if (unadvisedMethod.getName().startsWith("create")) {
            Class[] initParameterTypes = new Class[]{};
            Object[] initParameterValues = new Object[]{};
            if (unadvisedMethod.getParameterTypes().length > 0) {
                initParameterTypes = unadvisedMethod.getParameterTypes();
                initParameterValues = statefulInvocation.getArguments();
            }
            RemoteBinding binding = null;
            RemoteBindings bindings = (RemoteBindings)this.resolveAnnotation(RemoteBindings.class);
            binding = bindings != null ? bindings.value()[0] : (RemoteBinding)this.resolveAnnotation(RemoteBinding.class);
            StatefulContainerInvocation newStatefulInvocation = this.buildNewInvocation(info, statefulInvocation, initParameterTypes, initParameterValues);
            StatefulRemoteProxyFactory factory = new StatefulRemoteProxyFactory((SessionContainer)this, binding);
            factory.init();
            Object proxy = null;
            proxy = newStatefulInvocation.getId() != null ? factory.createProxy(newStatefulInvocation.getId()) : factory.createProxy();
            InvocationResponse response = StatefulContainer.marshallResponse((Invocation)statefulInvocation, proxy, newStatefulInvocation.getResponseContextInfo());
            if (newStatefulInvocation.getId() != null) {
                response.addAttachment((Object)"NEW_ID", newStatefulInvocation.getId());
            }
            return response;
        }
        if (unadvisedMethod.getName().equals("remove")) {
            StatefulHandleImpl handle = (StatefulHandleImpl)statefulInvocation.getArguments()[0];
            this.destroySession(handle.id);
            InvocationResponse response = new InvocationResponse(null);
            response.setContextInfo(statefulInvocation.getResponseContextInfo());
            return response;
        }
        if (unadvisedMethod.getName().equals("getEJBMetaData")) {
            RemoteBinding remoteBindingAnnotation;
            RemoteHome homeAnnotation;
            Class remote = null;
            Class home = null;
            Class<Object> pkClass = Object.class;
            HomeHandleImpl homeHandle = null;
            Remote remoteAnnotation = (Remote)this.resolveAnnotation(Remote.class);
            if (remoteAnnotation != null) {
                remote = remoteAnnotation.value()[0];
            }
            if ((homeAnnotation = (RemoteHome)this.resolveAnnotation(RemoteHome.class)) != null) {
                home = homeAnnotation.value();
            }
            if ((remoteBindingAnnotation = (RemoteBinding)this.resolveAnnotation(RemoteBinding.class)) != null) {
                homeHandle = new HomeHandleImpl(remoteBindingAnnotation.jndiBinding());
            }
            EJBMetaDataImpl metadata = new EJBMetaDataImpl(remote, home, pkClass, true, false, homeHandle);
            InvocationResponse response = StatefulContainer.marshallResponse((Invocation)statefulInvocation, metadata, null);
            return response;
        }
        if (unadvisedMethod.getName().equals("getHomeHandle")) {
            HomeHandleImpl homeHandle = null;
            RemoteBinding remoteBindingAnnotation = (RemoteBinding)this.resolveAnnotation(RemoteBinding.class);
            if (remoteBindingAnnotation != null) {
                homeHandle = new HomeHandleImpl(remoteBindingAnnotation.jndiBinding());
            }
            InvocationResponse response = StatefulContainer.marshallResponse((Invocation)statefulInvocation, homeHandle, null);
            return response;
        }
        return null;
    }

    protected InvocationResponse invokeEJBObjectMethod(MethodInfo info, StatefulRemoteInvocation statefulInvocation) throws Throwable {
        Method unadvisedMethod = info.getUnadvisedMethod();
        if (unadvisedMethod.getName().equals("getHandle")) {
            StatefulContainerInvocation newStatefulInvocation = this.buildInvocation(info, statefulInvocation);
            StatefulHandleImpl handle = new StatefulHandleImpl();
            handle.id = newStatefulInvocation.getId();
            RemoteBinding remoteBinding = (RemoteBinding)this.resolveAnnotation(RemoteBinding.class);
            if (remoteBinding != null) {
                handle.jndiName = remoteBinding.jndiBinding();
            }
            InvocationResponse response = StatefulContainer.marshallResponse((Invocation)statefulInvocation, handle, null);
            return response;
        }
        if (unadvisedMethod.getName().equals("remove")) {
            this.destroySession(statefulInvocation.getId());
            InvocationResponse response = new InvocationResponse(null);
            return response;
        }
        if (unadvisedMethod.getName().equals("getEJBHome")) {
            HomeHandleImpl homeHandle = null;
            RemoteBinding remoteBindingAnnotation = (RemoteBinding)this.resolveAnnotation(RemoteBinding.class);
            if (remoteBindingAnnotation != null) {
                homeHandle = new HomeHandleImpl(ProxyFactoryHelper.getHomeJndiName(this));
            }
            EJBHome ejbHome = homeHandle.getEJBHome();
            InvocationResponse response = StatefulContainer.marshallResponse((Invocation)statefulInvocation, ejbHome, null);
            return response;
        }
        if (unadvisedMethod.getName().equals("getPrimaryKey")) {
            Object id = statefulInvocation.getId();
            InvocationResponse response = StatefulContainer.marshallResponse((Invocation)statefulInvocation, id, null);
            return response;
        }
        if (unadvisedMethod.getName().equals("isIdentical")) {
            Object id = statefulInvocation.getId();
            EJBObject bean = (EJBObject)statefulInvocation.getArguments()[0];
            Object primaryKey = bean.getPrimaryKey();
            boolean isIdentical = id.equals(primaryKey);
            InvocationResponse response = StatefulContainer.marshallResponse((Invocation)statefulInvocation, isIdentical, null);
            return response;
        }
        return null;
    }

    private StatefulContainerInvocation buildNewInvocation(MethodInfo info, StatefulRemoteInvocation statefulInvocation, Class[] initParameterTypes, Object[] initParameterValues) {
        StatefulContainerInvocation newStatefulInvocation = null;
        StatefulBeanContext ctx = null;
        ctx = initParameterTypes.length > 0 ? this.getCache().create(initParameterTypes, initParameterValues) : this.getCache().create(null, null);
        Object newId = ctx.getId();
        newStatefulInvocation = new StatefulContainerInvocation(info, newId);
        newStatefulInvocation.setArguments(statefulInvocation.getArguments());
        newStatefulInvocation.setMetaData(statefulInvocation.getMetaData());
        newStatefulInvocation.setAdvisor((Advisor)this);
        return newStatefulInvocation;
    }

    private StatefulContainerInvocation buildInvocation(MethodInfo info, StatefulRemoteInvocation statefulInvocation) {
        StatefulContainerInvocation newStatefulInvocation = null;
        Object newId = null;
        if (statefulInvocation.getId() == null) {
            StatefulBeanContext ctx = this.getCache().create(null, null);
            newId = ctx.getId();
            newStatefulInvocation = new StatefulContainerInvocation(info, newId);
        } else {
            newStatefulInvocation = new StatefulContainerInvocation(info, statefulInvocation.getId());
        }
        newStatefulInvocation.setArguments(statefulInvocation.getArguments());
        newStatefulInvocation.setMetaData(statefulInvocation.getMetaData());
        newStatefulInvocation.setAdvisor((Advisor)this);
        return newStatefulInvocation;
    }

    public Object getBusinessObject(BeanContext beanContext, Class businessInterface) throws IllegalStateException {
        Class<?>[] remoteInterfaces;
        assert (beanContext != null) : "beanContext is null";
        assert (businessInterface != null) : "businessInterface is null";
        StatefulBeanContext ctx = (StatefulBeanContext)beanContext;
        SessionContainer container = ctx.getContainer();
        assert (container == this) : "beanContext not of this container (" + container + " != " + this + ")";
        boolean isRemote = false;
        boolean found = false;
        for (Class<?> intf : remoteInterfaces = ProxyFactoryHelper.getRemoteAndBusinessRemoteInterfaces(this)) {
            if (!intf.getName().equals(businessInterface.getName())) continue;
            isRemote = true;
            found = true;
            break;
        }
        if (!found) {
            Class<?>[] localInterfaces;
            for (Class<?> intf : localInterfaces = ProxyFactoryHelper.getLocalAndBusinessLocalInterfaces(this)) {
                if (!intf.getName().equals(businessInterface.getName())) continue;
                found = true;
                break;
            }
        }
        if (!found) {
            throw new IllegalStateException(businessInterface.getName() + " is not a business interface for container " + this);
        }
        for (ProxyFactory factory : this.proxyDeployer.getProxyFactories()) {
            if (isRemote && factory instanceof StatefulRemoteProxyFactory) {
                return ((StatefulRemoteProxyFactory)factory).createProxy(ctx.getId());
            }
            if (isRemote || !(factory instanceof StatefulLocalProxyFactory)) continue;
            return ((StatefulLocalProxyFactory)factory).createProxy(ctx.getId());
        }
        throw new IllegalStateException("Unable to create proxy for getBusinessObject as a proxy factory was not found");
    }

    @Override
    protected void removeHandle(Handle arg) throws Exception {
        arg.getEJBObject().remove();
    }
}

