/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.tx;

import java.lang.reflect.Method;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagementType;
import org.jboss.aop.Advisor;
import org.jboss.aop.joinpoint.Joinpoint;
import org.jboss.aop.joinpoint.MethodJoinpoint;
import org.jboss.aspects.tx.TxInterceptor;
import org.jboss.ejb3.annotation.TransactionTimeout;
import org.jboss.ejb3.stateful.StatefulContainer;
import org.jboss.ejb3.tx.BMTInterceptor;
import org.jboss.ejb3.tx.Ejb3TxPolicy;
import org.jboss.ejb3.tx.TxInterceptor;
import org.jboss.ejb3.tx.TxUtil;
import org.jboss.logging.Logger;

public class TxInterceptorFactory
extends org.jboss.aspects.tx.TxInterceptorFactory {
    private static final Logger log = Logger.getLogger(TxInterceptorFactory.class);
    private static final String TX_TYPE_REQUIRED = "REQUIRED";
    private static final String TX_TYPE_NOT_SUPPORTED = "NOTSUPPORTED";
    private static final String TX_TYPE_REQUIRES_NEW = "REQUIRESNEW";
    private static final String TX_TYPE_NEVER = "NEVER";

    protected String resolveTxType(Advisor advisor, Joinpoint jp) {
        Method method = ((MethodJoinpoint)jp).getMethod();
        TransactionAttribute tx = (TransactionAttribute)advisor.resolveAnnotation(method, TransactionAttribute.class);
        if (tx == null) {
            tx = (TransactionAttribute)advisor.resolveAnnotation(TransactionAttribute.class);
        }
        String value = TX_TYPE_REQUIRED;
        if (tx != null) {
            TransactionAttributeType type = tx.value();
            value = type == null ? TX_TYPE_REQUIRED : (type == TransactionAttributeType.NOT_SUPPORTED ? TX_TYPE_NOT_SUPPORTED : (type == TransactionAttributeType.REQUIRES_NEW ? TX_TYPE_REQUIRES_NEW : type.name()));
        }
        return value;
    }

    protected int resolveTransactionTimeout(Advisor advisor, Method method) {
        TransactionTimeout annotation = (TransactionTimeout)advisor.resolveAnnotation(method, TransactionTimeout.class);
        if (annotation == null) {
            annotation = (TransactionTimeout)advisor.resolveAnnotation(TransactionTimeout.class);
        }
        if (annotation != null) {
            return annotation.value();
        }
        return -1;
    }

    protected void initializePolicy() {
        this.policy = new Ejb3TxPolicy();
    }

    public Object createPerJoinpoint(Advisor advisor, Joinpoint jp) {
        TransactionManagementType type = TxUtil.getTransactionManagementType(advisor);
        if (type == TransactionManagementType.BEAN) {
            return new BMTInterceptor(TxUtil.getTransactionManager(), !(advisor instanceof StatefulContainer));
        }
        Method method = ((MethodJoinpoint)jp).getMethod();
        int timeout = this.resolveTransactionTimeout(advisor, method);
        if (this.policy == null) {
            // empty if block
        }
        super.initialize();
        String txType = this.resolveTxType(advisor, jp).toUpperCase();
        if (txType.equals(TX_TYPE_NEVER)) {
            return new TxInterceptor.Never(TxUtil.getTransactionManager(), this.policy);
        }
        if (txType.equals(TX_TYPE_REQUIRED)) {
            return new TxInterceptor.Required(TxUtil.getTransactionManager(), this.policy, timeout);
        }
        if (txType.equals(TX_TYPE_REQUIRES_NEW)) {
            return new TxInterceptor.RequiresNew(TxUtil.getTransactionManager(), this.policy, timeout);
        }
        if (txType.equals(TX_TYPE_NOT_SUPPORTED)) {
            return new TxInterceptor.NotSupported(TxUtil.getTransactionManager(), this.policy, timeout);
        }
        return super.createPerJoinpoint(advisor, jp);
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

