/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3;

import javax.management.DynamicMBean;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.ejb3.DependencyPolicy;
import org.jboss.ejb3.JmxClientKernelAbstraction;
import org.jboss.ejb3.JmxDependencyPolicy;
import org.jboss.ejb3.KernelAbstraction;
import org.jboss.ejb3.ServiceDelegateWrapper;
import org.jboss.logging.Logger;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.system.ServiceControllerMBean;
import org.jboss.system.ServiceMBeanSupport;

public class JmxKernelAbstraction
extends JmxClientKernelAbstraction
implements KernelAbstraction {
    private static final Logger log = Logger.getLogger(JmxKernelAbstraction.class);
    private MBeanServer server;
    private ServiceControllerMBean serviceController;
    private DeploymentInfo di;

    public JmxKernelAbstraction(DeploymentInfo di) {
        super(di.getServer());
        this.server = di.getServer();
        this.serviceController = (ServiceControllerMBean)MBeanProxyExt.create(ServiceControllerMBean.class, (ObjectName)ServiceControllerMBean.OBJECT_NAME, (MBeanServer)di.getServer());
        this.di = di;
    }

    public JmxKernelAbstraction(MBeanServer server) {
        super(server);
        this.serviceController = (ServiceControllerMBean)MBeanProxyExt.create(ServiceControllerMBean.class, (ObjectName)ServiceControllerMBean.OBJECT_NAME, (MBeanServer)server);
    }

    public void setMbeanServer(MBeanServer server) {
        this.server = server;
    }

    public void install(String name, DependencyPolicy dependencies, Object service) {
        if (!(service instanceof ServiceMBeanSupport) && !(service instanceof DynamicMBean)) {
            log.debug((Object)("creating wrapper delegate for: " + service.getClass().getName()));
            service = new ServiceDelegateWrapper(service);
        }
        JmxDependencyPolicy policy = (JmxDependencyPolicy)dependencies;
        try {
            log.info((Object)("installing MBean: " + name + " with dependencies:"));
            for (Object obj : policy.getDependencies()) {
                log.info((Object)("\t" + obj));
            }
            ObjectName on = new ObjectName(name);
            if (policy.getDependencies().contains(on)) {
                throw new IllegalStateException("circular dependencies detected");
            }
            this.server.registerMBean(service, on);
            this.addParentDependency(on);
            this.serviceController.create(on, policy.getDependencies());
            this.serviceController.start(on);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void addParentDependency(ObjectName on) {
        DeploymentInfo parent = this.di;
        while (parent.parent != null) {
            parent = parent.parent;
        }
        parent.mbeans.add(on);
    }

    private void removeParentDependency(ObjectName on) {
        DeploymentInfo parent = this.di;
        while (parent.parent != null) {
            parent = parent.parent;
        }
        parent.mbeans.remove(on);
    }

    public void installMBean(ObjectName on, DependencyPolicy dependencies, Object service) {
        JmxDependencyPolicy policy = (JmxDependencyPolicy)dependencies;
        try {
            this.server.registerMBean(service, on);
            this.addParentDependency(on);
            this.serviceController.create(on, policy.getDependencies());
            this.serviceController.start(on);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void uninstallMBean(ObjectName on) {
        try {
            this.serviceController.stop(on);
            this.serviceController.destroy(on);
            this.serviceController.remove(on);
            this.removeParentDependency(on);
            if (this.server.isRegistered(on)) {
                this.server.unregisterMBean(on);
            } else {
                log.warn((Object)(on + " is not registered"));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void uninstall(String name) {
        ObjectName on;
        try {
            on = new ObjectName(name);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.uninstallMBean(on);
    }
}

