/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.security;

import java.lang.reflect.Method;
import java.security.CodeSource;
import java.security.Permission;
import java.security.Policy;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.util.Set;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.DenyAll;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.ejb.EJBAccessException;
import javax.security.auth.Subject;
import javax.security.jacc.EJBMethodPermission;
import javax.security.jacc.EJBRoleRefPermission;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyConfigurationFactory;
import javax.security.jacc.PolicyContextException;
import org.jboss.aop.metadata.ClassMetaDataBinding;
import org.jboss.aop.metadata.ClassMetaDataLoader;
import org.jboss.aop.metadata.SimpleClassMetaDataBinding;
import org.jboss.aop.metadata.SimpleClassMetaDataLoader;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.annotation.SecurityDomain;
import org.jboss.ejb3.security.Ejb3PolicyConfigurationFactory;
import org.jboss.ejb3.security.SecurityActions;
import org.jboss.logging.Logger;
import org.jboss.security.RealmMapping;
import org.jboss.security.RunAsIdentity;

public class JaccHelper {
    static Logger log = Logger.getLogger(JaccHelper.class);

    public static PolicyConfiguration initialiseJacc(String contextID) throws Exception {
        log.trace((Object)("Initialising JACC Context for deployment: " + contextID));
        PolicyConfigurationFactory pcFactory = Ejb3PolicyConfigurationFactory.getPolicyConfigurationFactory();
        boolean removeExistingContext = true;
        PolicyConfiguration pc = pcFactory.getPolicyConfiguration(contextID, removeExistingContext);
        return pc;
    }

    public static void putJaccInService(PolicyConfiguration pc, DeploymentUnit di) throws Exception {
        DeploymentUnit parentUnit = di.getParent();
        if (parentUnit != null) {
            String parentContextId = parentUnit.getSimpleName();
            PolicyConfigurationFactory pcFactory = Ejb3PolicyConfigurationFactory.getPolicyConfigurationFactory();
            PolicyConfiguration parentpc = pcFactory.getPolicyConfiguration(parentContextId, false);
            if (parentpc != null) {
                parentpc.linkConfiguration(pc);
                pc.commit();
                log.trace((Object)"JACC Policy Configuration for deployment unit has been linked with parent");
                return;
            }
        }
        pc.commit();
        log.trace((Object)"JACC Policy Configuration for deployment unit has been put into service");
    }

    public static void putJaccInService(PolicyConfiguration pc, DeploymentInfo di) throws Exception {
        di.context.put("javax.security.jacc.PolicyConfiguration", pc);
        DeploymentInfo current = di;
        while (current.parent != null) {
            current = current.parent;
        }
        PolicyConfiguration parentPC = (PolicyConfiguration)current.context.get("javax.security.jacc.PolicyConfiguration");
        if (parentPC != null && parentPC != pc) {
            parentPC.linkConfiguration(pc);
        }
        pc.commit();
        log.trace((Object)"JACC Policy Configuration for deployment has been put in service");
    }

    public static void unregisterJacc(String contextID) throws Exception {
        PolicyConfigurationFactory pcFactory = Ejb3PolicyConfigurationFactory.getPolicyConfigurationFactory();
        PolicyConfiguration pc = pcFactory.getPolicyConfiguration(contextID, true);
        pc.delete();
    }

    public static void configureContainer(String jaccContextId, EJBContainer container) {
        try {
            JaccHelper.addJaccContextToContainer(jaccContextId, container);
            PolicyConfigurationFactory pcFactory = Ejb3PolicyConfigurationFactory.getPolicyConfigurationFactory();
            PolicyConfiguration pc = pcFactory.getPolicyConfiguration(jaccContextId, false);
            JaccHelper.addPermissions(container, pc);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void addPermissions(EJBContainer container, PolicyConfiguration pc) {
        SecurityDomain sd = (SecurityDomain)container.resolveAnnotation(SecurityDomain.class);
        PermitAll beanUnchecked = (PermitAll)container.resolveAnnotation(PermitAll.class);
        RolesAllowed beanPermissions = (RolesAllowed)container.resolveAnnotation(RolesAllowed.class);
        DeclareRoles beanDeclareRolesPerms = (DeclareRoles)container.resolveAnnotation(DeclareRoles.class);
        if (beanUnchecked != null && beanPermissions != null) {
            throw new RuntimeException("Cannot annotate a bean with both @Unchecked and @MethodPermissions");
        }
        String ejbName = container.getEjbName();
        if (beanDeclareRolesPerms != null) {
            String[] rolerefs = beanDeclareRolesPerms.value();
            int len = rolerefs != null ? rolerefs.length : 0;
            for (int i = 0; i < len; ++i) {
                try {
                    pc.addToRole(rolerefs[i], (Permission)new EJBRoleRefPermission(ejbName, rolerefs[i]));
                    continue;
                }
                catch (PolicyContextException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        for (Method m : container.getBeanClass().getMethods()) {
            EJBMethodPermission permission = new EJBMethodPermission(ejbName, null, m);
            log.trace((Object)("Creating permission: " + permission));
            PermitAll unchecked = (PermitAll)container.resolveAnnotation(m, PermitAll.class);
            RolesAllowed permissions = (RolesAllowed)container.resolveAnnotation(m, RolesAllowed.class);
            DenyAll exclude = (DenyAll)container.resolveAnnotation(m, DenyAll.class);
            int annotationCount = JaccHelper.getAnnotationCount(unchecked, permissions, exclude);
            if (annotationCount == 0 && beanPermissions == null && beanUnchecked == null) {
                try {
                    pc.addToUncheckedPolicy((Permission)permission);
                }
                catch (PolicyContextException e) {
                    throw new RuntimeException(e);
                }
            } else if (annotationCount > 1) {
                throw new RuntimeException("You can only use one of @PermitAll, @DenyAll or @RolesAllowed per method");
            }
            try {
                if (unchecked != null) {
                    pc.addToUncheckedPolicy((Permission)permission);
                    log.trace((Object)"Adding permission to unchecked policy");
                    continue;
                }
                if (permissions != null) {
                    JaccHelper.addToRole(pc, permission, permissions);
                    continue;
                }
                if (exclude != null) {
                    pc.addToExcludedPolicy((Permission)permission);
                    log.trace((Object)"Adding permission to excluded policy");
                    continue;
                }
                if (beanUnchecked != null) {
                    pc.addToUncheckedPolicy((Permission)permission);
                    log.trace((Object)"Adding permission to unchecked policy");
                    continue;
                }
                if (beanPermissions != null) {
                    JaccHelper.addToRole(pc, permission, beanPermissions);
                    continue;
                }
                pc.addToUncheckedPolicy((Permission)permission);
                log.trace((Object)"Adding permission to unchecked policy");
            }
            catch (PolicyContextException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static int getAnnotationCount(PermitAll u, RolesAllowed mp, DenyAll e) {
        int annotations = 0;
        if (u != null) {
            ++annotations;
        }
        if (mp != null) {
            ++annotations;
        }
        if (e != null) {
            ++annotations;
        }
        return annotations;
    }

    private static void addToRole(PolicyConfiguration pc, EJBMethodPermission p, RolesAllowed mp) throws PolicyContextException {
        String[] roles = mp.value();
        for (int i = 0; i < roles.length; ++i) {
            pc.addToRole(roles[i], (Permission)p);
            log.trace((Object)("Adding permission to role: " + roles[i]));
        }
    }

    private static void addJaccContextToContainer(String jaccContextId, EJBContainer container) {
        SimpleClassMetaDataLoader loader = SimpleClassMetaDataLoader.singleton;
        String name = container.getBeanClassName();
        SimpleClassMetaDataBinding jaccCtx = new SimpleClassMetaDataBinding((ClassMetaDataLoader)loader, name, "JACC", container.getBeanClassName());
        jaccCtx.addDefaultMetaData("JACC", "ctx", (Object)jaccContextId);
        container.addClassMetaData((ClassMetaDataBinding)jaccCtx);
    }

    public static void checkPermission(CodeSource ejbCS, EJBMethodPermission methodPerm, RealmMapping realmMapping) throws EJBAccessException {
        try {
            Policy policy = Policy.getPolicy();
            Subject caller = SecurityActions.getContextSubject();
            RunAsIdentity rai = SecurityActions.peekRunAsIdentity();
            Principal[] principals = null;
            if (rai != null) {
                Set runAsRoles = rai.getRunAsRoles();
                principals = new Principal[runAsRoles.size()];
                runAsRoles.toArray(principals);
            } else {
                Principal callerP = SecurityActions.getCallerPrincipal();
                Set principalSet = realmMapping.getUserRoles(callerP);
                if (principalSet == null) {
                    principals = new Principal[]{};
                } else {
                    principals = new Principal[principalSet.size()];
                    principalSet.toArray(principals);
                }
            }
            ProtectionDomain pd = new ProtectionDomain(ejbCS, null, null, principals);
            if (!policy.implies(pd, (Permission)methodPerm)) {
                String msg = "Denied: " + methodPerm + ", caller=" + caller;
                EJBAccessException e = new EJBAccessException(msg);
                throw e;
            }
        }
        catch (PolicyContextException e) {
            throw new RuntimeException(e);
        }
    }
}

