/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.stateful;

import java.lang.reflect.Method;
import javax.ejb.Remove;
import org.jboss.aop.Advisor;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.advice.AspectFactory;
import org.jboss.aop.joinpoint.Joinpoint;
import org.jboss.aop.joinpoint.MethodJoinpoint;
import org.jboss.ejb.RemoveImpl;
import org.jboss.ejb3.stateful.StatefulRemoveInterceptor;
import org.jboss.logging.Logger;

public class StatefulRemoveFactory
implements AspectFactory {
    private static final Logger log = Logger.getLogger(StatefulRemoveFactory.class);

    public Object createPerVM() {
        throw new IllegalStateException("PER_VM NOT APPLICABLE");
    }

    public Object createPerClass(Advisor advisor) {
        throw new IllegalStateException("PER_CLASS NOT APPLICABLE");
    }

    public Object createPerInstance(Advisor advisor, InstanceAdvisor instanceAdvisor) {
        throw new IllegalStateException("PER_INSTANCE NOT APPLICABLE");
    }

    public Object createPerJoinpoint(Advisor advisor, Joinpoint jp) {
        if (!(jp instanceof MethodJoinpoint)) {
            throw new IllegalArgumentException("Joinpoint is not a method: " + jp);
        }
        MethodJoinpoint methodJoinpoint = (MethodJoinpoint)MethodJoinpoint.class.cast(jp);
        Method method = methodJoinpoint.getMethod();
        Remove rm = (Remove)advisor.resolveAnnotation(method, Remove.class);
        if (rm == null) {
            log.warn((Object)("Cannot find @" + Remove.class.getName() + " for " + method + " assuming defaults"));
            rm = new RemoveImpl();
        }
        return new StatefulRemoveInterceptor(rm.retainIfException());
    }

    public Object createPerJoinpoint(Advisor advisor, InstanceAdvisor instanceAdvisor, Joinpoint jp) {
        throw new IllegalStateException("PER_CLASS_JOINPOINT NOT APPLICABLE");
    }

    public String getName() {
        return "StatefulRemoveInterceptor";
    }
}

