/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.client;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import javax.ejb.EJBException;
import javax.transaction.UserTransaction;
import org.jboss.ejb3.client.URLInjectorFactory;
import org.jboss.ejb3.client.Utils;
import org.jboss.injection.InjectionContainer;
import org.jboss.injection.InjectionHandler;
import org.jboss.injection.Injector;
import org.jboss.injection.InjectorFactory;
import org.jboss.injection.UserTransactionPropertyInjector;
import org.jboss.injection.lang.reflect.BeanProperty;
import org.jboss.logging.Logger;
import org.jboss.metadata.javaee.spec.EnvironmentEntryMetaData;
import org.jboss.metadata.javaee.spec.MessageDestinationReferenceMetaData;
import org.jboss.metadata.javaee.spec.RemoteEnvironment;
import org.jboss.metadata.javaee.spec.ResourceEnvironmentReferenceMetaData;
import org.jboss.metadata.javaee.spec.ResourceInjectionMetaData;
import org.jboss.metadata.javaee.spec.ResourceReferenceMetaData;
import org.omg.CORBA.ORB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientResourceHandler<X extends RemoteEnvironment>
implements InjectionHandler<X> {
    private static final Logger log = Logger.getLogger(ClientResourceHandler.class);
    private Class<?> clientClass;

    public ClientResourceHandler(Class<?> clientClass) {
        this.clientClass = clientClass;
    }

    private void loadEnvEntry(InjectionContainer container, Collection<EnvironmentEntryMetaData> envEntries) {
        for (EnvironmentEntryMetaData envEntry : envEntries) {
            String encName = "env/" + envEntry.getEnvEntryName();
            if (envEntry.getValue() == null) {
                log.debug((Object)("ignoring env-entry " + envEntry));
                continue;
            }
            Utils.injectionTarget(encName, (ResourceInjectionMetaData)envEntry, container);
        }
    }

    private void loadXmlResourceRefs(InjectionContainer container, Collection<ResourceReferenceMetaData> refs) {
        for (ResourceReferenceMetaData envRef : refs) {
            String encName = "env/" + envRef.getResourceRefName();
            if (envRef.getMappedName() == null || envRef.getMappedName().equals("")) {
                URLInjectorFactory factory;
                if (envRef.getResUrl() != null) {
                    try {
                        URL resURL = new URL(envRef.getResUrl().trim());
                        factory = new URLInjectorFactory(resURL);
                        Utils.createInjectors(container.getInjectors(), container.getClassloader(), factory, envRef.getInjectionTargets());
                        continue;
                    }
                    catch (MalformedURLException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (UserTransaction.class.getName().equals(envRef.getType())) {
                    final InjectionContainer ic = container;
                    factory = new InjectorFactory<UserTransactionPropertyInjector>(){

                        public UserTransactionPropertyInjector create(BeanProperty property) {
                            return new UserTransactionPropertyInjector(property, ic);
                        }
                    };
                    Utils.createInjectors(container.getInjectors(), container.getClassloader(), factory, envRef.getInjectionTargets());
                    continue;
                }
                if (ORB.class.getName().equals(envRef.getType())) {
                    encName = "java:comp/ORB";
                } else {
                    throw new RuntimeException("mapped-name is required for " + envRef.getResourceRefName() + " of deployment " + container.getIdentifier());
                }
            }
            Utils.injectionTarget(encName, (ResourceInjectionMetaData)envRef, container);
        }
    }

    private static void loadXmlResourceEnvRefs(InjectionContainer container, Collection<ResourceEnvironmentReferenceMetaData> refs) {
        for (ResourceEnvironmentReferenceMetaData envRef : refs) {
            String resTypeName = envRef.getType();
            String mappedName = envRef.getMappedName();
            try {
                if (resTypeName != null) {
                    Class<?> resType = Class.forName(resTypeName);
                    if (resType.equals(UserTransaction.class)) {
                        final InjectionContainer ic = container;
                        InjectorFactory<UserTransactionPropertyInjector> factory = new InjectorFactory<UserTransactionPropertyInjector>(){

                            public UserTransactionPropertyInjector create(BeanProperty property) {
                                return new UserTransactionPropertyInjector(property, ic);
                            }
                        };
                        if (envRef.getInjectionTargets() != null) {
                            Utils.createInjectors(container.getInjectors(), container.getClassloader(), factory, envRef.getInjectionTargets());
                            continue;
                        }
                        mappedName = "java:comp/UserTransaction";
                    } else if (resType.equals(ORB.class)) {
                        mappedName = "java:comp/ORB";
                    }
                }
            }
            catch (ClassNotFoundException e) {
                throw new EJBException((Exception)e);
            }
            String encName = "env/" + envRef.getResourceEnvRefName();
            if (mappedName == null || mappedName.equals("")) {
                throw new RuntimeException("mapped-name is required for " + envRef.getResourceEnvRefName() + " of deployment " + container.getIdentifier());
            }
            Utils.injectionTarget(encName, (ResourceInjectionMetaData)envRef, container);
        }
    }

    private static void loadXmlMessageDestinationRefs(InjectionContainer container, Collection<MessageDestinationReferenceMetaData> refs) {
        for (MessageDestinationReferenceMetaData envRef : refs) {
            String encName = "env/" + envRef.getMessageDestinationRefName();
            String jndiName = envRef.getMappedName();
            if (jndiName == null || jndiName.equals("")) {
                throw new RuntimeException("mapped-name or message-destination-link is required for " + envRef.getMessageDestinationRefName() + " of deployment " + container.getIdentifier());
            }
            Utils.injectionTarget(encName, (ResourceInjectionMetaData)envRef, container);
        }
    }

    public void loadXml(X xml, InjectionContainer container) {
        if (xml == null) {
            return;
        }
        if (xml.getMessageDestinationReferences() != null) {
            ClientResourceHandler.loadXmlMessageDestinationRefs(container, (Collection<MessageDestinationReferenceMetaData>)xml.getMessageDestinationReferences());
        }
        if (xml.getResourceEnvironmentReferences() != null) {
            ClientResourceHandler.loadXmlResourceEnvRefs(container, (Collection<ResourceEnvironmentReferenceMetaData>)xml.getResourceEnvironmentReferences());
        }
        if (xml.getResourceReferences() != null) {
            this.loadXmlResourceRefs(container, (Collection<ResourceReferenceMetaData>)xml.getResourceReferences());
        }
        if (xml.getEnvironmentEntries() != null) {
            this.loadEnvEntry(container, (Collection<EnvironmentEntryMetaData>)xml.getEnvironmentEntries());
        }
    }

    public void handleClassAnnotations(Class<?> clazz, InjectionContainer container) {
        throw new IllegalStateException("Annotations are not handled in the client");
    }

    public void handleMethodAnnotations(Method method, InjectionContainer container, Map<AccessibleObject, Injector> injectors) {
        throw new IllegalStateException("Annotations are not handled in the client");
    }

    public void handleFieldAnnotations(Field field, InjectionContainer container, Map<AccessibleObject, Injector> injectors) {
        throw new IllegalStateException("Annotations are not handled in the client");
    }
}

