/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.client;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.ejb3.BeanContext;
import org.jboss.injection.AbstractPropertyInjector;
import org.jboss.injection.PojoInjector;
import org.jboss.injection.lang.reflect.BeanProperty;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JndiPropertyInjector
extends AbstractPropertyInjector
implements PojoInjector {
    private static final Logger log = Logger.getLogger(JndiPropertyInjector.class);
    private String jndiName;
    private Context ctx;

    public JndiPropertyInjector(BeanProperty property, String jndiName, Context ctx) {
        super(property);
        this.jndiName = jndiName;
        this.ctx = ctx;
    }

    public void inject(BeanContext bctx) {
    }

    public Class<?> getInjectionClass() {
        return this.property.getType();
    }

    public void inject(BeanContext bctx, Object instance) {
    }

    public void inject(Object instance) {
        Object value = this.lookup(this.jndiName);
        log.trace((Object)("injecting " + value + " from " + this.jndiName + " into " + this.property + " of " + instance));
        this.property.set(instance, value);
    }

    protected Object lookup(String jndiName) {
        Object dependency;
        block11: {
            dependency = null;
            boolean trace = log.isTraceEnabled();
            try {
                if (trace) {
                    log.trace((Object)("Looking for enc entry: " + jndiName));
                }
                dependency = this.ctx.lookup(jndiName);
                if (trace) {
                    log.trace((Object)("Success: " + dependency));
                }
            }
            catch (NamingException e) {
                block10: {
                    if (trace) {
                        log.trace((Object)("Failed enc lookup: " + e.getExplanation()));
                    }
                    try {
                        if (trace) {
                            log.trace((Object)("Failed trying as global entry: " + jndiName));
                        }
                        InitialContext ictx = new InitialContext(this.ctx.getEnvironment());
                        dependency = ictx.lookup(jndiName);
                        if (trace) {
                            log.trace((Object)("Success: " + dependency));
                        }
                    }
                    catch (NamingException e2) {
                        if (!trace) break block10;
                        log.trace((Object)("Failed global lookup: " + e2.getExplanation()));
                    }
                }
                if (dependency != null) break block11;
                Throwable cause = e;
                while (cause.getCause() != null) {
                    cause = cause.getCause();
                }
                throw new RuntimeException("Unable to inject jndi dependency: " + jndiName + " into property " + this.property + ": " + cause.getMessage(), e);
            }
        }
        return dependency;
    }
}

