/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.deployers;

import java.util.Properties;
import java.util.Set;
import javax.management.MBeanServer;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.deployer.AbstractVFSRealDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.deployment.security.JaccPolicyUtil;
import org.jboss.deployment.spi.DeploymentEndpointResolver;
import org.jboss.ejb.deployers.MergedJBossMetaDataDeployer;
import org.jboss.ejb3.DeploymentScope;
import org.jboss.ejb3.Ejb3Deployment;
import org.jboss.ejb3.cache.CacheFactoryRegistry;
import org.jboss.ejb3.cache.persistence.PersistenceManagerFactoryRegistry;
import org.jboss.ejb3.deployers.Ejb3JBoss5Deployment;
import org.jboss.ejb3.deployers.JBoss5DeploymentScope;
import org.jboss.ejb3.deployers.JBoss5DeploymentUnit;
import org.jboss.ejb3.metadata.jpa.spec.PersistenceUnitsMetaData;
import org.jboss.ejb3.pool.PoolFactoryRegistry;
import org.jboss.ejb3.proxy.factory.RemoteProxyFactoryRegistry;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.metadata.ear.jboss.JBossAppMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.jpa.spec.PersistenceMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ejb3Deployer
extends AbstractVFSRealDeployer {
    private Set<String> allowedSuffixes;
    private Properties defaultPersistenceProperties;
    private boolean deploymentDescriptorRequired;
    private Set<String> ignoredJarsSet;
    private Kernel kernel;
    private MBeanServer mbeanServer;
    private CacheFactoryRegistry cacheFactoryRegistry;
    private PoolFactoryRegistry poolFactoryRegistry;
    private RemoteProxyFactoryRegistry remoteProxyFactoryRegistry;
    private PersistenceManagerFactoryRegistry persistenceManagerFactoryRegistry;
    private boolean scanWars = false;

    public Ejb3Deployer() {
        this.addInput(MergedJBossMetaDataDeployer.EJB_MERGED_ATTACHMENT_NAME);
        this.addInput(PersistenceUnitsMetaData.class);
        this.setOutput(Ejb3Deployment.class);
        this.setOutput(KernelDeployment.class);
    }

    public void deploy(VFSDeploymentUnit unit) throws DeploymentException {
        this.deploy(unit, (JBossMetaData)unit.getAttachment(JBossMetaData.class), (PersistenceMetaData)unit.getAttachment(PersistenceMetaData.class));
    }

    public void deploy(VFSDeploymentUnit unit, JBossMetaData metaData, PersistenceMetaData persistenceUnitsMetaData) throws DeploymentException {
        try {
            if (metaData != null && (metaData.isEJB2x() || metaData.isEJB1x())) {
                assert (persistenceUnitsMetaData == null) : "Found persistence units in legacy deployment";
                this.log.debug((Object)("Ignoring legacy EJB deployment " + unit));
                return;
            }
            if (unit.getAttachment(JBossWebMetaData.class) != null && !this.scanWars) {
                this.log.trace((Object)("Skipping web deployment: " + unit.getSimpleName()));
                return;
            }
            VirtualFile jar = unit.getRoot();
            if (jar.isLeaf() || this.ignoredJarsSet.contains(jar.getName())) {
                this.log.trace((Object)(((Object)((Object)this)).getClass().getName() + " ignoring: " + jar.getName()));
                return;
            }
            if (!this.hasAllowedSuffix(jar.getName())) {
                this.log.trace((Object)(((Object)((Object)this)).getClass().getName() + " suffix not allowed: " + jar.getName()));
                return;
            }
            if (this.isDeploymentDescriptorRequired() && metaData == null && persistenceUnitsMetaData == null) {
                this.log.trace((Object)(((Object)((Object)this)).getClass().getSimpleName() + " skipping deployment \"" + unit.getSimpleName() + "\", jar: \"" + jar.getName() + "\" - either EJB3 Deployment Descriptor or \"jboss.xml\" is required and neither were found."));
                return;
            }
            this.log.debug((Object)("********* " + ((Object)((Object)this)).getClass().getSimpleName() + " Begin Unit: " + unit.getSimpleName() + " jar: " + jar.getName()));
            JBoss5DeploymentScope scope = null;
            VFSDeploymentUnit parent = unit.getTopLevel();
            boolean initScopeDeployment = false;
            if (parent != null && (scope = (JBoss5DeploymentScope)parent.getAttachment(DeploymentScope.class)) == null) {
                boolean isEar;
                boolean bl = isEar = unit != unit.getTopLevel() || parent.isAttachmentPresent(JBossAppMetaData.class);
                if (parent.isAttachmentPresent(DeploymentEndpointResolver.class)) {
                    scope = new JBoss5DeploymentScope(parent, isEar);
                } else {
                    scope = new JBoss5DeploymentScope(parent, isEar, unit.getSimpleName());
                    initScopeDeployment = true;
                }
                parent.addAttachment(DeploymentScope.class, (Object)scope);
            }
            JBoss5DeploymentUnit du = new JBoss5DeploymentUnit(unit);
            du.setDefaultPersistenceProperties(this.defaultPersistenceProperties);
            Ejb3JBoss5Deployment deployment = new Ejb3JBoss5Deployment(du, this.kernel, this.mbeanServer, (DeploymentUnit)unit, scope, metaData, persistenceUnitsMetaData);
            if (initScopeDeployment) {
                scope.setDeployment(deployment);
            }
            deployment.setCacheFactoryRegistry(this.getCacheFactoryRegistry());
            deployment.setPersistenceManagerFactoryRegistry(this.getPersistenceManagerFactoryRegistry());
            deployment.setRemoteProxyFactoryRegistry(this.getRemoteProxyFactoryRegistry());
            deployment.setPoolFactoryRegistry(this.getPoolFactoryRegistry());
            if (scope != null) {
                scope.register(deployment);
            }
            deployment.create();
            if (deployment.getEjbContainers().size() == 0 && deployment.getPersistenceUnitDeployments().size() == 0) {
                this.log.trace((Object)("Found no containers in scanned jar, consider adding it to the ignore list: " + jar.getName() + " url: " + jar.toURL() + " unit: " + unit.getSimpleName()));
                deployment.destroy();
                return;
            }
            deployment.start();
            unit.addAttachment(Ejb3Deployment.class, (Object)deployment);
            unit.addAttachment(JaccPolicyUtil.IGNORE_ME_NAME, (Object)true, Boolean.class);
        }
        catch (Throwable t) {
            throw new DeploymentException("Error deploying " + unit.getSimpleName() + ": " + t.getMessage(), t);
        }
    }

    public Set<String> getAllowedSuffixes() {
        return this.allowedSuffixes;
    }

    public CacheFactoryRegistry getCacheFactoryRegistry() {
        return this.cacheFactoryRegistry;
    }

    public void setCacheFactoryRegistry(CacheFactoryRegistry cacheFactoryRegistry) {
        this.cacheFactoryRegistry = cacheFactoryRegistry;
    }

    public PoolFactoryRegistry getPoolFactoryRegistry() {
        return this.poolFactoryRegistry;
    }

    public void setPoolFactoryRegistry(PoolFactoryRegistry poolFactoryRegistry) {
        this.poolFactoryRegistry = poolFactoryRegistry;
    }

    public RemoteProxyFactoryRegistry getRemoteProxyFactoryRegistry() {
        return this.remoteProxyFactoryRegistry;
    }

    public void setRemoteProxyFactoryRegistry(RemoteProxyFactoryRegistry remoteProxyFactoryRegistry) {
        this.remoteProxyFactoryRegistry = remoteProxyFactoryRegistry;
    }

    public PersistenceManagerFactoryRegistry getPersistenceManagerFactoryRegistry() {
        return this.persistenceManagerFactoryRegistry;
    }

    public void setPersistenceManagerFactoryRegistry(PersistenceManagerFactoryRegistry persistenceManagerFactoryRegistry) {
        this.persistenceManagerFactoryRegistry = persistenceManagerFactoryRegistry;
    }

    public boolean isScanWars() {
        return this.scanWars;
    }

    public void setScanWars(boolean scanWars) {
        this.scanWars = scanWars;
    }

    private boolean hasAllowedSuffix(String name) {
        if (this.allowedSuffixes == null) {
            return true;
        }
        for (String suffix : this.allowedSuffixes) {
            if (!name.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    public boolean isDeploymentDescriptorRequired() {
        return this.deploymentDescriptorRequired;
    }

    public void setAllowedSuffixes(Set<String> s) {
        this.allowedSuffixes = s;
    }

    public void setDefaultPersistenceProperties(Properties p) {
        this.defaultPersistenceProperties = p;
    }

    public void setDeploymentDescriptorRequired(boolean b) {
        this.deploymentDescriptorRequired = b;
    }

    public void setIgnoredJarsSet(Set<String> s) {
        this.ignoredJarsSet = s;
    }

    public void setKernel(Kernel kernel) {
        this.kernel = kernel;
    }

    public void setMbeanServer(MBeanServer server) {
        this.mbeanServer = server;
    }

    public void undeploy(VFSDeploymentUnit unit) {
        Ejb3Deployment deployment = (Ejb3Deployment)unit.getAttachment(Ejb3Deployment.class);
        if (deployment == null) {
            return;
        }
        try {
            deployment.stop();
        }
        catch (Exception e) {
            this.log.warn((Object)("Failed to stop deployment " + deployment), (Throwable)e);
        }
        try {
            deployment.destroy();
        }
        catch (Exception e) {
            this.log.warn((Object)("Failed to destroy deployment " + deployment), (Throwable)e);
        }
    }
}

