/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.deployers;

import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.security.jacc.PolicyConfiguration;
import org.jboss.beans.metadata.plugins.AbstractSupplyMetaData;
import org.jboss.deployment.dependency.ContainerDependencyMetaData;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.DependencyPolicy;
import org.jboss.ejb3.DeploymentScope;
import org.jboss.ejb3.DeploymentUnit;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.Ejb3Deployment;
import org.jboss.ejb3.MCDependencyPolicy;
import org.jboss.ejb3.deployers.JBoss5DependencyPolicy;
import org.jboss.ejb3.deployers.JBossASKernel;
import org.jboss.ejb3.javaee.JavaEEComponent;
import org.jboss.kernel.Kernel;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;
import org.jboss.metadata.ejb.jboss.jndipolicy.spi.EjbDeploymentSummary;
import org.jboss.metadata.jpa.spec.PersistenceMetaData;

public class Ejb3JBoss5Deployment
extends Ejb3Deployment {
    private static Logger log = Logger.getLogger(Ejb3JBoss5Deployment.class);
    private org.jboss.deployers.structure.spi.DeploymentUnit jbossUnit;
    private Map<String, ContainerDependencyMetaData> endpoints;

    public Ejb3JBoss5Deployment(DeploymentUnit ejb3Unit, Kernel kernel, MBeanServer mbeanServer, org.jboss.deployers.structure.spi.DeploymentUnit jbossUnit, DeploymentScope deploymentScope, JBossMetaData metaData, PersistenceMetaData persistenceUnitsMetaData) {
        super(ejb3Unit, deploymentScope, metaData, persistenceUnitsMetaData);
        this.jbossUnit = jbossUnit;
        this.kernelAbstraction = new JBossASKernel(kernel, mbeanServer);
        this.mbeanServer = mbeanServer;
        org.jboss.deployers.structure.spi.DeploymentUnit topUnit = jbossUnit.getTopLevel();
        this.endpoints = (Map)topUnit.getAttachment("MappedReferenceMetaDataResolverDeployer.endpointMap");
    }

    protected PolicyConfiguration createPolicyConfiguration() throws Exception {
        return null;
    }

    protected void putJaccInService(PolicyConfiguration pc, DeploymentUnit ejb3Unit) {
    }

    public DependencyPolicy createDependencyPolicy(JavaEEComponent component) {
        return new JBoss5DependencyPolicy(component);
    }

    protected void registerEJBContainer(Container container) throws Exception {
        MCDependencyPolicy dependsPolicy = (MCDependencyPolicy)container.getDependencyPolicy();
        EJBContainer ejbContainer = (EJBContainer)container;
        JBossEnterpriseBeanMetaData beanMD = ejbContainer.getXml();
        ContainerDependencyMetaData cdmd = null;
        if (this.endpoints != null) {
            String ejbKey = "ejb/" + this.jbossUnit.getRelativePath() + "#" + container.getEjbName();
            cdmd = this.endpoints.get(ejbKey);
        } else {
            log.warn((Object)(this.jbossUnit + " has no ContainerDependencyMetaData attachment"));
        }
        if (cdmd != null) {
            for (String jndiName : cdmd.getJndiNames()) {
                String supplyName = "jndi:" + jndiName;
                AbstractSupplyMetaData supply = new AbstractSupplyMetaData((Object)supplyName);
                dependsPolicy.getSupplies().add(supply);
            }
        }
        this.generateContainerName(container, beanMD);
        super.registerEJBContainer(container);
    }

    private void generateContainerName(Container container, JBossEnterpriseBeanMetaData beanMD) {
        ObjectName on = container.getObjectName();
        assert (on != null) : "ObjectName was null";
        beanMD.setGeneratedContainerName(on.getCanonicalName());
    }

    private static EjbDeploymentSummary getUnitSummary(DeploymentUnit unit, JBossEnterpriseBeanMetaData beanMD) {
        ClassLoader loader = unit.getClassLoader();
        EjbDeploymentSummary summary = new EjbDeploymentSummary();
        summary.setBeanMD(beanMD);
        summary.setBeanClassName(beanMD.getEjbClass());
        summary.setDeploymentName(unit.getShortName());
        String baseName = unit.getRootFile().getName();
        summary.setDeploymentScopeBaseName(baseName);
        summary.setEjbName(beanMD.getEjbName());
        summary.setLoader(loader);
        summary.setLocal(beanMD.isMessageDriven());
        if (beanMD instanceof JBossSessionBeanMetaData) {
            JBossSessionBeanMetaData sbeanMD = (JBossSessionBeanMetaData)beanMD;
            summary.setStateful(sbeanMD.isStateful());
        }
        summary.setService(beanMD.isService());
        return summary;
    }
}

