/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.embedded.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.bootstrap.basic.BasicBootstrap;
import org.jboss.kernel.plugins.deployment.AbstractKernelDeployer;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.xb.binding.JBossXBException;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;
import org.jboss.xb.binding.sunday.unmarshalling.SingletonSchemaResolverFactory;

public class BeanCompilerTester {
    protected static Kernel createKernel() {
        BasicBootstrap bootstrap1 = new BasicBootstrap();
        bootstrap1.run();
        return bootstrap1.getKernel();
    }

    protected static void deploy(KernelDeployment deployment) throws Throwable {
        AbstractKernelDeployer deployer = new AbstractKernelDeployer(BeanCompilerTester.createKernel());
        deployer.deploy(deployment);
        deployer.validate();
    }

    public static void main(String[] args) throws Throwable {
        System.out.println("compiling: " + args[0]);
        File fp = new File(args[0]);
        KernelDeployment deployment = BeanCompilerTester.parse(fp);
        long start = System.currentTimeMillis();
        FileOutputStream fos = new FileOutputStream(args[0] + ".bin");
        ObjectOutputStream oos = new ObjectOutputStream(fos);
        oos.writeObject(deployment);
        oos.close();
        fos.close();
        FileInputStream fis = new FileInputStream(args[0] + ".bin");
        ObjectInputStream ois = new ObjectInputStream(fis);
        KernelDeployment deployment2 = (KernelDeployment)ois.readObject();
        ois.close();
        fis.close();
        long end = System.currentTimeMillis() - start;
        System.out.println("object loading took: " + end);
        System.out.println("deployment1");
        BeanCompilerTester.deploy(deployment);
        System.out.println("deployment2");
        BeanCompilerTester.deploy(deployment2);
    }

    public static KernelDeployment parse(File fp) throws JBossXBException, MalformedURLException {
        SchemaBindingResolver resolver = SingletonSchemaResolverFactory.getInstance().getSchemaBindingResolver();
        long start = System.currentTimeMillis();
        UnmarshallerFactory factory = UnmarshallerFactory.newInstance();
        Unmarshaller unmarshaller = factory.newUnmarshaller();
        KernelDeployment deployment = (KernelDeployment)unmarshaller.unmarshal(fp.toURL().toString(), resolver);
        long end = System.currentTimeMillis() - start;
        System.out.println("XML parsing took: " + end);
        return deployment;
    }
}

