/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.embedded.test.bootstrap.unit;

import java.sql.Connection;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.embedded.Bootstrap;
import org.jboss.embedded.adapters.JMXKernel;

public class BootstrapTestCase
extends TestCase {
    public BootstrapTestCase() {
        super("BootstrapTestCase");
    }

    public static Test suite() throws Exception {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(BootstrapTestCase.class);
        TestSetup wrapper = new TestSetup((Test)suite){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void setUp() {
                long start = System.currentTimeMillis();
                try {
                    BootstrapTestCase.startupEmbeddedJboss();
                }
                finally {
                    System.out.println("Bootstrap took " + (System.currentTimeMillis() - start) + " (ms)");
                }
            }

            protected void tearDown() {
                BootstrapTestCase.shutdownEmbeddedJboss();
            }
        };
        return wrapper;
    }

    public static void startupEmbeddedJboss() {
        try {
            Bootstrap.getInstance().bootstrap();
        }
        catch (DeploymentException e) {
            throw new RuntimeException("Failed to bootstrap", e);
        }
    }

    public static void shutdownEmbeddedJboss() {
        Bootstrap.getInstance().shutdown();
    }

    public void testDefaultDS() throws Exception {
        this.outputJNDI();
        InitialContext ctx = new InitialContext();
        DataSource ds = (DataSource)ctx.lookup("java:/DefaultDS");
        Connection conn = ds.getConnection();
        conn.close();
    }

    private void outputJNDI() throws InstanceNotFoundException, MBeanException, ReflectionException, MalformedObjectNameException {
        MBeanServer server = BootstrapTestCase.getMBeanServer();
        String xml = (String)server.invoke(new ObjectName("jboss:service=JNDIView"), "listXML", null, null);
        System.out.println(xml);
    }

    private static MBeanServer getMBeanServer() {
        JMXKernel jmxKernel = (JMXKernel)Bootstrap.getInstance().getKernel().getRegistry().getEntry((Object)"JMXKernel").getTarget();
        MBeanServer server = jmxKernel.getMbeanServer();
        return server;
    }
}

