/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.embedded.test.ejb.unit;

import java.util.Hashtable;
import javax.ejb.EJBAccessException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.naming.InitialContext;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.embedded.Bootstrap;
import org.jboss.embedded.DeploymentGroup;
import org.jboss.embedded.adapters.JMXKernel;
import org.jboss.embedded.test.ejb.Customer;
import org.jboss.embedded.test.ejb.DAO;
import org.jboss.embedded.test.ejb.Secured;

public class EjbTestCase
extends TestCase {
    public EjbTestCase() {
        super("BootstrapTestCase");
    }

    public static Test suite() throws Exception {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(EjbTestCase.class);
        TestSetup wrapper = new TestSetup((Test)suite){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void setUp() {
                long start = System.currentTimeMillis();
                try {
                    EjbTestCase.startupEmbeddedJboss();
                }
                finally {
                    System.out.println("Bootstrap took " + (System.currentTimeMillis() - start) + " (ms)");
                }
            }

            protected void tearDown() {
                EjbTestCase.shutdownEmbeddedJboss();
            }
        };
        return wrapper;
    }

    public static void startupEmbeddedJboss() {
        try {
            Bootstrap.getInstance().bootstrap();
        }
        catch (DeploymentException e) {
            throw new RuntimeException("Failed to bootstrap", e);
        }
    }

    public static void shutdownEmbeddedJboss() {
        Bootstrap.getInstance().shutdown();
    }

    private static void outputJNDI() throws InstanceNotFoundException, MBeanException, ReflectionException, MalformedObjectNameException {
        MBeanServer server = EjbTestCase.getMBeanServer();
        String xml = (String)server.invoke(new ObjectName("jboss:service=JNDIView"), "listXML", null, null);
        System.out.println(xml);
    }

    private static MBeanServer getMBeanServer() {
        JMXKernel jmxKernel = (JMXKernel)Bootstrap.getInstance().getKernel().getRegistry().getEntry((Object)"JMXKernel").getTarget();
        MBeanServer server = jmxKernel.getMbeanServer();
        return server;
    }

    public void testSimpleEjb() throws Exception {
        DeploymentGroup group = Bootstrap.getInstance().createDeploymentGroup();
        group.addClasspath("ejb-test.jar");
        group.process();
        EjbTestCase.outputJNDI();
        InitialContext ctx = new InitialContext();
        DAO dao = (DAO)ctx.lookup("DAOBean/local");
        Customer cust = dao.createCustomer("Bill");
        cust = dao.findCustomer("Bill");
        assert (cust != null);
        assert (cust.getName().equals("Bill"));
        group.undeploy();
    }

    public void testSimpleEjb2() throws Exception {
        DeploymentGroup group = Bootstrap.getInstance().createDeploymentGroup();
        group.addClasspath("ejb-test.jar");
        group.process();
        EjbTestCase.outputJNDI();
        InitialContext ctx = new InitialContext();
        DAO dao = (DAO)ctx.lookup("DAOBean/local");
        Customer cust = dao.createCustomer("Bill");
        cust = dao.findCustomer("Bill");
        assert (cust != null);
        assert (cust.getName().equals("Bill"));
        group.undeploy();
    }

    public void testSecurity() throws Exception {
        DeploymentGroup group = Bootstrap.getInstance().createDeploymentGroup();
        group.addClasspath("ejb-test.jar");
        group.process();
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.security.principal", "scott");
        env.put("java.naming.security.credentials", "invalidpassword");
        InitialContext ctx = new InitialContext(env);
        Secured secured = (Secured)ctx.lookup("SecuredBean/local");
        boolean exceptionThrown = false;
        try {
            secured.allowed();
        }
        catch (EJBAccessException ignored) {
            exceptionThrown = true;
        }
        EjbTestCase.assertTrue((String)"Security exception not thrown for invalid password", (boolean)exceptionThrown);
        env.put("java.naming.security.credentials", "password");
        ctx = new InitialContext(env);
        secured.allowed();
        exceptionThrown = false;
        try {
            secured.nobody();
        }
        catch (EJBAccessException ignored) {
            exceptionThrown = true;
        }
        EjbTestCase.assertTrue((String)"Security exception not thrown for invalid role", (boolean)exceptionThrown);
        group.undeploy();
    }
}

