/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.embedded.test.idetesting;

import javax.naming.InitialContext;
import junit.framework.TestCase;
import org.jboss.embedded.Bootstrap;
import org.jboss.embedded.junit.EmbeddedTestSetup;
import org.jboss.embedded.test.vfs.Customer;
import org.jboss.embedded.test.vfs.DAO;
import org.jboss.embedded.test.vfs.HelloWorld;
import org.jboss.embedded.test.vfs.HelloWorldBean;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.plugins.context.vfs.AssembledContextFactory;
import org.jboss.virtual.plugins.context.vfs.AssembledDirectory;

public class VfsTestCase
extends TestCase {
    public VfsTestCase() {
        super("BootstrapTestCase");
    }

    protected void setUp() throws Exception {
        EmbeddedTestSetup.testSetup();
    }

    protected void tearDown() throws Exception {
        EmbeddedTestSetup.testTearDown();
    }

    public void testEJB() throws Exception {
        AssembledDirectory jar = AssembledContextFactory.getInstance().create("vfs-test.jar");
        jar.addClass(HelloWorld.class);
        jar.addClass(HelloWorldBean.class);
        Bootstrap.getInstance().deploy((VirtualFile)jar);
        HelloWorld hello = (HelloWorld)new InitialContext().lookup("HelloWorldBean/local");
        hello.hello();
        Bootstrap.getInstance().undeploy((VirtualFile)jar);
    }

    public void testVfs() throws Exception {
        AssembledDirectory jar = AssembledContextFactory.getInstance().create("vfs-test2.jar");
        String[] includes = new String[]{"org/jboss/embedded/test/vfs/*.class"};
        jar.addResources(DAO.class, includes, null);
        jar.mkdir("META-INF").addResource("vfs-test-persistence.xml", "persistence.xml");
        Bootstrap.getInstance().deploy((VirtualFile)jar);
        DAO dao = (DAO)new InitialContext().lookup("DAOBean/local");
        dao.create("Bill");
        Customer cust = dao.find("Bill");
        VfsTestCase.assertNotNull((Object)cust);
    }
}

