/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.embedded.test.mdb.unit;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.embedded.Bootstrap;
import org.jboss.embedded.DeploymentGroup;
import org.jboss.embedded.test.mdb.ExampleMDB;

public class MdbTestCase
extends TestCase {
    public MdbTestCase() {
        super("BootstrapTestCase");
    }

    public static Test suite() throws Exception {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(MdbTestCase.class);
        TestSetup wrapper = new TestSetup((Test)suite){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void setUp() {
                long start = System.currentTimeMillis();
                try {
                    MdbTestCase.startupEmbeddedJboss();
                }
                finally {
                    System.out.println("Bootstrap took " + (System.currentTimeMillis() - start) + " (ms)");
                }
            }

            protected void tearDown() {
                MdbTestCase.shutdownEmbeddedJboss();
            }
        };
        return wrapper;
    }

    public static void startupEmbeddedJboss() {
        try {
            Bootstrap.getInstance().bootstrap();
        }
        catch (DeploymentException e) {
            throw new RuntimeException("Failed to bootstrap", e);
        }
    }

    public static void shutdownEmbeddedJboss() {
        Bootstrap.getInstance().shutdown();
    }

    public void testSimpleEjb() throws Exception {
        MdbTestCase.sendMessage();
    }

    private static void sendMessage() throws DeploymentException, NamingException, JMSException, InterruptedException {
        DeploymentGroup group = Bootstrap.getInstance().createDeploymentGroup();
        group.addClasspath("mdb-test.jar");
        group.process();
        ExampleMDB.executed = false;
        InitialContext ctx = new InitialContext();
        ConnectionFactory factory = (ConnectionFactory)ctx.lookup("ConnectionFactory");
        Destination destination = (Destination)ctx.lookup("queue/example");
        MdbTestCase.assertNotNull((Object)destination);
        Connection conn = factory.createConnection();
        Session session = conn.createSession(false, 1);
        TextMessage message = session.createTextMessage("hello");
        MessageProducer producer = session.createProducer(destination);
        producer.send((Message)message);
        session.close();
        conn.close();
        Thread.sleep(5000L);
        MdbTestCase.assertTrue((boolean)ExampleMDB.executed);
    }
}

