/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hibernate.jmx;

import java.net.URL;
import java.util.Set;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileFilter;
import org.jboss.virtual.VirtualFileVisitor;
import org.jboss.virtual.VisitorAttributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateMappingVisitor
implements VirtualFileVisitor {
    private Set<URL> urls;
    private static final VisitorAttributes MAPPING_ATTRIBUTES = new MappingVisitorAttributes();

    public HibernateMappingVisitor(Set<URL> urls) {
        if (urls == null) {
            throw new IllegalArgumentException("Null urls");
        }
        this.urls = urls;
    }

    public VisitorAttributes getAttributes() {
        return MAPPING_ATTRIBUTES;
    }

    public void visit(VirtualFile vf) {
        try {
            if (this.isMapping(vf)) {
                this.urls.add(vf.toURL());
            }
        }
        catch (Exception e) {
            new RuntimeException("Visit failed: " + e);
        }
    }

    protected boolean isMapping(VirtualFile vf) {
        return vf.getName().indexOf(".hbm.xml") > 0;
    }

    private static class MappingVisitorAttributes
    extends VisitorAttributes {
        public MappingVisitorAttributes() {
            this.setIgnoreErrors(true);
            this.setIncludeHidden(false);
            this.setIncludeRoot(false);
            this.setLeavesOnly(false);
            this.setRecurseFilter((VirtualFileFilter)RECURSE_ALL);
        }
    }
}

