/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hibernate.jmx;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.SessionFactory;
import org.hibernate.Version;
import org.hibernate.cache.jbc.JndiMultiplexedJBossCacheRegionFactory;
import org.hibernate.cache.jbc.JndiSharedJBossCacheRegionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.jmx.StatisticsService;
import org.hibernate.jmx.StatisticsServiceMBean;
import org.hibernate.transaction.JBossTransactionManagerLookup;
import org.hibernate.transaction.JTATransactionFactory;
import org.jboss.aop.microcontainer.aspects.jmx.JMX;
import org.jboss.beans.metadata.api.annotations.Inject;
import org.jboss.beans.metadata.api.model.FromContext;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.hibernate.ListenerInjector;
import org.jboss.hibernate.deployers.metadata.BaseNamedElement;
import org.jboss.hibernate.jmx.HibernateMBean;
import org.jboss.hibernate.jmx.HibernateMappingVisitor;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.logging.Logger;
import org.jboss.util.naming.Util;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hibernate
implements HibernateMBean {
    private static final Logger log = Logger.getLogger(Hibernate.class);
    public static final String SESSION_FACTORY_CREATE = "hibernate.sessionfactory.create";
    public static final String SESSION_FACTORY_DESTROY = "hibernate.sessionfactory.destroy";
    private static final String DATASOURCE_NAME = "datasourceName";
    private static final String DIALECT = "dialect";
    private static final String DEFAULT_SCHEMA = "defaultSchema";
    private static final String DEFAULT_CATALOG = "defaultCatalog";
    private static final String SQL_COMMENTS_ENABLED = "sqlCommentsEnabled";
    private static final String MAX_FETCH_DEPTH = "maxFetchDepth";
    private static final String JDBC_FETCH_SIZE = "jdbcFetchSize";
    private static final String JDBC_BATCH_SIZE = "jdbcBatchSize";
    private static final String BATCH_VERSIONED_DATA_ENABLED = "batchVersionedDataEnabled";
    private static final String JDBC_SCROLLABLE_RESULT_SET_ENABLED = "jdbcScrollableResultSetEnabled";
    private static final String GET_GENERATED_KEYS_ENABLED = "getGeneratedKeysEnabled";
    private static final String STREAMS_FOR_BINARY_ENABLED = "streamsForBinaryEnabled";
    private static final String HBM2DDL_AUTO = "hbm2ddlAuto";
    private static final String QUERY_SUBSTITUTIONS = "querySubstitutions";
    private static final String SHOW_SQL_ENABLED = "showSqlEnabled";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final String SECOND_LEVEL_CACHE_ENABLED = "secondLevelCacheEnabled";
    private static final String QUERY_CACHE_ENABLED = "queryCacheEnabled";
    private static final String CACHE_PROVIDER_CLASS = "cacheProviderClass";
    private static final String CACHE_REGION_FACTORY_CLASS = "cacheRegionFactoryClass";
    private static final String DEPLOYED_CACHE_JNDI_NAME = "deployedCacheJndiName";
    private static final String DEPLOYED_CACHE_MANAGER_JNDI_NAME = "deployedCacheManagerJndiName";
    private static final String MINIMAL_PUTS_ENABLED = "minimalPutsEnabled";
    private static final String CACHE_REGION_PREFIX = "cacheRegionPrefix";
    private static final String STRUCTURED_CACHE_ENTRIES_ENABLED = "useStructuredCacheEntriesEnabled";
    private static final String STAT_GENERATION_ENABLED = "statGenerationEnabled";
    private static final String REFLECTION_OPTIMIZATION_ENABLED = "reflectionOptimizationEnabled";
    private String sessionFactoryName;
    private static final String SESSION_FACTORY_INTERCEPTOR = "sessionFactoryInterceptor";
    private String sessionFactoryInterceptor;
    private static final String LISTENER_INJECTOR = "listenerInjector";
    private String listenerInjector;
    private static final String HAR_URL = "harUrl";
    private URL harUrl;
    private static final String SCAN_FOR_MAPPINGS_ENABLED = "scanForMappingsEnabled";
    private boolean scanForMappingsEnabled = false;
    private final Map<String, Object> configurationElements = Collections.synchronizedMap(new HashMap());
    private Properties sessionFactoryProperties;
    private VirtualFile root;
    private boolean dirty = false;
    private Date runningSince;
    private SessionFactory sessionFactory;
    private String hibernateStatisticsServiceName;
    private boolean bindInJndi = true;
    private Object beanName;
    private KernelController controller;

    public Hibernate() {
    }

    public Hibernate(VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException("Null root file");
        }
        this.root = root;
    }

    protected Hibernate(VirtualFile root, boolean bindInJndi) {
        this.root = root;
        this.bindInJndi = bindInJndi;
    }

    @Inject(fromContext=FromContext.NAME)
    public void setBeanName(Object beanName) {
        this.beanName = beanName;
    }

    @Inject(bean="jboss.kernel:service=KernelController")
    public void setController(KernelController controller) {
        this.controller = controller;
    }

    public Properties getConfigurationProperties() {
        Properties props = new Properties();
        if (this.sessionFactoryProperties == null) {
            for (Map.Entry<String, Object> coEntry : this.configurationElements.entrySet()) {
                props.setProperty(coEntry.getKey(), coEntry.getValue().toString());
            }
        } else {
            return new Properties(this.sessionFactoryProperties);
        }
        return props;
    }

    public Set<BaseNamedElement> getConfigurationElements() {
        HashSet<BaseNamedElement> result = new HashSet<BaseNamedElement>();
        for (Map.Entry<String, Object> entry : this.configurationElements.entrySet()) {
            BaseNamedElement element = new BaseNamedElement();
            element.setName(entry.getKey());
            element.setValue(entry.getValue());
            result.add(element);
        }
        return result;
    }

    public void setConfigurationElements(Set<BaseNamedElement> elements) {
        if (elements != null) {
            for (BaseNamedElement element : elements) {
                String name = element.getName();
                Object value = element.getValue();
                if (SESSION_FACTORY_INTERCEPTOR.equals(name) && value != null) {
                    this.setSessionFactoryInterceptor(value.toString());
                    continue;
                }
                if (LISTENER_INJECTOR.equals(name) && value != null) {
                    this.setListenerInjector(value.toString());
                    continue;
                }
                if (HAR_URL.equals(name) && value != null) {
                    try {
                        this.setHarUrl(new URL(value.toString()));
                        continue;
                    }
                    catch (MalformedURLException e) {
                        throw new IllegalArgumentException("Value " + value + " for property " + name + " is not a valid URL", e);
                    }
                }
                if (SCAN_FOR_MAPPINGS_ENABLED.equals(name) && value != null) {
                    this.setScanForMappingsEnabled(Boolean.valueOf(value.toString()));
                    continue;
                }
                this.configurationElements.put(element.getName(), element.getValue());
            }
        }
    }

    public void start() throws Throwable {
        log.debug((Object)("Hibernate MBean starting; " + this));
        if (this.sessionFactory != null) {
            this.destroySessionFactory();
        }
        this.buildSessionFactory();
    }

    public void stop() throws Exception {
        this.destroySessionFactory();
    }

    private void buildSessionFactory() throws Throwable {
        log.debug((Object)("Building SessionFactory; " + this));
        Configuration cfg = new Configuration();
        cfg.getProperties().clear();
        ListenerInjector listenerInjector = this.generateListenerInjectorInstance();
        if (listenerInjector != null) {
            listenerInjector.injectListeners(this.beanName, cfg);
        }
        this.transferSettings(cfg.getProperties());
        this.handleMappings(cfg);
        Interceptor interceptorInstance = this.generateInterceptorInstance();
        if (interceptorInstance != null) {
            cfg.setInterceptor(interceptorInstance);
        }
        this.sessionFactoryProperties = new Properties(cfg.getProperties());
        this.sessionFactory = cfg.buildSessionFactory();
        try {
            if (this.controller != null && this.sessionFactory.getStatistics() != null && this.sessionFactory.getStatistics().isStatisticsEnabled()) {
                String serviceName = this.beanName.toString();
                serviceName = serviceName.indexOf("type=service") != -1 ? serviceName.replaceAll("type=service", "type=stats") : serviceName + ",type=stats";
                this.hibernateStatisticsServiceName = serviceName;
                StatisticsService hibernateStatisticsService = new StatisticsService();
                hibernateStatisticsService.setSessionFactory(this.sessionFactory);
                BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)this.hibernateStatisticsServiceName, (String)StatisticsService.class.getName());
                StringBuffer buffer = new StringBuffer();
                buffer.append("@").append(JMX.class.getName()).append("(name=\"").append(this.hibernateStatisticsServiceName).append("JMX\"");
                buffer.append(", exposedInterface=").append(StatisticsServiceMBean.class.getName()).append(".class, registerDirectly=true)");
                String jmxAnnotation = buffer.toString();
                builder.addAnnotation(jmxAnnotation);
                this.controller.install(builder.getBeanMetaData(), (Object)hibernateStatisticsService);
            }
            this.bind();
        }
        catch (Exception e) {
            this.forceCleanup();
            throw e;
        }
        this.dirty = false;
        this.runningSince = new Date();
        log.info((Object)("SessionFactory successfully built and bound into JNDI [" + this.sessionFactoryName + "]"));
    }

    private void destroySessionFactory() throws Exception {
        if (this.sessionFactory != null) {
            this.unbind();
            this.sessionFactory.close();
            this.sessionFactory = null;
            this.runningSince = null;
            this.sessionFactoryProperties = null;
            if (this.hibernateStatisticsServiceName != null) {
                try {
                    this.controller.uninstall((Object)this.hibernateStatisticsServiceName);
                }
                catch (Throwable t) {
                    log.warn((Object)"unable to cleanup statistics mbean", t);
                }
            }
        }
    }

    private void handleMappings(Configuration cfg) throws IOException, URISyntaxException {
        if (this.root == null) {
            if (this.harUrl == null) {
                throw new IllegalArgumentException("Must set one of the resources, root or harUrl: " + this);
            }
            this.root = VFS.getChild((URL)this.harUrl);
        }
        log.debug((Object)("Scanning for Hibernate mappings, root: " + this.root));
        HibernateMappingVisitor visitor = new HibernateMappingVisitor();
        this.root.visit((VirtualFileVisitor)visitor);
        for (URL url : visitor.getUrls()) {
            log.debug((Object)("Passing input stream [" + url + "] to Hibernate Configration"));
            cfg.addInputStream(url.openStream());
        }
    }

    private void transferSettings(Properties settings) {
        if (this.getCacheProviderClass() == null) {
            this.setCacheProviderClass("org.hibernate.cache.HashtableCacheProvider");
        }
        if (this.getSecondLevelCacheEnabled() == null) {
            this.setSecondLevelCacheEnabled(Boolean.TRUE);
        }
        if (this.configurationElements.get("hibernate.transaction.manager_lookup_class") == null) {
            this.configurationElements.put("hibernate.transaction.manager_lookup_class", JBossTransactionManagerLookup.class.getName());
        }
        if (this.configurationElements.get("hibernate.transaction.factory_class") == null) {
            this.configurationElements.put("hibernate.transaction.factory_class", JTATransactionFactory.class.getName());
        }
        if (this.getDeployedCacheJndiName() != null && this.getCacheRegionFactoryClass() == null) {
            this.configurationElements.put("hibernate.cache.region.factory_class", JndiSharedJBossCacheRegionFactory.class.getName());
        }
        if (this.getDeployedCacheManagerJndiName() != null && this.getCacheRegionFactoryClass() == null) {
            this.configurationElements.put("hibernate.cache.region.factory_class", JndiMultiplexedJBossCacheRegionFactory.class.getName());
        }
        if (this.configurationElements.get("hibernate.transaction.flush_before_completion") == null) {
            this.configurationElements.put("hibernate.transaction.flush_before_completion", "true");
        }
        if (this.configurationElements.get("hibernate.transaction.auto_close_session") == null) {
            this.configurationElements.put("hibernate.transaction.auto_close_session", "true");
        }
        if (this.configurationElements.get("hibernate.connection.agressive_release") == null) {
            this.configurationElements.put("hibernate.connection.agressive_release", "true");
        }
        if (this.configurationElements.get("hibernate.connection.release_mode") == null) {
            this.configurationElements.put("hibernate.connection.release_mode", "after_statement");
        }
        log.debug((Object)("Using JDBC batch size : " + this.getJdbcBatchSize()));
        HashMap<String, Object> ourConfig = new HashMap<String, Object>(this.configurationElements);
        this.setUnlessNull(settings, "hibernate.connection.datasource", ourConfig.remove(DATASOURCE_NAME));
        this.setUnlessNull(settings, "hibernate.dialect", ourConfig.remove(DIALECT));
        this.setUnlessNull(settings, "hibernate.cache.provider_class", ourConfig.remove(CACHE_PROVIDER_CLASS));
        this.setUnlessNull(settings, "hibernate.cache.region.factory_class", ourConfig.remove(CACHE_REGION_FACTORY_CLASS));
        this.setUnlessNull(settings, "hibernate.cache.region_prefix", ourConfig.remove(CACHE_REGION_PREFIX));
        this.setUnlessNull(settings, "hibernate.cache.use_minimal_puts", ourConfig.remove(MINIMAL_PUTS_ENABLED));
        this.setUnlessNull(settings, "hibernate.hbm2ddl.auto", ourConfig.remove(HBM2DDL_AUTO));
        this.setUnlessNull(settings, "hibernate.default_schema", ourConfig.remove(DEFAULT_SCHEMA));
        this.setUnlessNull(settings, "hibernate.jdbc.batch_size", ourConfig.remove(JDBC_BATCH_SIZE));
        this.setUnlessNull(settings, "hibernate.use_sql_comments", ourConfig.remove(SQL_COMMENTS_ENABLED));
        this.setUnlessNull(settings, "hibernate.jdbc.fetch_size", ourConfig.remove(JDBC_FETCH_SIZE));
        this.setUnlessNull(settings, "hibernate.jdbc.use_scrollable_resultset", ourConfig.remove(JDBC_SCROLLABLE_RESULT_SET_ENABLED));
        this.setUnlessNull(settings, "hibernate.cache.use_query_cache", ourConfig.remove(QUERY_CACHE_ENABLED));
        this.setUnlessNull(settings, "hibernate.cache.use_structured_entries", ourConfig.remove(STRUCTURED_CACHE_ENTRIES_ENABLED));
        this.setUnlessNull(settings, "hibernate.query.substitutions", ourConfig.remove(QUERY_SUBSTITUTIONS));
        this.setUnlessNull(settings, "hibernate.max_fetch_depth", ourConfig.remove(MAX_FETCH_DEPTH));
        this.setUnlessNull(settings, "hibernate.show_sql", ourConfig.remove(SHOW_SQL_ENABLED));
        this.setUnlessNull(settings, "hibernate.jdbc.use_get_generated_keys", ourConfig.remove(GET_GENERATED_KEYS_ENABLED));
        this.setUnlessNull(settings, "hibernate.connection.username", ourConfig.remove(USERNAME));
        this.setUnlessNull(settings, "hibernate.connection.password", ourConfig.remove(PASSWORD));
        this.setUnlessNull(settings, "hibernate.jdbc.batch_versioned_data", ourConfig.remove(BATCH_VERSIONED_DATA_ENABLED));
        this.setUnlessNull(settings, "hibernate.jdbc.use_streams_for_binary", ourConfig.remove(STREAMS_FOR_BINARY_ENABLED));
        this.setUnlessNull(settings, "hibernate.bytecode.use_reflection_optimizer", ourConfig.remove(REFLECTION_OPTIMIZATION_ENABLED));
        this.setUnlessNull(settings, "hibernate.generate_statistics", ourConfig.remove(STAT_GENERATION_ENABLED));
        this.setUnlessNull(settings, "hibernate.default_catalog", ourConfig.remove(DEFAULT_CATALOG));
        this.setUnlessNull(settings, "hibernate.cache.use_second_level_cache", ourConfig.remove(SECOND_LEVEL_CACHE_ENABLED));
        this.setUnlessNull(settings, "hibernate.cache.region.jbc2.cachefactory", ourConfig.remove(DEPLOYED_CACHE_MANAGER_JNDI_NAME));
        this.setUnlessNull(settings, "hibernate.cache.region.jbc2.cfg.shared", ourConfig.remove(DEPLOYED_CACHE_JNDI_NAME));
        for (Map.Entry entry : ourConfig.entrySet()) {
            this.setUnlessNull(settings, (String)entry.getKey(), entry.getValue());
        }
    }

    private void setUnlessNull(Properties props, String key, Object value) {
        if (value != null) {
            props.setProperty(key, value.toString());
        }
    }

    private ListenerInjector generateListenerInjectorInstance() {
        if (this.listenerInjector == null) {
            return null;
        }
        log.info((Object)("attempting to use listener injector [" + this.listenerInjector + "]"));
        try {
            return (ListenerInjector)Thread.currentThread().getContextClassLoader().loadClass(this.listenerInjector).newInstance();
        }
        catch (Throwable t) {
            log.warn((Object)"Unable to generate specified listener injector", t);
            return null;
        }
    }

    private Interceptor generateInterceptorInstance() {
        if (this.sessionFactoryInterceptor == null) {
            return null;
        }
        log.info((Object)("Generating session factory interceptor instance [" + this.sessionFactoryInterceptor + "]"));
        try {
            return (Interceptor)Thread.currentThread().getContextClassLoader().loadClass(this.sessionFactoryInterceptor).newInstance();
        }
        catch (Throwable t) {
            log.warn((Object)"Unable to generate session factory interceptor instance", t);
            return null;
        }
    }

    private void bind() throws HibernateException {
        if (this.bindInJndi) {
            InitialContext ctx = null;
            try {
                ctx = new InitialContext();
                Util.bind((Context)ctx, (String)this.sessionFactoryName, (Object)this.sessionFactory);
            }
            catch (NamingException e) {
                throw new HibernateException("Unable to bind SessionFactory into JNDI", (Throwable)e);
            }
            finally {
                if (ctx != null) {
                    try {
                        ctx.close();
                    }
                    catch (Throwable ignore) {}
                }
            }
        }
    }

    private void unbind() throws HibernateException {
        if (this.bindInJndi) {
            InitialContext ctx = null;
            try {
                ctx = new InitialContext();
                Util.unbind((Context)ctx, (String)this.sessionFactoryName);
            }
            catch (NamingException e) {
                throw new HibernateException("Unable to unbind SessionFactory from JNDI", (Throwable)e);
            }
            finally {
                if (ctx != null) {
                    try {
                        ctx.close();
                    }
                    catch (Throwable ignore) {}
                }
            }
        }
    }

    private void forceCleanup() {
        try {
            this.sessionFactory.close();
            this.sessionFactory = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String toString() {
        return super.toString() + " [BeanName=" + this.beanName + ", JNDI=" + this.sessionFactoryName + "]";
    }

    @Override
    public void rebuildSessionFactory() throws Throwable {
        this.destroySessionFactory();
        this.buildSessionFactory();
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public boolean isSessionFactoryRunning() {
        return this.sessionFactory != null;
    }

    @Override
    public String getVersion() {
        return Version.getVersionString();
    }

    @Override
    public SessionFactory getInstance() {
        return this.sessionFactory;
    }

    @Override
    public Object getStatisticsServiceName() {
        return this.hibernateStatisticsServiceName;
    }

    @Override
    public Date getRunningSince() {
        return this.runningSince;
    }

    @Override
    public String getSessionFactoryName() {
        return this.sessionFactoryName;
    }

    @Override
    public void setSessionFactoryName(String sessionFactoryName) {
        this.sessionFactoryName = sessionFactoryName;
        this.dirty = true;
    }

    @Override
    public String getDatasourceName() {
        return this.getConfigurationElementAsString(DATASOURCE_NAME, "hibernate.connection.datasource");
    }

    @Override
    public void setDatasourceName(String datasourceName) {
        this.setConfigurationElement(datasourceName, DATASOURCE_NAME, "hibernate.connection.datasource");
    }

    @Override
    public String getUsername() {
        return this.getConfigurationElementAsString(USERNAME, "hibernate.connection.username");
    }

    @Override
    public void setUsername(String username) {
        this.setConfigurationElement(username, USERNAME, "hibernate.connection.username");
    }

    @Override
    public void setPassword(String password) {
        this.setConfigurationElement(password, PASSWORD, "hibernate.connection.password");
    }

    @Override
    public String getDefaultSchema() {
        return this.getConfigurationElementAsString(DEFAULT_SCHEMA, "hibernate.default_schema");
    }

    @Override
    public void setDefaultSchema(String defaultSchema) {
        this.setConfigurationElement(defaultSchema, DEFAULT_SCHEMA, "hibernate.default_schema");
    }

    @Override
    public String getDefaultCatalog() {
        return this.getConfigurationElementAsString(DEFAULT_CATALOG, "hibernate.default_catalog");
    }

    @Override
    public void setDefaultCatalog(String defaultCatalog) {
        this.setConfigurationElement(defaultCatalog, DEFAULT_CATALOG, "hibernate.default_catalog");
    }

    @Override
    public String getHbm2ddlAuto() {
        return this.getConfigurationElementAsString(HBM2DDL_AUTO, "hibernate.hbm2ddl.auto");
    }

    @Override
    public void setHbm2ddlAuto(String hbm2ddlAuto) {
        this.setConfigurationElement(hbm2ddlAuto, HBM2DDL_AUTO, "hibernate.hbm2ddl.auto");
    }

    @Override
    public String getDialect() {
        return this.getConfigurationElementAsString(DIALECT, "hibernate.dialect");
    }

    @Override
    public void setDialect(String dialect) {
        this.setConfigurationElement(dialect, DIALECT, "hibernate.dialect");
    }

    @Override
    public Integer getMaxFetchDepth() {
        return this.getConfigurationElementAsInteger(MAX_FETCH_DEPTH, "hibernate.max_fetch_depth");
    }

    @Override
    public void setMaxFetchDepth(Integer maxFetchDepth) {
        this.setConfigurationElement(maxFetchDepth, MAX_FETCH_DEPTH, "hibernate.max_fetch_depth");
    }

    @Override
    public Integer getJdbcBatchSize() {
        return this.getConfigurationElementAsInteger(JDBC_BATCH_SIZE, "hibernate.jdbc.batch_size");
    }

    @Override
    public void setJdbcBatchSize(Integer jdbcBatchSize) {
        this.setConfigurationElement(jdbcBatchSize, JDBC_BATCH_SIZE, "hibernate.jdbc.batch_size");
    }

    @Override
    public Integer getJdbcFetchSize() {
        return this.getConfigurationElementAsInteger(JDBC_FETCH_SIZE, "hibernate.jdbc.fetch_size");
    }

    @Override
    public void setJdbcFetchSize(Integer jdbcFetchSize) {
        this.setConfigurationElement(jdbcFetchSize, JDBC_FETCH_SIZE, "hibernate.jdbc.fetch_size");
    }

    @Override
    public Boolean getJdbcScrollableResultSetEnabled() {
        return this.getConfigurationElementAsBoolean(JDBC_SCROLLABLE_RESULT_SET_ENABLED, "hibernate.jdbc.use_scrollable_resultset");
    }

    @Override
    public void setJdbcScrollableResultSetEnabled(Boolean jdbcScrollableResultSetEnabled) {
        this.setConfigurationElement(jdbcScrollableResultSetEnabled, JDBC_SCROLLABLE_RESULT_SET_ENABLED, "hibernate.jdbc.use_scrollable_resultset");
    }

    @Override
    public Boolean getGetGeneratedKeysEnabled() {
        return this.getConfigurationElementAsBoolean(GET_GENERATED_KEYS_ENABLED, "hibernate.jdbc.use_get_generated_keys");
    }

    @Override
    public void setGetGeneratedKeysEnabled(Boolean getGeneratedKeysEnabled) {
        this.setConfigurationElement(getGeneratedKeysEnabled, GET_GENERATED_KEYS_ENABLED, "hibernate.jdbc.use_get_generated_keys");
    }

    @Override
    public String getQuerySubstitutions() {
        return this.getConfigurationElementAsString(QUERY_SUBSTITUTIONS, "hibernate.query.substitutions");
    }

    @Override
    public void setQuerySubstitutions(String querySubstitutions) {
        this.setConfigurationElement(querySubstitutions, QUERY_SUBSTITUTIONS, "hibernate.query.substitutions");
    }

    @Override
    public Boolean getSecondLevelCacheEnabled() {
        return this.getConfigurationElementAsBoolean(SECOND_LEVEL_CACHE_ENABLED, "hibernate.cache.use_second_level_cache");
    }

    @Override
    public void setSecondLevelCacheEnabled(Boolean secondLevelCacheEnabled) {
        this.setConfigurationElement(secondLevelCacheEnabled, SECOND_LEVEL_CACHE_ENABLED, "hibernate.cache.use_second_level_cache");
    }

    @Override
    public Boolean getQueryCacheEnabled() {
        return this.getConfigurationElementAsBoolean(QUERY_CACHE_ENABLED, "hibernate.cache.use_query_cache");
    }

    @Override
    public void setQueryCacheEnabled(Boolean queryCacheEnabled) {
        this.setConfigurationElement(queryCacheEnabled, QUERY_CACHE_ENABLED, "hibernate.cache.use_query_cache");
    }

    @Override
    public String getCacheProviderClass() {
        return this.getConfigurationElementAsString(CACHE_PROVIDER_CLASS, "hibernate.cache.provider_class");
    }

    @Override
    public void setCacheProviderClass(String cacheProviderClass) {
        this.setConfigurationElement(cacheProviderClass, CACHE_PROVIDER_CLASS, "hibernate.cache.provider_class");
    }

    @Override
    public String getCacheRegionFactoryClass() {
        return this.getConfigurationElementAsString(CACHE_REGION_FACTORY_CLASS, "hibernate.cache.region.factory_class");
    }

    @Override
    public void setCacheRegionFactoryClass(String regionFactoryClass) {
        this.setConfigurationElement(regionFactoryClass, CACHE_REGION_FACTORY_CLASS, "hibernate.cache.region.factory_class");
    }

    @Override
    public String getCacheRegionPrefix() {
        return this.getConfigurationElementAsString(CACHE_REGION_PREFIX, "hibernate.cache.region_prefix");
    }

    @Override
    public void setCacheRegionPrefix(String cacheRegionPrefix) {
        this.setConfigurationElement(cacheRegionPrefix, CACHE_REGION_PREFIX, "hibernate.cache.region_prefix");
    }

    @Override
    public Boolean getMinimalPutsEnabled() {
        return this.getConfigurationElementAsBoolean(MINIMAL_PUTS_ENABLED, "hibernate.cache.use_minimal_puts");
    }

    @Override
    public void setMinimalPutsEnabled(Boolean minimalPutsEnabled) {
        this.setConfigurationElement(minimalPutsEnabled, MINIMAL_PUTS_ENABLED, "hibernate.cache.use_minimal_puts");
    }

    @Override
    public Boolean getUseStructuredCacheEntriesEnabled() {
        return this.getConfigurationElementAsBoolean(STRUCTURED_CACHE_ENTRIES_ENABLED, "hibernate.cache.use_structured_entries");
    }

    @Override
    public void setUseStructuredCacheEntriesEnabled(Boolean structuredCacheEntriesEnabled) {
        this.setConfigurationElement(structuredCacheEntriesEnabled, STRUCTURED_CACHE_ENTRIES_ENABLED, "hibernate.cache.use_structured_entries");
    }

    @Override
    public Boolean getShowSqlEnabled() {
        return this.getConfigurationElementAsBoolean(SHOW_SQL_ENABLED, "hibernate.show_sql");
    }

    @Override
    public void setShowSqlEnabled(Boolean showSqlEnabled) {
        this.setConfigurationElement(showSqlEnabled, SHOW_SQL_ENABLED, "hibernate.show_sql");
    }

    @Override
    public Boolean getSqlCommentsEnabled() {
        return this.getConfigurationElementAsBoolean(SQL_COMMENTS_ENABLED, "hibernate.use_sql_comments");
    }

    @Override
    public void setSqlCommentsEnabled(Boolean commentsEnabled) {
        this.setConfigurationElement(commentsEnabled, SQL_COMMENTS_ENABLED, "hibernate.use_sql_comments");
    }

    @Override
    public String getSessionFactoryInterceptor() {
        return this.sessionFactoryInterceptor;
    }

    @Override
    public void setSessionFactoryInterceptor(String sessionFactoryInterceptor) {
        this.sessionFactoryInterceptor = sessionFactoryInterceptor;
        this.dirty = true;
    }

    @Override
    public String getListenerInjector() {
        return this.listenerInjector;
    }

    @Override
    public void setListenerInjector(String listenerInjector) {
        this.listenerInjector = listenerInjector;
    }

    @Override
    public String getDeployedCacheJndiName() {
        return this.getConfigurationElementAsString(DEPLOYED_CACHE_JNDI_NAME, "hibernate.cache.region.jbc2.cfg.shared");
    }

    @Override
    public void setDeployedCacheJndiName(String name) {
        this.setConfigurationElement(name, DEPLOYED_CACHE_JNDI_NAME, "hibernate.cache.region.jbc2.cfg.shared");
    }

    @Override
    public String getDeployedCacheManagerJndiName() {
        return this.getConfigurationElementAsString(DEPLOYED_CACHE_MANAGER_JNDI_NAME, "hibernate.cache.region.jbc2.cachefactory");
    }

    @Override
    public void setDeployedCacheManagerJndiName(String name) {
        this.setConfigurationElement(name, DEPLOYED_CACHE_MANAGER_JNDI_NAME, "hibernate.cache.region.jbc2.cachefactory");
    }

    @Override
    public Boolean getBatchVersionedDataEnabled() {
        return this.getConfigurationElementAsBoolean(BATCH_VERSIONED_DATA_ENABLED, "hibernate.jdbc.batch_versioned_data");
    }

    @Override
    public void setBatchVersionedDataEnabled(Boolean batchVersionedDataEnabled) {
        this.setConfigurationElement(batchVersionedDataEnabled, BATCH_VERSIONED_DATA_ENABLED, "hibernate.jdbc.batch_versioned_data");
    }

    @Override
    public Boolean getStreamsForBinaryEnabled() {
        return this.getConfigurationElementAsBoolean(STREAMS_FOR_BINARY_ENABLED, "hibernate.jdbc.use_streams_for_binary");
    }

    @Override
    public void setStreamsForBinaryEnabled(Boolean streamsForBinaryEnabled) {
        this.setConfigurationElement(streamsForBinaryEnabled, STREAMS_FOR_BINARY_ENABLED, "hibernate.jdbc.use_streams_for_binary");
    }

    @Override
    public Boolean getReflectionOptimizationEnabled() {
        return this.getConfigurationElementAsBoolean(REFLECTION_OPTIMIZATION_ENABLED, "hibernate.bytecode.use_reflection_optimizer");
    }

    @Override
    public void setReflectionOptimizationEnabled(Boolean reflectionOptimizationEnabled) {
        this.setConfigurationElement(reflectionOptimizationEnabled, REFLECTION_OPTIMIZATION_ENABLED, "hibernate.bytecode.use_reflection_optimizer");
    }

    @Override
    public Boolean getStatGenerationEnabled() {
        return this.getConfigurationElementAsBoolean(STAT_GENERATION_ENABLED, "hibernate.generate_statistics");
    }

    @Override
    public void setStatGenerationEnabled(Boolean statGenerationEnabled) {
        this.setConfigurationElement(statGenerationEnabled, STAT_GENERATION_ENABLED, "hibernate.generate_statistics");
    }

    @Override
    public URL getHarUrl() {
        return this.harUrl;
    }

    public void setHarUrl(URL harUrl) {
        this.harUrl = harUrl;
        this.dirty = true;
    }

    @Override
    public boolean isScanForMappingsEnabled() {
        return this.scanForMappingsEnabled;
    }

    @Override
    public void setScanForMappingsEnabled(boolean scanForMappingsEnabled) {
        this.scanForMappingsEnabled = scanForMappingsEnabled;
    }

    private String getConfigurationElementAsString(String beanPropertyName, String hibernateName) {
        Object element = this.getConfigurationElement(beanPropertyName, hibernateName);
        return element == null ? null : element.toString();
    }

    private Boolean getConfigurationElementAsBoolean(String beanPropertyName, String hibernateName) {
        Object element = this.getConfigurationElement(beanPropertyName, hibernateName);
        if (element instanceof String) {
            return Boolean.valueOf((String)element);
        }
        return (Boolean)element;
    }

    private Integer getConfigurationElementAsInteger(String beanPropertyName, String hibernateName) {
        Object element = this.getConfigurationElement(beanPropertyName, hibernateName);
        if (element instanceof String) {
            return Integer.valueOf((String)element);
        }
        return (Integer)element;
    }

    private Object getConfigurationElement(String beanPropertyName, String hibernateName) {
        Object name = this.configurationElements.get(beanPropertyName);
        if (name == null) {
            name = this.configurationElements.get(hibernateName);
        }
        return name;
    }

    private void setConfigurationElement(Object value, String beanPropertyName, String hibernateName) {
        this.configurationElements.remove(beanPropertyName);
        if (value == null) {
            this.configurationElements.remove(hibernateName);
        } else {
            this.configurationElements.put(hibernateName, value);
        }
        this.dirty = true;
    }
}

