/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.integration.hornetq.management.jms;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.hornetq.api.core.Pair;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.jms.management.ConnectionFactoryControl;
import org.jboss.metatype.api.types.CompositeMetaType;
import org.jboss.metatype.api.types.ImmutableCompositeMetaType;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.values.CompositeValueSupport;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.SimpleValueSupport;
import org.jboss.metatype.spi.values.MetaMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionFactoryMapper
extends MetaMapper<ConnectionFactoryControl> {
    public static final CompositeMetaType TYPE;

    public MetaValue createMetaValue(MetaType metaType, ConnectionFactoryControl control) {
        CompositeValueSupport cvs = new CompositeValueSupport(TYPE);
        cvs.set("name", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)control.getName())));
        List pairs = control.getStaticConnectors();
        StringBuffer liveTransportClassNames = new StringBuffer();
        StringBuffer liveTransportParams = new StringBuffer();
        StringBuffer backupTransportClassNames = new StringBuffer();
        StringBuffer backupTransportParams = new StringBuffer();
        for (Pair pair : pairs) {
            Map params;
            if (pair.a != null) {
                TransportConfiguration live = (TransportConfiguration)pair.a;
                if (liveTransportClassNames.length() > 0) {
                    liveTransportClassNames.append(",");
                }
                liveTransportClassNames.append(live.getFactoryClassName());
                params = live.getParams();
                liveTransportParams.append("{");
                for (Map.Entry stringObjectEntry : params.entrySet()) {
                    if (liveTransportParams.length() > 1) {
                        liveTransportParams.append(",");
                    }
                    liveTransportParams.append((String)stringObjectEntry.getKey()).append("=").append(stringObjectEntry.getValue());
                }
                liveTransportParams.append("}");
            }
            if (pair.b == null) continue;
            TransportConfiguration backUp = (TransportConfiguration)pair.b;
            if (backupTransportClassNames.length() > 0) {
                backupTransportClassNames.append(",");
            }
            backupTransportClassNames.append(backUp.getFactoryClassName());
            params = backUp.getParams();
            backupTransportParams.append("{");
            for (Map.Entry stringObjectEntry : params.entrySet()) {
                if (backupTransportParams.length() > 1) {
                    backupTransportParams.append(",");
                }
                backupTransportParams.append((String)stringObjectEntry.getKey()).append("=").append(stringObjectEntry.getValue());
            }
            backupTransportParams.append("}");
        }
        cvs.set("liveTransportClassNames", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)liveTransportClassNames));
        cvs.set("liveTransportParams", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)liveTransportParams));
        cvs.set("backupTransportClassNames", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)backupTransportClassNames));
        cvs.set("backupTransportParams", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)backupTransportParams));
        cvs.set("Bindings", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)this.getJndiString(control.getJNDIBindings()))));
        cvs.set("DiscoveryAddress", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)control.getDiscoveryAddress())));
        cvs.set("DiscoveryPort", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)Integer.valueOf(control.getDiscoveryPort())));
        cvs.set("DiscoveryRefreshTimeout", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)Long.valueOf(control.getDiscoveryRefreshTimeout())));
        cvs.set("DiscoveryInitialWaitTimeout", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)Long.valueOf(control.getDiscoveryInitialWaitTimeout())));
        cvs.set("ClientID", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)control.getClientID())));
        cvs.set("DupsOKBatchSize", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)Integer.valueOf(control.getDupsOKBatchSize())));
        cvs.set("TransactionBatchSize", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)Integer.valueOf(control.getTransactionBatchSize())));
        cvs.set("ClientFailureCheckPeriod", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)Long.valueOf(control.getClientFailureCheckPeriod())));
        cvs.set("ConnectionTTL", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)Long.valueOf(control.getConnectionTTL())));
        cvs.set("CallTimeout", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)Long.valueOf(control.getCallTimeout())));
        cvs.set("ConsumerWindowSize", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)Integer.valueOf(control.getConfirmationWindowSize())));
        cvs.set("ConsumerMaxRate", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)Integer.valueOf(control.getConsumerMaxRate())));
        cvs.set("ConfirmationWindowSize", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)Integer.valueOf(control.getConfirmationWindowSize())));
        cvs.set("ProducerMaxRate", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)Integer.valueOf(control.getProducerMaxRate())));
        cvs.set("ProducerWindowSize", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)Integer.valueOf(control.getProducerWindowSize())));
        cvs.set("CacheLargeMessagesClient", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)Boolean.valueOf(control.isCacheLargeMessagesClient())));
        cvs.set("MinLargeMessageSize", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)Integer.valueOf(control.getMinLargeMessageSize())));
        cvs.set("BlockOnNonDurableSend", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)Boolean.valueOf(control.isBlockOnNonDurableSend())));
        cvs.set("BlockOnAcknowledge", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)Boolean.valueOf(control.isBlockOnAcknowledge())));
        cvs.set("BlockOnDurableSend", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)Boolean.valueOf(control.isBlockOnDurableSend())));
        cvs.set("AutoGroup", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)Boolean.valueOf(control.isAutoGroup())));
        cvs.set("PreAcknowledge", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)Boolean.valueOf(control.isPreAcknowledge())));
        cvs.set("MaxRetryInterval", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)Long.valueOf(control.getMaxRetryInterval())));
        cvs.set("RetryIntervalMultiplier", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)Double.valueOf(control.getRetryIntervalMultiplier())));
        cvs.set("ReconnectAttempts", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)Integer.valueOf(control.getReconnectAttempts())));
        cvs.set("FailoverOnServerShutdown", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)Boolean.valueOf(control.isFailoverOnServerShutdown())));
        cvs.set("ScheduledThreadPoolMaxSize", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)Integer.valueOf(control.getScheduledThreadPoolMaxSize())));
        cvs.set("ThreadPoolMaxSize", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)Integer.valueOf(control.getThreadPoolMaxSize())));
        cvs.set("GroupID", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)control.getGroupID())));
        cvs.set("InitialMessagePacketSize", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)Integer.valueOf(control.getInitialMessagePacketSize())));
        cvs.set("UseGlobalPools", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)Boolean.valueOf(control.isUseGlobalPools())));
        cvs.set("RetryInterval", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)Long.valueOf(control.getRetryInterval())));
        cvs.set("ConnectionLoadBalancingPolicyClassName", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)control.getConnectionLoadBalancingPolicyClassName())));
        return cvs;
    }

    public ConnectionFactoryControl unwrapMetaValue(MetaValue metaValue) {
        return null;
    }

    public Type mapToType() {
        return ConnectionFactoryControl.class;
    }

    public MetaType getMetaType() {
        return TYPE;
    }

    private String getJndiString(String[] array) {
        StringBuffer sb = new StringBuffer();
        for (String o : array) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(o);
        }
        return sb.toString();
    }

    static {
        String[] itemNames = new String[]{"name", "liveTransportClassNames", "liveTransportParams", "backupTransportClassNames", "backupTransportParams", "Bindings", "DiscoveryAddress", "DiscoveryPort", "DiscoveryRefreshTimeout", "DiscoveryInitialWaitTimeout", "ClientID", "DupsOKBatchSize", "TransactionBatchSize", "ClientFailureCheckPeriod", "ConnectionTTL", "CallTimeout", "ConsumerWindowSize", "ConsumerMaxRate", "ConfirmationWindowSize", "ProducerMaxRate", "ProducerWindowSize", "CacheLargeMessagesClient", "MinLargeMessageSize", "BlockOnNonDurableSend", "BlockOnAcknowledge", "BlockOnDurableSend", "AutoGroup", "PreAcknowledge", "MaxRetryInterval", "RetryIntervalMultiplier", "ReconnectAttempts", "FailoverOnServerShutdown", "ScheduledThreadPoolMaxSize", "ThreadPoolMaxSize", "GroupID", "InitialMessagePacketSize", "UseGlobalPools", "RetryInterval", "ConnectionLoadBalancingPolicyClassName"};
        String[] itemDescriptions = new String[]{"name", "liveTransportClassNames", "liveTransportParams", "backupTransportClassNames", "backupTransportParams", "Bindings", "DiscoveryAddress", "DiscoveryPort", "DiscoveryRefreshTimeout", "DiscoveryInitialWaitTimeout", "ClientID", "DupsOKBatchSize", "TransactionBatchSize", "ClientFailureCheckPeriod", "ConnectionTTL", "CallTimeout", "ConsumerWindowSize", "ConsumerMaxRate", "ConfirmationWindowSize", "ProducerMaxRate", "ProducerWindowSize", "CacheLargeMessagesClient", "MinLargeMessageSize", "BlockOnNonDurableSend", "BlockOnAcknowledge", "BlockOnDurableSend", "AutoGroup", "PreAcknowledge", "MaxRetryInterval", "RetryIntervalMultiplier", "ReconnectAttempts", "FailoverOnServerShutdown", "ScheduledThreadPoolMaxSize", "ThreadPoolMaxSize", "GroupID", "InitialMessagePacketSize", "UseGlobalPools", "RetryInterval", "ConnectionLoadBalancingPolicyClassName"};
        MetaType[] itemTypes = new MetaType[]{SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING};
        TYPE = new ImmutableCompositeMetaType("javax.jms.ConnectionFactory", "Connection Factory Settings", itemNames, itemDescriptions, itemTypes);
    }
}

