/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.jmx.compliance.relation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.management.NotCompliantMBeanException;
import javax.management.relation.InvalidRoleInfoException;
import javax.management.relation.RelationSupport;
import javax.management.relation.RoleInfo;
import junit.framework.TestCase;

public class RoleInfoTestCase
extends TestCase {
    public RoleInfoTestCase(String s) {
        super(s);
    }

    public void testBasic() {
        RoleInfo roleInfo = null;
        try {
            roleInfo = new RoleInfo("RoleName", RelationSupport.class.getName());
        }
        catch (Exception e) {
            RoleInfoTestCase.fail((String)e.toString());
        }
        RoleInfoTestCase.assertEquals((String)roleInfo.getName(), (String)"RoleName");
        RoleInfoTestCase.assertEquals((String)roleInfo.getRefMBeanClassName(), (String)RelationSupport.class.getName());
        RoleInfoTestCase.assertEquals((boolean)roleInfo.isReadable(), (boolean)true);
        RoleInfoTestCase.assertEquals((boolean)roleInfo.isWritable(), (boolean)true);
        RoleInfoTestCase.assertEquals((int)roleInfo.getMinDegree(), (int)1);
        RoleInfoTestCase.assertEquals((int)roleInfo.getMaxDegree(), (int)1);
        RoleInfoTestCase.assertEquals((String)roleInfo.getDescription(), null);
        try {
            roleInfo = new RoleInfo("RoleName", RelationSupport.class.getName(), false, false);
        }
        catch (Exception e) {
            RoleInfoTestCase.fail((String)e.toString());
        }
        RoleInfoTestCase.assertEquals((String)roleInfo.getName(), (String)"RoleName");
        RoleInfoTestCase.assertEquals((String)roleInfo.getRefMBeanClassName(), (String)RelationSupport.class.getName());
        RoleInfoTestCase.assertEquals((boolean)roleInfo.isReadable(), (boolean)false);
        RoleInfoTestCase.assertEquals((boolean)roleInfo.isWritable(), (boolean)false);
        RoleInfoTestCase.assertEquals((int)roleInfo.getMinDegree(), (int)1);
        RoleInfoTestCase.assertEquals((int)roleInfo.getMaxDegree(), (int)1);
        RoleInfoTestCase.assertEquals((String)roleInfo.getDescription(), null);
        try {
            roleInfo = new RoleInfo("RoleName", RelationSupport.class.getName(), false, false, 23, 25, "Description");
        }
        catch (Exception e) {
            RoleInfoTestCase.fail((String)e.toString());
        }
        RoleInfoTestCase.assertEquals((String)roleInfo.getName(), (String)"RoleName");
        RoleInfoTestCase.assertEquals((String)roleInfo.getRefMBeanClassName(), (String)RelationSupport.class.getName());
        RoleInfoTestCase.assertEquals((boolean)roleInfo.isReadable(), (boolean)false);
        RoleInfoTestCase.assertEquals((boolean)roleInfo.isWritable(), (boolean)false);
        RoleInfoTestCase.assertEquals((int)roleInfo.getMinDegree(), (int)23);
        RoleInfoTestCase.assertEquals((int)roleInfo.getMaxDegree(), (int)25);
        RoleInfoTestCase.assertEquals((String)roleInfo.getDescription(), (String)"Description");
    }

    public void testErrorHandling() {
        boolean caught = false;
        try {
            new RoleInfo(null);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        catch (Exception e) {
            RoleInfoTestCase.fail((String)e.toString());
        }
        if (!caught) {
            RoleInfoTestCase.fail((String)"Copy Constructor accepts null role info");
        }
        caught = false;
        try {
            new RoleInfo(null, RelationSupport.class.getName());
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        catch (Exception e) {
            RoleInfoTestCase.fail((String)e.toString());
        }
        if (!caught) {
            RoleInfoTestCase.fail((String)"Constructor accepts null role name (1)");
        }
        caught = false;
        try {
            new RoleInfo(null, RelationSupport.class.getName(), true, true);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        catch (Exception e) {
            RoleInfoTestCase.fail((String)e.toString());
        }
        if (!caught) {
            RoleInfoTestCase.fail((String)"Constructor accepts null role name (2)");
        }
        caught = false;
        try {
            new RoleInfo(null, RelationSupport.class.getName(), true, true, 1, 1, "blah");
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        catch (Exception e) {
            RoleInfoTestCase.fail((String)e.toString());
        }
        if (!caught) {
            RoleInfoTestCase.fail((String)"Constructor accepts null role name (3)");
        }
        caught = false;
        try {
            new RoleInfo("RoleName", null);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        catch (Exception e) {
            RoleInfoTestCase.fail((String)e.toString());
        }
        if (!caught) {
            RoleInfoTestCase.fail((String)"Constructor accepts null class name (1)");
        }
        caught = false;
        try {
            new RoleInfo("RoleName", null, true, true);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        catch (Exception e) {
            RoleInfoTestCase.fail((String)e.toString());
        }
        if (!caught) {
            RoleInfoTestCase.fail((String)"Constructor accepts null class name (2)");
        }
        caught = false;
        try {
            new RoleInfo("RoleName", null, true, true, 1, 1, "blah");
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        catch (Exception e) {
            RoleInfoTestCase.fail((String)e.toString());
        }
        if (!caught) {
            RoleInfoTestCase.fail((String)"Constructor accepts null class name (3)");
        }
        caught = false;
        try {
            new RoleInfo("RoleName", "Inv alid");
        }
        catch (ClassNotFoundException e) {
            caught = true;
        }
        catch (Exception e) {
            RoleInfoTestCase.fail((String)e.toString());
        }
        if (caught) {
            RoleInfoTestCase.fail((String)"Constructor accepts invalid class name (1) - disabled JMX1.2");
        }
        caught = false;
        try {
            new RoleInfo("RoleName", "Inv alid", true, true);
        }
        catch (ClassNotFoundException e) {
            caught = true;
        }
        catch (Exception e) {
            RoleInfoTestCase.fail((String)e.toString());
        }
        if (caught) {
            RoleInfoTestCase.fail((String)"Constructor accepts invalid class name (2) - disabled JMX1.2");
        }
        caught = false;
        try {
            new RoleInfo("RoleName", "Inv alid", true, true, 1, 1, "blah");
        }
        catch (ClassNotFoundException e) {
            caught = true;
        }
        catch (Exception e) {
            RoleInfoTestCase.fail((String)e.toString());
        }
        if (caught) {
            RoleInfoTestCase.fail((String)"Constructor accepts invalid class name (3) - disabled JMX1.2");
        }
        caught = false;
        try {
            new RoleInfo("RoleName", RoleInfo.class.getName());
        }
        catch (NotCompliantMBeanException e) {
            caught = true;
        }
        catch (Exception e) {
            RoleInfoTestCase.fail((String)e.toString());
        }
        if (caught) {
            RoleInfoTestCase.fail((String)"Constructor accepts not compliant mbean (1) - disabled JMX1.2");
        }
        caught = false;
        try {
            new RoleInfo("RoleName", RoleInfo.class.getName(), true, true);
        }
        catch (NotCompliantMBeanException e) {
            caught = true;
        }
        catch (Exception e) {
            RoleInfoTestCase.fail((String)e.toString());
        }
        if (caught) {
            RoleInfoTestCase.fail((String)"Constructor accepts not compliant mbean (2) - disabled JMX1.2");
        }
        caught = false;
        try {
            new RoleInfo("RoleName", RoleInfo.class.getName(), true, true, 1, 1, "blah");
        }
        catch (NotCompliantMBeanException e) {
            caught = true;
        }
        catch (Exception e) {
            RoleInfoTestCase.fail((String)e.toString());
        }
        if (caught) {
            RoleInfoTestCase.fail((String)"Constructor accepts not compliant mbean (3) - disabled JMX1.2");
        }
    }

    public void testConstructorCardinality() {
        try {
            new RoleInfo("RoleName", RelationSupport.class.getName(), false, false, 0, 0, "Description");
        }
        catch (Exception e) {
            RoleInfoTestCase.fail((String)e.toString());
        }
        boolean caught = false;
        try {
            new RoleInfo("RoleName", RelationSupport.class.getName(), false, false, 1, 0, "Description");
        }
        catch (InvalidRoleInfoException e) {
            caught = true;
        }
        catch (Exception e) {
            RoleInfoTestCase.fail((String)e.toString());
        }
        if (!caught) {
            RoleInfoTestCase.fail((String)"Shouldn't allow minimum of 1 and maximum of 0");
        }
        caught = false;
        try {
            new RoleInfo("RoleName", RelationSupport.class.getName(), false, false, RoleInfo.ROLE_CARDINALITY_INFINITY, 0, "Description");
        }
        catch (InvalidRoleInfoException e) {
            caught = true;
        }
        catch (Exception e) {
            RoleInfoTestCase.fail((String)e.toString());
        }
        if (!caught) {
            RoleInfoTestCase.fail((String)"Shouldn't allow infinite minimum without infinite maximum");
        }
    }

    public void testCheckDegrees() {
        RoleInfo roleInfo = null;
        try {
            roleInfo = new RoleInfo("RoleName", RelationSupport.class.getName(), false, false, 23, 25, "Description");
        }
        catch (Exception e) {
            RoleInfoTestCase.fail((String)e.toString());
        }
        RoleInfoTestCase.assertEquals((boolean)true, (boolean)roleInfo.checkMaxDegree(0));
        RoleInfoTestCase.assertEquals((boolean)true, (boolean)roleInfo.checkMaxDegree(22));
        RoleInfoTestCase.assertEquals((boolean)true, (boolean)roleInfo.checkMaxDegree(23));
        RoleInfoTestCase.assertEquals((boolean)true, (boolean)roleInfo.checkMaxDegree(24));
        RoleInfoTestCase.assertEquals((boolean)true, (boolean)roleInfo.checkMaxDegree(25));
        RoleInfoTestCase.assertEquals((boolean)false, (boolean)roleInfo.checkMaxDegree(26));
        RoleInfoTestCase.assertEquals((boolean)false, (boolean)roleInfo.checkMaxDegree(Integer.MAX_VALUE));
        RoleInfoTestCase.assertEquals((boolean)false, (boolean)roleInfo.checkMinDegree(0));
        RoleInfoTestCase.assertEquals((boolean)false, (boolean)roleInfo.checkMinDegree(22));
        RoleInfoTestCase.assertEquals((boolean)true, (boolean)roleInfo.checkMinDegree(23));
        RoleInfoTestCase.assertEquals((boolean)true, (boolean)roleInfo.checkMinDegree(24));
        RoleInfoTestCase.assertEquals((boolean)true, (boolean)roleInfo.checkMinDegree(25));
        RoleInfoTestCase.assertEquals((boolean)true, (boolean)roleInfo.checkMinDegree(26));
        RoleInfoTestCase.assertEquals((boolean)true, (boolean)roleInfo.checkMinDegree(Integer.MAX_VALUE));
        try {
            roleInfo = new RoleInfo("RoleName", RelationSupport.class.getName(), false, false, 25, RoleInfo.ROLE_CARDINALITY_INFINITY, "Description");
        }
        catch (Exception e) {
            RoleInfoTestCase.fail((String)e.toString());
        }
        RoleInfoTestCase.assertEquals((boolean)true, (boolean)roleInfo.checkMaxDegree(0));
        RoleInfoTestCase.assertEquals((boolean)true, (boolean)roleInfo.checkMaxDegree(24));
        RoleInfoTestCase.assertEquals((boolean)true, (boolean)roleInfo.checkMaxDegree(25));
        RoleInfoTestCase.assertEquals((boolean)true, (boolean)roleInfo.checkMaxDegree(26));
        RoleInfoTestCase.assertEquals((boolean)true, (boolean)roleInfo.checkMaxDegree(Integer.MAX_VALUE));
        RoleInfoTestCase.assertEquals((boolean)false, (boolean)roleInfo.checkMinDegree(0));
        RoleInfoTestCase.assertEquals((boolean)false, (boolean)roleInfo.checkMinDegree(24));
        RoleInfoTestCase.assertEquals((boolean)true, (boolean)roleInfo.checkMinDegree(25));
        RoleInfoTestCase.assertEquals((boolean)true, (boolean)roleInfo.checkMinDegree(26));
        RoleInfoTestCase.assertEquals((boolean)true, (boolean)roleInfo.checkMinDegree(Integer.MAX_VALUE));
        try {
            roleInfo = new RoleInfo("RoleName", RelationSupport.class.getName(), false, false, RoleInfo.ROLE_CARDINALITY_INFINITY, RoleInfo.ROLE_CARDINALITY_INFINITY, "Description");
        }
        catch (Exception e) {
            RoleInfoTestCase.fail((String)e.toString());
        }
        RoleInfoTestCase.assertEquals((boolean)true, (boolean)roleInfo.checkMaxDegree(0));
        RoleInfoTestCase.assertEquals((boolean)true, (boolean)roleInfo.checkMaxDegree(26));
        RoleInfoTestCase.assertEquals((boolean)true, (boolean)roleInfo.checkMaxDegree(Integer.MAX_VALUE));
        RoleInfoTestCase.assertEquals((boolean)true, (boolean)roleInfo.checkMinDegree(0));
        RoleInfoTestCase.assertEquals((boolean)true, (boolean)roleInfo.checkMinDegree(24));
        RoleInfoTestCase.assertEquals((boolean)true, (boolean)roleInfo.checkMinDegree(Integer.MAX_VALUE));
    }

    public void testCopy() {
        RoleInfo roleInfo = null;
        RoleInfo roleInfo2 = null;
        try {
            roleInfo = new RoleInfo("RoleName", RelationSupport.class.getName(), false, false, 23, 25, "Description");
            roleInfo2 = new RoleInfo(roleInfo);
        }
        catch (Exception e) {
            RoleInfoTestCase.fail((String)e.toString());
        }
        RoleInfoTestCase.assertEquals((String)roleInfo.getName(), (String)roleInfo2.getName());
        RoleInfoTestCase.assertEquals((String)roleInfo.getRefMBeanClassName(), (String)roleInfo2.getRefMBeanClassName());
        RoleInfoTestCase.assertEquals((boolean)roleInfo.isReadable(), (boolean)roleInfo2.isReadable());
        RoleInfoTestCase.assertEquals((boolean)roleInfo.isWritable(), (boolean)roleInfo2.isWritable());
        RoleInfoTestCase.assertEquals((int)roleInfo.getMinDegree(), (int)roleInfo2.getMinDegree());
        RoleInfoTestCase.assertEquals((int)roleInfo.getMaxDegree(), (int)roleInfo2.getMaxDegree());
        RoleInfoTestCase.assertEquals((String)roleInfo.getDescription(), (String)roleInfo2.getDescription());
    }

    public void testSerialization() {
        RoleInfo roleInfo = null;
        RoleInfo roleInfo2 = null;
        try {
            roleInfo = new RoleInfo("RoleName", RelationSupport.class.getName(), false, false, 23, 25, "Description");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(roleInfo);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bais);
            roleInfo2 = (RoleInfo)ois.readObject();
        }
        catch (Exception e) {
            RoleInfoTestCase.fail((String)e.toString());
        }
        RoleInfoTestCase.assertEquals((String)roleInfo.getName(), (String)roleInfo2.getName());
        RoleInfoTestCase.assertEquals((String)roleInfo.getRefMBeanClassName(), (String)roleInfo2.getRefMBeanClassName());
        RoleInfoTestCase.assertEquals((boolean)roleInfo.isReadable(), (boolean)roleInfo2.isReadable());
        RoleInfoTestCase.assertEquals((boolean)roleInfo.isWritable(), (boolean)roleInfo2.isWritable());
        RoleInfoTestCase.assertEquals((int)roleInfo.getMinDegree(), (int)roleInfo2.getMinDegree());
        RoleInfoTestCase.assertEquals((int)roleInfo.getMaxDegree(), (int)roleInfo2.getMaxDegree());
        RoleInfoTestCase.assertEquals((String)roleInfo.getDescription(), (String)roleInfo2.getDescription());
    }
}

