/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.jmx.compliance.server;

import java.util.ArrayList;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MBeanServerInvocationHandler;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import junit.framework.TestCase;
import org.jboss.test.jmx.compliance.server.support.BroadcasterInvocationHandlerTest;
import org.jboss.test.jmx.compliance.server.support.EmitterInvocationHandlerTest;
import org.jboss.test.jmx.compliance.server.support.InvocationHandlerTest;
import org.jboss.test.jmx.compliance.server.support.InvocationHandlerTestMBean;
import org.jboss.test.jmx.compliance.server.support.ObjectInvocationHandlerTest;

public class MBeanServerInvocationHandlerTestCase
extends TestCase
implements NotificationListener {
    private ObjectName invocationHandlerTestName;
    private ArrayList messages = new ArrayList();

    public MBeanServerInvocationHandlerTestCase(String s) {
        super(s);
        try {
            this.invocationHandlerTestName = new ObjectName("MBeanServerInvocationHandlerTestCase:type=InvocationHandlerTest");
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    public void testConstructor() throws Exception {
        MBeanServerFactory.newMBeanServer();
    }

    public void testGetter() throws Exception {
        MBeanServer server = MBeanServerFactory.newMBeanServer();
        InvocationHandlerTest test = new InvocationHandlerTest();
        server.registerMBean(test, this.invocationHandlerTestName);
        InvocationHandlerTestMBean proxy = MBeanServerInvocationHandler.newProxyInstance(server, this.invocationHandlerTestName, InvocationHandlerTestMBean.class, false);
        MBeanServerInvocationHandlerTestCase.assertEquals((String)"Attribute", (String)proxy.getAttribute());
    }

    public void testSetter() throws Exception {
        MBeanServer server = MBeanServerFactory.newMBeanServer();
        InvocationHandlerTest test = new InvocationHandlerTest();
        server.registerMBean(test, this.invocationHandlerTestName);
        InvocationHandlerTestMBean proxy = MBeanServerInvocationHandler.newProxyInstance(server, this.invocationHandlerTestName, InvocationHandlerTestMBean.class, false);
        proxy.setAttribute("Changed");
        MBeanServerInvocationHandlerTestCase.assertEquals((String)"Changed", (String)test.getAttribute());
    }

    public void testGetterPrimitiveBoolean() throws Exception {
        MBeanServer server = MBeanServerFactory.newMBeanServer();
        InvocationHandlerTest test = new InvocationHandlerTest();
        server.registerMBean(test, this.invocationHandlerTestName);
        InvocationHandlerTestMBean proxy = MBeanServerInvocationHandler.newProxyInstance(server, this.invocationHandlerTestName, InvocationHandlerTestMBean.class, false);
        MBeanServerInvocationHandlerTestCase.assertEquals((boolean)false, (boolean)test.isIsPrimitive());
        test.setIsPrimitive(true);
        MBeanServerInvocationHandlerTestCase.assertEquals((boolean)true, (boolean)proxy.isIsPrimitive());
    }

    public void testSetterPrimitiveBoolean() throws Exception {
        MBeanServer server = MBeanServerFactory.newMBeanServer();
        InvocationHandlerTest test = new InvocationHandlerTest();
        server.registerMBean(test, this.invocationHandlerTestName);
        InvocationHandlerTestMBean proxy = MBeanServerInvocationHandler.newProxyInstance(server, this.invocationHandlerTestName, InvocationHandlerTestMBean.class, false);
        MBeanServerInvocationHandlerTestCase.assertEquals((boolean)false, (boolean)test.isIsPrimitive());
        proxy.setIsPrimitive(true);
        MBeanServerInvocationHandlerTestCase.assertEquals((boolean)true, (boolean)test.isIsPrimitive());
    }

    public void testGetterTypeBoolean() throws Exception {
        MBeanServer server = MBeanServerFactory.newMBeanServer();
        InvocationHandlerTest test = new InvocationHandlerTest();
        server.registerMBean(test, this.invocationHandlerTestName);
        InvocationHandlerTestMBean proxy = MBeanServerInvocationHandler.newProxyInstance(server, this.invocationHandlerTestName, InvocationHandlerTestMBean.class, false);
        MBeanServerInvocationHandlerTestCase.assertEquals(null, (Object)test.getType());
        test.setType(new Boolean(true));
        MBeanServerInvocationHandlerTestCase.assertEquals((boolean)true, (boolean)proxy.getType());
    }

    public void testSetterTypeBoolean() throws Exception {
        MBeanServer server = MBeanServerFactory.newMBeanServer();
        InvocationHandlerTest test = new InvocationHandlerTest();
        server.registerMBean(test, this.invocationHandlerTestName);
        InvocationHandlerTestMBean proxy = MBeanServerInvocationHandler.newProxyInstance(server, this.invocationHandlerTestName, InvocationHandlerTestMBean.class, false);
        MBeanServerInvocationHandlerTestCase.assertEquals(null, (Object)test.getType());
        proxy.setType(new Boolean(true));
        MBeanServerInvocationHandlerTestCase.assertEquals((boolean)true, (boolean)test.getType());
    }

    public void testInvokeNoArgsNoReturn() throws Exception {
        MBeanServer server = MBeanServerFactory.newMBeanServer();
        InvocationHandlerTest test = new InvocationHandlerTest();
        server.registerMBean(test, this.invocationHandlerTestName);
        InvocationHandlerTestMBean proxy = MBeanServerInvocationHandler.newProxyInstance(server, this.invocationHandlerTestName, InvocationHandlerTestMBean.class, false);
        proxy.invokeNoArgsNoReturn();
        MBeanServerInvocationHandlerTestCase.assertTrue((boolean)test.invokeNoArgsNoReturnInvoked);
    }

    public void testInvokeNoArgs() throws Exception {
        MBeanServer server = MBeanServerFactory.newMBeanServer();
        InvocationHandlerTest test = new InvocationHandlerTest();
        server.registerMBean(test, this.invocationHandlerTestName);
        InvocationHandlerTestMBean proxy = MBeanServerInvocationHandler.newProxyInstance(server, this.invocationHandlerTestName, InvocationHandlerTestMBean.class, false);
        MBeanServerInvocationHandlerTestCase.assertEquals((String)"invokeNoArgs", (String)proxy.invokeNoArgs());
    }

    public void testInvoke() throws Exception {
        MBeanServer server = MBeanServerFactory.newMBeanServer();
        InvocationHandlerTest test = new InvocationHandlerTest();
        server.registerMBean(test, this.invocationHandlerTestName);
        InvocationHandlerTestMBean proxy = MBeanServerInvocationHandler.newProxyInstance(server, this.invocationHandlerTestName, InvocationHandlerTestMBean.class, false);
        MBeanServerInvocationHandlerTestCase.assertEquals((String)"parameter", (String)proxy.invoke("parameter"));
    }

    public void testInvokeMixedParameters() throws Exception {
        MBeanServer server = MBeanServerFactory.newMBeanServer();
        InvocationHandlerTest test = new InvocationHandlerTest();
        server.registerMBean(test, this.invocationHandlerTestName);
        InvocationHandlerTestMBean proxy = MBeanServerInvocationHandler.newProxyInstance(server, this.invocationHandlerTestName, InvocationHandlerTestMBean.class, false);
        Integer parameter = new Integer(20);
        MBeanServerInvocationHandlerTestCase.assertEquals((Object)parameter, (Object)proxy.invokeMixedParameters("parameter", 10, parameter));
    }

    public void testNotificationEmitterAdd() throws Exception {
        MBeanServer server = MBeanServerFactory.newMBeanServer();
        EmitterInvocationHandlerTest test = new EmitterInvocationHandlerTest();
        server.registerMBean(test, this.invocationHandlerTestName);
        NotificationEmitter proxy = (NotificationEmitter)((Object)MBeanServerInvocationHandler.newProxyInstance(server, this.invocationHandlerTestName, InvocationHandlerTestMBean.class, true));
        proxy.addNotificationListener(this, null, null);
        this.messages.clear();
        test.sendNotification();
        MBeanServerInvocationHandlerTestCase.assertTrue((this.messages.size() == 1 ? 1 : 0) != 0);
    }

    public void testNotificationEmitterRemove() throws Exception {
        MBeanServer server = MBeanServerFactory.newMBeanServer();
        EmitterInvocationHandlerTest test = new EmitterInvocationHandlerTest();
        server.registerMBean(test, this.invocationHandlerTestName);
        NotificationEmitter proxy = (NotificationEmitter)((Object)MBeanServerInvocationHandler.newProxyInstance(server, this.invocationHandlerTestName, InvocationHandlerTestMBean.class, true));
        proxy.addNotificationListener(this, null, null);
        this.messages.clear();
        test.sendNotification();
        MBeanServerInvocationHandlerTestCase.assertTrue((this.messages.size() == 1 ? 1 : 0) != 0);
        proxy.removeNotificationListener(this);
        this.messages.clear();
        test.sendNotification();
        MBeanServerInvocationHandlerTestCase.assertTrue((this.messages.size() == 0 ? 1 : 0) != 0);
    }

    public void testNotificationEmitterRemoveTriplet() throws Exception {
        MBeanServer server = MBeanServerFactory.newMBeanServer();
        EmitterInvocationHandlerTest test = new EmitterInvocationHandlerTest();
        server.registerMBean(test, this.invocationHandlerTestName);
        NotificationEmitter proxy = (NotificationEmitter)((Object)MBeanServerInvocationHandler.newProxyInstance(server, this.invocationHandlerTestName, InvocationHandlerTestMBean.class, true));
        NotificationFilterSupport filter = new NotificationFilterSupport();
        filter.enableType("test");
        Object handback = new Object();
        proxy.addNotificationListener(this, filter, handback);
        this.messages.clear();
        test.sendNotification();
        MBeanServerInvocationHandlerTestCase.assertTrue((this.messages.size() == 1 ? 1 : 0) != 0);
        proxy.removeNotificationListener(this, filter, handback);
        this.messages.clear();
        test.sendNotification();
        MBeanServerInvocationHandlerTestCase.assertTrue((this.messages.size() == 0 ? 1 : 0) != 0);
    }

    public void testNotificationEmitterRemoveTripletFailsOnBroadcaster() throws Exception {
        MBeanServer server = MBeanServerFactory.newMBeanServer();
        BroadcasterInvocationHandlerTest test = new BroadcasterInvocationHandlerTest();
        server.registerMBean(test, this.invocationHandlerTestName);
        NotificationEmitter proxy = (NotificationEmitter)((Object)MBeanServerInvocationHandler.newProxyInstance(server, this.invocationHandlerTestName, InvocationHandlerTestMBean.class, true));
        NotificationFilterSupport filter = new NotificationFilterSupport();
        filter.enableType("test");
        Object handback = new Object();
        proxy.addNotificationListener(this, filter, handback);
        this.messages.clear();
        test.sendNotification();
        MBeanServerInvocationHandlerTestCase.assertTrue((this.messages.size() == 1 ? 1 : 0) != 0);
        try {
            proxy.removeNotificationListener(this, filter, handback);
            MBeanServerInvocationHandlerTestCase.fail((String)"FAILS IN JBOSSMX: removeNotificationListener(NotificationListener, NotificationFilter, Object) should not work for a broadcaster");
        }
        catch (Exception ignored) {
            // empty catch block
        }
    }

    public void testGetNotificationInfo() throws Exception {
        MBeanServer server = MBeanServerFactory.newMBeanServer();
        EmitterInvocationHandlerTest test = new EmitterInvocationHandlerTest();
        server.registerMBean(test, this.invocationHandlerTestName);
        NotificationEmitter proxy = (NotificationEmitter)((Object)MBeanServerInvocationHandler.newProxyInstance(server, this.invocationHandlerTestName, InvocationHandlerTestMBean.class, true));
        MBeanNotificationInfo[] info = proxy.getNotificationInfo();
        MBeanServerInvocationHandlerTestCase.assertEquals((String)"test", (String)info[0].getNotifTypes()[0]);
    }

    public void testToString() throws Exception {
        MBeanServer server = MBeanServerFactory.newMBeanServer();
        ObjectInvocationHandlerTest test = new ObjectInvocationHandlerTest();
        server.registerMBean(test, this.invocationHandlerTestName);
        InvocationHandlerTestMBean proxy = MBeanServerInvocationHandler.newProxyInstance(server, this.invocationHandlerTestName, InvocationHandlerTestMBean.class, true);
        MBeanServerInvocationHandlerTestCase.assertEquals((String)"TOSTRING", (String)proxy.toString());
    }

    public void testToStringFailsWhenNotExposed() throws Exception {
        MBeanServer server = MBeanServerFactory.newMBeanServer();
        InvocationHandlerTest test = new InvocationHandlerTest();
        server.registerMBean(test, this.invocationHandlerTestName);
        InvocationHandlerTestMBean proxy = MBeanServerInvocationHandler.newProxyInstance(server, this.invocationHandlerTestName, InvocationHandlerTestMBean.class, true);
        try {
            proxy.toString();
            MBeanServerInvocationHandlerTestCase.fail((String)"toString() should not work when it is not exposed for management");
        }
        catch (Exception ignored) {
            // empty catch block
        }
    }

    public void testEquals() throws Exception {
        MBeanServer server = MBeanServerFactory.newMBeanServer();
        ObjectInvocationHandlerTest test = new ObjectInvocationHandlerTest();
        server.registerMBean(test, this.invocationHandlerTestName);
        InvocationHandlerTestMBean proxy = MBeanServerInvocationHandler.newProxyInstance(server, this.invocationHandlerTestName, InvocationHandlerTestMBean.class, true);
        MBeanServerInvocationHandlerTestCase.assertTrue((boolean)proxy.equals(new Object()));
    }

    public void testEqualsFailsWhenNotExposed() throws Exception {
        MBeanServer server = MBeanServerFactory.newMBeanServer();
        InvocationHandlerTest test = new InvocationHandlerTest();
        server.registerMBean(test, this.invocationHandlerTestName);
        InvocationHandlerTestMBean proxy = MBeanServerInvocationHandler.newProxyInstance(server, this.invocationHandlerTestName, InvocationHandlerTestMBean.class, true);
        try {
            proxy.equals(new Object());
            MBeanServerInvocationHandlerTestCase.fail((String)"equals(Object) should not work when it is not exposed for management");
        }
        catch (Exception ignored) {
            // empty catch block
        }
    }

    public void testHashCode() throws Exception {
        MBeanServer server = MBeanServerFactory.newMBeanServer();
        ObjectInvocationHandlerTest test = new ObjectInvocationHandlerTest();
        server.registerMBean(test, this.invocationHandlerTestName);
        InvocationHandlerTestMBean proxy = MBeanServerInvocationHandler.newProxyInstance(server, this.invocationHandlerTestName, InvocationHandlerTestMBean.class, true);
        MBeanServerInvocationHandlerTestCase.assertEquals((int)1234, (int)proxy.hashCode());
    }

    public void testHashCodeFailsWhenNotExposed() throws Exception {
        MBeanServer server = MBeanServerFactory.newMBeanServer();
        InvocationHandlerTest test = new InvocationHandlerTest();
        server.registerMBean(test, this.invocationHandlerTestName);
        InvocationHandlerTestMBean proxy = MBeanServerInvocationHandler.newProxyInstance(server, this.invocationHandlerTestName, InvocationHandlerTestMBean.class, true);
        try {
            proxy.hashCode();
            MBeanServerInvocationHandlerTestCase.fail((String)"hashCode() should not work when it is not exposed for management");
        }
        catch (Exception ignored) {
            // empty catch block
        }
    }

    public void handleNotification(Notification notification, Object handback) {
        this.messages.add(notification);
    }
}

