/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.jmx.compliance.server;

import java.util.ArrayList;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;

public class MBeanServerFactoryTEST
extends TestCase {
    public MBeanServerFactoryTEST(String s) {
        super(s);
    }

    public void testFindNonCreated() {
        MBeanServerFactory.newMBeanServer();
        ArrayList<MBeanServer> mbsList = MBeanServerFactory.findMBeanServer(null);
        MBeanServerFactoryTEST.assertEquals((int)0, (int)mbsList.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateFindAndRelease() {
        MBeanServer server = null;
        ArrayList<MBeanServer> mbsList = null;
        try {
            server = MBeanServerFactory.createMBeanServer();
            mbsList = MBeanServerFactory.findMBeanServer(null);
            MBeanServerFactoryTEST.assertEquals((int)1, (int)mbsList.size());
        }
        finally {
            if (null != server) {
                MBeanServerFactory.releaseMBeanServer(server);
            }
        }
        mbsList = MBeanServerFactory.findMBeanServer(null);
        MBeanServerFactoryTEST.assertEquals((int)0, (int)mbsList.size());
    }

    public void testRemoveNonCreated() {
        try {
            MBeanServer server = MBeanServerFactory.newMBeanServer();
            MBeanServerFactory.releaseMBeanServer(server);
            MBeanServerFactoryTEST.fail((String)"expected an IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
        }
        catch (Exception e) {
            MBeanServerFactoryTEST.fail((String)("expected an IllegalArgumentException but got: " + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDomainCreated() {
        String domain = "dOmAiN";
        MBeanServer server = null;
        try {
            server = MBeanServerFactory.createMBeanServer(domain);
            MBeanServerFactoryTEST.assertEquals((String)domain, (String)server.getDefaultDomain());
            ArrayList<MBeanServer> mbsList = MBeanServerFactory.findMBeanServer(null);
            MBeanServerFactoryTEST.assertEquals((Object)server, mbsList.get(0));
            MBeanServerFactoryTEST.assertTrue((String)"expected server reference equality", (mbsList.get(0) == server ? 1 : 0) != 0);
        }
        finally {
            if (null != server) {
                MBeanServerFactory.releaseMBeanServer(server);
            }
        }
    }

    public void testDomainNonCreated() {
        String domain = "dOmAiN";
        MBeanServer server = MBeanServerFactory.newMBeanServer(domain);
        MBeanServerFactoryTEST.assertEquals((String)domain, (String)server.getDefaultDomain());
    }

    public void testFindByAgentID() {
        try {
            MBeanServer server1 = MBeanServerFactory.createMBeanServer();
            MBeanServer server2 = MBeanServerFactory.createMBeanServer();
            MBeanServer server3 = MBeanServerFactory.newMBeanServer();
            ObjectName delegateName = new ObjectName("JMImplementation:type=MBeanServerDelegate");
            String agentID1 = (String)server1.getAttribute(delegateName, "MBeanServerId");
            String agentID2 = (String)server2.getAttribute(delegateName, "MBeanServerId");
            String agentID3 = (String)server3.getAttribute(delegateName, "MBeanServerId");
            MBeanServerFactoryTEST.assertTrue((MBeanServerFactory.findMBeanServer(agentID1).get(0) == server1 ? 1 : 0) != 0);
            MBeanServerFactoryTEST.assertTrue((MBeanServerFactory.findMBeanServer(agentID2).get(0) == server2 ? 1 : 0) != 0);
            MBeanServerFactoryTEST.assertTrue((MBeanServerFactory.findMBeanServer(agentID3).size() == 0 ? 1 : 0) != 0);
        }
        catch (AssertionFailedError e) {
            throw e;
        }
        catch (Throwable t) {
            MBeanServerFactoryTEST.fail((String)("Unexpected error: " + t.toString()));
        }
    }
}

