/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.aspects.remoting.interceptors.transport;

import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aspects.remoting.interceptors.invoker.RemotingInterceptorFactory;
import org.jboss.remoting.Client;
import org.jboss.remoting.marshal.Marshaller;

/**
 * @author <a href="mailto:tom@jboss.org">Tom Elrod</a>
 */
public class TransportInterceptor implements Interceptor
{
   private Client client;

   public TransportInterceptor(Client client)
   {
      this.client = client;
   }

   public String getName()
   {
      return "TransportInterceptor";
   }

   public Object invoke(Invocation invocation) throws Throwable
   {
      // need to add marshaller to invocation so can be found by transport later on
      Marshaller marshaller = (Marshaller) invocation.getMetaData().getMetaData(RemotingInterceptorFactory.REMOTING,
            RemotingInterceptorFactory.MARSHALLER);

      if (marshaller != null)
      {
         client.setMarshaller(marshaller);
      }

      return client.invoke(invocation, null);

   }
}