/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.remoting.interceptor;

import java.net.MalformedURLException;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.marshal.serializable.SerializableUnMarshaller;

import junit.framework.TestCase;

/**
 * @author <a href="mailto:telrod@e2technologies.net">Tom Elrod</a>
 */
public class InterceptorTestCase extends TestCase
{
   private boolean continueRun = true;

   public InterceptorTestCase(String name)
   {
      super(name);
   }

   protected void setUp() throws Exception
   {
      super.setUp();
      continueRun = true;
      new Thread()
      {
         public void run()
         {
            startServer();
         }
      }.start();
   }

   public void testClient() throws Exception
   {
      try
      {
         org.jboss.test.remoting.interceptor.ClientInterceptorTest test = new org.jboss.test.remoting.interceptor.ClientInterceptorTest();
         test.runTest();
         boolean passed = test.isTestPassing();
         assertTrue("ClientInterceptorTest failed.", passed);
      }
      catch(MalformedURLException e)
      {
         e.printStackTrace();
      }

   }

   protected void tearDown() throws Exception
   {
      super.tearDown();
      continueRun = false;

   }


   public void startServer()
   {
      try
      {
         int port = 8081;
         String transport = "socket";
//         InvokerLocator locator = new InvokerLocator(transport + "://localhost:" + port + "/?" +
//               InvokerLocator.DATATYPE + "=" + SerializableUnMarshaller.DATATYPE);
         InvokerLocator locator = new InvokerLocator(transport + "://localhost:" + port + "/?" +
                                                     InvokerLocator.DATATYPE + "=" + SerializableUnMarshaller.DATATYPE);

         ServerInterceptorTest server = new ServerInterceptorTest();
         server.setLocator(locator);
         server.setup();

         while(continueRun)
         {
            Thread.sleep(1000);
         }
      }
      catch(Exception e)
      {
         e.printStackTrace();
      }
   }

}