/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.mq.il.uil2.msgs;

import java.io.ObjectOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import org.jboss.mq.DurableSubscriptionID;

/**
 * @author Scott.Stark@jboss.org
 * @version $Revision: 37459 $
 */
public class DeleteSubscriptionMsg extends BaseMsg
{
   private DurableSubscriptionID id;

   public DeleteSubscriptionMsg()
   {
      this(null);
   }
   public DeleteSubscriptionMsg(DurableSubscriptionID id)
   {
      super(MsgTypes.m_destroySubscription);
      this.id = id;
   }

   public DurableSubscriptionID getSubscriptionID()
   {
      return id;
   }

   public void trimReply()
   {
      id = null;
   }

   public void write(ObjectOutputStream out) throws IOException
   {
      super.write(out);
      int hasId = id != null ? 1 : 0;
      out.writeByte(hasId);
      if (hasId == 1)
         out.writeObject(id);
   }
   public void read(ObjectInputStream in) throws IOException, ClassNotFoundException
   {
      super.read(in);
      int hasId = in.readByte();
      if (hasId == 1)
         id = (DurableSubscriptionID) in.readObject();
   }
}
