/*
 * Decompiled with CFR 0.152.
 */
package test.performance.standard;

import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import junit.framework.TestCase;
import org.jboss.mx.server.ServerConstants;
import test.performance.standard.support.Standard;

public class OptimizedInvocationTEST
extends TestCase
implements ServerConstants {
    public OptimizedInvocationTEST(String s) {
        super(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testVoidInvocationWithDefaultDomain() {
        try {
            System.setProperty("jbossmx.optimized.dispatcher", "true");
            System.out.println("\nSTANDARD (OPTIMIZED): void invocation with DefaultDomain");
            System.out.println("100000 Invocations, Repeat: x10");
            System.out.println("(this may take a while...)\n");
            MBeanServer server = MBeanServerFactory.createMBeanServer();
            ObjectName name = new ObjectName(":performanceTest=standard");
            String method = "methodInvocation";
            long start = 0L;
            long end = 0L;
            float avg = 0.0f;
            server.registerMBean(new Standard(), name);
            for (int testIterations = 0; testIterations < 11; ++testIterations) {
                start = System.currentTimeMillis();
                for (int invocationIterations = 0; invocationIterations < 100000; ++invocationIterations) {
                    server.invoke(name, method, null, null);
                }
                end = System.currentTimeMillis();
                if (testIterations == 0) continue;
                long time = end - start;
                System.out.print(time + " ");
                avg += (float)time;
            }
            System.out.println("\nAverage: " + avg / 10.0f);
        }
        catch (Throwable t) {
            t.printStackTrace();
            OptimizedInvocationTEST.fail((String)("Unexpected error: " + t.toString()));
        }
        finally {
            System.setProperty("jbossmx.optimized.dispatcher", "false");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testVoidInvocation() {
        try {
            System.setProperty("jbossmx.optimized.dispatcher", "true");
            System.out.println("\nSTANDARD (OPTIMIZED): void invocation");
            System.out.println("100000 Invocations, Repeat: x10");
            System.out.println("(this may take a while...)\n");
            MBeanServer server = MBeanServerFactory.createMBeanServer();
            ObjectName name = new ObjectName("Domain:performanceTest=standard");
            String method = "methodInvocation";
            long start = 0L;
            long end = 0L;
            float avg = 0.0f;
            server.registerMBean(new Standard(), name);
            for (int testIterations = 0; testIterations < 11; ++testIterations) {
                start = System.currentTimeMillis();
                for (int invocationIterations = 0; invocationIterations < 100000; ++invocationIterations) {
                    server.invoke(name, method, null, null);
                }
                end = System.currentTimeMillis();
                if (testIterations == 0) continue;
                long time = end - start;
                System.out.print(time + " ");
                avg += (float)time;
            }
            System.out.println("\nAverage: " + avg / 10.0f);
        }
        catch (Throwable t) {
            t.printStackTrace();
            OptimizedInvocationTEST.fail((String)("Unexpected error: " + t.toString()));
        }
        finally {
            System.setProperty("jbossmx.optimized.dispatcher", "false");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCounterInvocation() {
        try {
            System.setProperty("jbossmx.optimized.dispatcher", "true");
            System.out.println("\nSTANDARD (OPTIMIZED): counter invocation");
            System.out.println("100000 Invocations, Repeat: x10");
            System.out.println("(this may take a while...)\n");
            MBeanServer server = MBeanServerFactory.createMBeanServer();
            ObjectName name = new ObjectName("Domain:performanceTest=standard");
            Standard mbean = new Standard();
            String method = "counter";
            long start = 0L;
            long end = 0L;
            float avg = 0.0f;
            server.registerMBean(mbean, name);
            for (int testIterations = 0; testIterations < 11; ++testIterations) {
                start = System.currentTimeMillis();
                for (int invocationIterations = 0; invocationIterations < 100000; ++invocationIterations) {
                    server.invoke(name, method, null, null);
                }
                end = System.currentTimeMillis();
                if (testIterations == 0) continue;
                long time = end - start;
                System.out.print(time + " ");
                avg += (float)time;
            }
            System.out.println("\nAverage: " + avg / 10.0f);
            OptimizedInvocationTEST.assertTrue((mbean.getCount() == 1100000 ? 1 : 0) != 0);
        }
        catch (Throwable t) {
            t.printStackTrace();
            OptimizedInvocationTEST.fail((String)("Unexpected error: " + t.toString()));
        }
        finally {
            System.setProperty("jbossmx.optimized.dispatcher", "false");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMixedArgsInvocation() {
        try {
            System.setProperty("jbossmx.optimized.dispatcher", "true");
            System.out.println("\nSTANDARD (OPTIMIZED): mixed arguments invocation");
            System.out.println("100000 Invocations, Repeat: x10");
            System.out.println("(this may take a while...)\n");
            MBeanServer server = MBeanServerFactory.createMBeanServer();
            ObjectName name = new ObjectName("Domain:performanceTest=standard");
            Standard mbean = new Standard();
            String method = "mixedArguments";
            String[] signature = new String[]{Integer.class.getName(), Integer.TYPE.getName(), Object[][][].class.getName(), Attribute.class.getName()};
            Object[] args = new Object[]{new Integer(1234), new Integer(455617), new Object[][][]{{{"1x1x1", "1x1x2", "1x1x3"}, {"1x2x1", "1x2x2", "1x2x3"}, {"1x3x1", "1x3x2", "1x3x3"}}, {{"2x1x1", "2x1x2", "2x1x3"}, {"2x2x1", "2x2x2", "2x2x3"}, {"2x3x1", "2x3x2", "2x3x3"}}, {{"3x1x1", "3x1x2", "3x1x3"}, {"3x2x1", "3x2x2", "3x2x3"}, {"3x3x1", "3x3x2", "3x3x3"}}}, new Attribute("attribute", "value")};
            long start = 0L;
            long end = 0L;
            float avg = 0.0f;
            server.registerMBean(mbean, name);
            for (int testIterations = 0; testIterations < 11; ++testIterations) {
                start = System.currentTimeMillis();
                for (int invocationIterations = 0; invocationIterations < 100000; ++invocationIterations) {
                    server.invoke(name, method, args, signature);
                }
                end = System.currentTimeMillis();
                if (testIterations == 0) continue;
                long time = end - start;
                System.out.print(time + " ");
                avg += (float)time;
            }
            System.out.println("\nAverage: " + avg / 10.0f);
        }
        catch (Throwable t) {
            t.printStackTrace();
            OptimizedInvocationTEST.fail((String)("Unexpected error: " + t.toString()));
        }
        finally {
            System.setProperty("jbossmx.optimized.dispatcher", "false");
        }
    }
}

