/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.loading;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import EDU.oswego.cs.dl.util.concurrent.CopyOnWriteArraySet;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.jboss.classloading.spi.ClassLoadingDomain;
import org.jboss.classloading.spi.DomainClassLoader;
import org.jboss.logging.Logger;
import org.jboss.mx.loading.ClassLoaderUtils;
import org.jboss.mx.loading.DomainClassLoaderUCLImpl;
import org.jboss.mx.loading.LoadMgr3;
import org.jboss.mx.loading.LoaderRepositoryDomain;
import org.jboss.mx.loading.RepositoryClassLoader;
import org.jboss.mx.loading.ResourceInfo;
import org.jboss.mx.loading.UnifiedLoaderRepository3;
import org.jboss.mx.loading.UnifiedLoaderRepositoryDCLMBean;
import org.jboss.mx.util.JBossNotificationBroadcasterSupport;
import org.jboss.util.Classes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnifiedLoaderRepositoryDCL
extends LoaderRepositoryDomain
implements MBeanRegistration,
NotificationBroadcaster,
UnifiedLoaderRepositoryDCLMBean {
    private static final Logger log = Logger.getLogger(UnifiedLoaderRepository3.class);
    private static int addedCount;
    private CopyOnWriteArraySet classLoaders = new CopyOnWriteArraySet();
    private HashSet dynamicClassLoaders = new HashSet();
    private HashMap nonUCLClassLoader = new HashMap();
    private HashSet classLoaderURLs = new HashSet();
    private ConcurrentReaderHashMap classes = new ConcurrentReaderHashMap();
    private HashMap loaderToClassesMap = new HashMap();
    private HashMap loaderToResourcesMap = new HashMap();
    private HashMap globalResources = new HashMap();
    private ConcurrentReaderHashMap packagesMap = new ConcurrentReaderHashMap();
    private HashMap<DomainClassLoader, List<String>> loaderToPackagesMap = new HashMap();
    private long sequenceNumber = 0L;
    private final JBossNotificationBroadcasterSupport broadcaster = new JBossNotificationBroadcasterSupport();
    private MBeanNotificationInfo[] info;

    @Override
    public DomainClassLoader newClassLoader(URL url, boolean addToRepository) throws Exception {
        URL[] cp = new URL[]{url};
        DomainClassLoaderUCLImpl ucl = new DomainClassLoaderUCLImpl(cp, this);
        if (addToRepository) {
            this.registerClassLoader((DomainClassLoader)ucl);
        }
        return ucl;
    }

    @Override
    public DomainClassLoader newClassLoader(URL url, URL origURL, boolean addToRepository) throws Exception {
        URL[] cp = new URL[]{url};
        DomainClassLoaderUCLImpl ucl = new DomainClassLoaderUCLImpl(cp, this);
        if (addToRepository) {
            this.registerClassLoader((DomainClassLoader)ucl);
        }
        return ucl;
    }

    public ClassLoadingDomain getParent() {
        return null;
    }

    @Override
    public int getCacheSize() {
        return this.classes.size();
    }

    @Override
    public int getClassLoadersSize() {
        return this.classLoaders.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        ConcurrentReaderHashMap concurrentReaderHashMap = this.classes;
        synchronized (concurrentReaderHashMap) {
            this.classes.clear();
        }
    }

    public Class getCachedClass(String classname) {
        return (Class)this.classes.get((Object)classname);
    }

    public Class loadClass(String name, boolean resolve, DomainClassLoader cl) throws ClassNotFoundException {
        return this.loadClassFromClassLoader(name, resolve, cl);
    }

    @Override
    public Set getPackageClassLoaders(String className) {
        String pkgName = ClassLoaderUtils.getPackageName(className);
        Set pkgSet = (Set)this.packagesMap.get((Object)pkgName);
        if (this.dynamicClassLoaders.size() > 0) {
            if (pkgSet == null) {
                pkgSet = ClassLoaderUtils.newPackageSet();
            }
            pkgSet.addAll(this.dynamicClassLoaders);
        }
        return pkgSet;
    }

    private String getResourcePackageName(String rsrcName) {
        int index = rsrcName.lastIndexOf(47);
        String pkgName = rsrcName;
        if (index > 0) {
            pkgName = rsrcName.substring(0, index);
        }
        return pkgName.replace('/', '.');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class loadClassFromCache(String name) {
        Class cls = null;
        ConcurrentReaderHashMap concurrentReaderHashMap = this.classes;
        synchronized (concurrentReaderHashMap) {
            cls = (Class)this.classes.get((Object)name);
        }
        return cls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheLoadedClass(String name, Class cls, DomainClassLoader cl) {
        ConcurrentReaderHashMap concurrentReaderHashMap = this.classes;
        synchronized (concurrentReaderHashMap) {
            HashSet<String> loadedClasses;
            Object prevClass = this.classes.put((Object)name, (Object)cls);
            if (log.isTraceEnabled()) {
                log.trace((Object)("cacheLoadedClass, classname: " + name + ", class: " + cls + ", ucl: " + cl + ", prevClass: " + prevClass));
            }
            if ((loadedClasses = (HashSet<String>)this.loaderToClassesMap.get(cl)) == null) {
                loadedClasses = new HashSet<String>();
                this.loaderToClassesMap.put(cl, loadedClasses);
            }
            loadedClasses.add(name);
        }
    }

    Class loadClassFromClassLoader(String name, boolean resolve, DomainClassLoader cl) {
        try {
            Class cls = cl.loadClassLocally(name, resolve);
            this.cacheLoadedClass(name, cls, cl);
            return cls;
        }
        catch (ClassNotFoundException x) {
            return null;
        }
    }

    public URL getResource(String name, DomainClassLoader cl) {
        URL resource = this.getResourceFromCache(name, cl);
        if (resource != null) {
            return resource;
        }
        resource = this.getResourceFromClassLoader(name, cl);
        if (resource != null) {
            return resource;
        }
        resource = this.getResourceFromGlobalCache(name);
        if (resource != null) {
            return resource;
        }
        resource = this.getResourceFromRepository(name, cl);
        if (resource != null) {
            return resource;
        }
        return null;
    }

    public void getResources(String name, DomainClassLoader cl, List urls) {
        for (DomainClassLoader nextCL : this.classLoaders) {
            if (!(nextCL instanceof DomainClassLoader)) continue;
            DomainClassLoader ucl = nextCL;
            try {
                Enumeration resURLs = ucl.findResourcesLocally(name);
                while (resURLs.hasMoreElements()) {
                    Object res = resURLs.nextElement();
                    urls.add(res);
                }
            }
            catch (IOException ignore) {
            }
        }
    }

    public Enumeration<URL> findResources(String name) {
        Vector resources = new Vector();
        this.getResources(name, null, resources);
        return resources.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL getResourceFromCache(String name, DomainClassLoader cl) {
        URL resource = null;
        HashMap hashMap = this.loaderToResourcesMap;
        synchronized (hashMap) {
            if (this.loaderToResourcesMap.containsKey(cl)) {
                HashMap resources = (HashMap)this.loaderToResourcesMap.get(cl);
                resource = (URL)resources.get(name);
            }
        }
        return resource;
    }

    private URL getResourceFromClassLoader(String name, DomainClassLoader cl) {
        URL resource = null;
        if (cl instanceof DomainClassLoader) {
            DomainClassLoader ucl = cl;
            resource = ucl.loadResourceLocally(name);
            this.cacheLoadedResource(name, resource, cl);
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected URL getResourceFromGlobalCache(String name) {
        ResourceInfo ri = null;
        HashMap hashMap = this.loaderToResourcesMap;
        synchronized (hashMap) {
            ri = (ResourceInfo)this.globalResources.get(name);
        }
        URL resource = null;
        if (ri != null) {
            resource = ri.url;
        }
        return resource;
    }

    protected URL getResourceFromRepository(String name, DomainClassLoader cl) {
        String pkgName = this.getResourcePackageName(name);
        Iterator i = null;
        Set pkgSet = (Set)this.packagesMap.get((Object)pkgName);
        if (pkgSet != null) {
            i = pkgSet.iterator();
        }
        if (i == null) {
            i = this.classLoaders.iterator();
        }
        URL url = null;
        while (i.hasNext()) {
            DomainClassLoader classloader = (DomainClassLoader)i.next();
            if (classloader.equals(cl) || !(classloader instanceof DomainClassLoader) || (url = classloader.loadResourceLocally(name)) == null) continue;
            this.cacheLoadedResource(name, url, classloader);
            this.cacheGlobalResource(name, url, classloader);
            break;
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheLoadedResource(String name, URL url, DomainClassLoader cl) {
        HashMap hashMap = this.loaderToResourcesMap;
        synchronized (hashMap) {
            HashMap<String, URL> resources = (HashMap<String, URL>)this.loaderToResourcesMap.get(cl);
            if (resources == null) {
                resources = new HashMap<String, URL>();
                this.loaderToResourcesMap.put(cl, resources);
            }
            resources.put(name, url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheGlobalResource(String name, URL url, DomainClassLoader cl) {
        HashMap hashMap = this.loaderToResourcesMap;
        synchronized (hashMap) {
            this.globalResources.put(name, new ResourceInfo<DomainClassLoader>(url, cl));
        }
    }

    @Override
    public URL[] getURLs() {
        HashSet<URL> classpath = new HashSet<URL>();
        CopyOnWriteArraySet tmp = this.classLoaders;
        for (Object obj : tmp) {
            if (!(obj instanceof DomainClassLoader)) continue;
            DomainClassLoader cl = (DomainClassLoader)obj;
            URL[] urls = cl.getClasspath();
            int length = urls != null ? urls.length : 0;
            for (int u = 0; u < length; ++u) {
                URL path = urls[u];
                classpath.add(path);
            }
        }
        URL[] cp = new URL[classpath.size()];
        classpath.toArray(cp);
        return cp;
    }

    @Override
    public String displayClassInfo(String className) {
        String classRsrcName = className.replace('.', '/') + ".class";
        int count = 0;
        Class loadedClass = this.loadClassFromCache(className);
        StringBuffer results = new StringBuffer(className + " Information\n");
        if (loadedClass != null) {
            results.append("Repository cache version:");
            Classes.displayClassInfo((Class)loadedClass, (StringBuffer)results);
        } else {
            results.append("Not loaded in repository cache\n");
        }
        CopyOnWriteArraySet tmp = this.classLoaders;
        for (URLClassLoader cl : tmp) {
            URL classURL = cl.findResource(classRsrcName);
            if (classURL == null) continue;
            results.append("\n\n### Instance" + count + " found in UCL: " + cl + "\n");
            ++count;
        }
        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
        URLClassLoader[] stack = ClassLoaderUtils.getClassLoaderStack(tcl);
        for (int s = 0; s < stack.length; ++s) {
            URLClassLoader cl = stack[s];
            URL classURL = cl.findResource(classRsrcName);
            if (classURL == null) continue;
            results.append("\n\n### Instance" + count + " via UCL: " + cl + "\n");
            ++count;
        }
        return results.toString();
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        ClassLoader scl = Thread.currentThread().getContextClassLoader();
        DomainClassLoader ucl = null;
        if (this.classLoaders.size() > 0) {
            ucl = (DomainClassLoader)this.classLoaders.iterator().next();
        }
        try {
            if (ucl != null) {
                return this.loadClass(className, false, ucl);
            }
        }
        catch (ClassNotFoundException ignore) {
            // empty catch block
        }
        try {
            return scl.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            Class clazz = UnifiedLoaderRepositoryDCL.getNativeClassForName((String)className);
            if (clazz != null) {
                return clazz;
            }
            throw new ClassNotFoundException(className);
        }
    }

    public Class loadClassWithout(DomainClassLoader loader, String className) throws ClassNotFoundException {
        throw new ClassNotFoundException("NYI");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DomainClassLoader getWrappingClassLoader(DomainClassLoader cl) {
        CopyOnWriteArraySet copyOnWriteArraySet = this.classLoaders;
        synchronized (copyOnWriteArraySet) {
            return (DomainClassLoader)this.nonUCLClassLoader.get(cl);
        }
    }

    public void addClassLoader(DomainClassLoader loader) {
        this.addDomainClassLoader((DomainClassLoaderUCLImpl)loader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addClassLoaderURL(DomainClassLoader cl, URL url) {
        DomainClassLoader ucl = cl;
        boolean added = false;
        CopyOnWriteArraySet copyOnWriteArraySet = this.classLoaders;
        synchronized (copyOnWriteArraySet) {
            String query = url.getQuery();
            if (query != null) {
                String ext = url.toExternalForm();
                String ext2 = ext.substring(0, ext.length() - query.length() - 1);
                try {
                    url = new URL(ext2);
                }
                catch (MalformedURLException e) {
                    log.warn((Object)("Failed to strip query from: " + url), (Throwable)e);
                }
            }
            if (!this.classLoaderURLs.contains(url)) {
                this.updatePackageMap(ucl);
                this.classLoaderURLs.add(url);
                added = true;
                if (query != null && query.indexOf("dynamic=true") >= 0) {
                    this.dynamicClassLoaders.add(ucl);
                }
            }
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDomainClassLoader(DomainClassLoaderUCLImpl cl) {
        cl.setDomain((ClassLoadingDomain)this);
        boolean added = false;
        CopyOnWriteArraySet copyOnWriteArraySet = this.classLoaders;
        synchronized (copyOnWriteArraySet) {
            boolean exists = false;
            URL[] cp = cl.getClasspath();
            this.classLoaderURLs.addAll(Arrays.asList(cp));
            added = this.classLoaders.add((Object)cl);
            if (added) {
                log.debug((Object)("Adding " + cl));
                cl.setAddedOrder(++addedCount);
                this.updatePackageMap((DomainClassLoader)cl);
            } else {
                log.debug((Object)("Skipping duplicate " + cl));
            }
        }
    }

    private synchronized void updatePackageMap(DomainClassLoader cl) {
        boolean trace = log.isTraceEnabled();
        try {
            URL[] cp;
            PackageMapper listener = new PackageMapper(cl);
            for (URL url : cp = cl.getClasspath()) {
                ClassLoaderUtils.updatePackageMap(url, (ClassLoaderUtils.PkgNameListener)listener);
            }
        }
        catch (Exception e) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Failed to update pkgs for cl=" + cl), (Throwable)e);
            }
            log.debug((Object)("Failed to update pkgs for cl=" + cl), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeClassLoader(DomainClassLoader loader) {
        ArrayList<Notification> removeNotifications = new ArrayList<Notification>();
        DomainClassLoader cl = loader;
        CopyOnWriteArraySet copyOnWriteArraySet = this.classLoaders;
        synchronized (copyOnWriteArraySet) {
            if (!(loader instanceof DomainClassLoader)) {
                cl = (DomainClassLoader)this.nonUCLClassLoader.remove(loader);
            }
            if (cl instanceof DomainClassLoader) {
                DomainClassLoader ucl = cl;
                if (this.getTranslator() != null) {
                    this.getTranslator().unregisterClassLoader(ucl);
                }
                URL[] urls = ucl.getClasspath();
                for (int u = 0; u < urls.length; ++u) {
                    this.classLoaderURLs.remove(urls[u]);
                }
            }
            boolean dynamic = this.dynamicClassLoaders.remove(cl);
            boolean removed = this.classLoaders.remove((Object)cl);
            log.debug((Object)("UnifiedLoaderRepository removed(" + removed + ") " + cl));
            HashSet loadedClasses = null;
            boolean hasLoadedClasses = false;
            Object object = this.classes;
            synchronized (object) {
                hasLoadedClasses = this.loaderToClassesMap.containsKey(cl);
                if (hasLoadedClasses) {
                    loadedClasses = (HashSet)this.loaderToClassesMap.remove(cl);
                }
                if (loadedClasses != null) {
                    for (String className : loadedClasses) {
                        Notification n = new Notification("jboss.mx.class.removed", (Object)this, this.getNextSequenceNumber(), className);
                        removeNotifications.add(n);
                    }
                    for (String cls : loadedClasses) {
                        this.classes.remove((Object)cls);
                    }
                }
            }
            object = this.loaderToResourcesMap;
            synchronized (object) {
                HashMap resources;
                if (this.loaderToResourcesMap.containsKey(cl) && (resources = (HashMap)this.loaderToResourcesMap.remove(cl)) != null) {
                    for (String name : resources.keySet()) {
                        ResourceInfo ri = (ResourceInfo)this.globalResources.get(name);
                        if (ri == null || ri.cl != cl) continue;
                        this.globalResources.remove(name);
                    }
                }
            }
            if (!dynamic) {
                List<String> pkgNames = this.loaderToPackagesMap.remove(cl);
                if (pkgNames != null) {
                    for (String pkgName : pkgNames) {
                        Set pkgSet = (Set)this.packagesMap.get((Object)pkgName);
                        if (pkgSet == null) continue;
                        pkgSet.remove(cl);
                        if (!pkgSet.isEmpty()) continue;
                        this.packagesMap.remove((Object)pkgName);
                    }
                }
            } else {
                this.loaderToPackagesMap.remove(cl);
                Iterator i = this.packagesMap.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry entry = (Map.Entry)i.next();
                    Set pkgSet = (Set)entry.getValue();
                    pkgSet.remove(cl);
                    if (!pkgSet.isEmpty()) continue;
                    i.remove();
                }
            }
        }
        for (int n = 0; n < removeNotifications.size(); ++n) {
            Notification msg = (Notification)removeNotifications.get(n);
            this.broadcaster.sendNotification(msg);
        }
        Notification msg = new Notification("jboss.mx.classloader.removed", this, this.getNextSequenceNumber());
        msg.setUserData(cl);
        this.broadcaster.sendNotification(msg);
    }

    @Override
    public LoaderRepositoryDomain registerClassLoader(DomainClassLoader ucl) {
        this.addClassLoader(ucl);
        Notification msg = new Notification("jboss.mx.classloader.added", this, this.getNextSequenceNumber());
        msg.setUserData(ucl);
        this.broadcaster.sendNotification(msg);
        return this;
    }

    @Override
    public LoaderRepositoryDomain getInstance() {
        return this;
    }

    @Override
    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        this.broadcaster.addNotificationListener(listener, filter, handback);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        if (this.info == null) {
            this.info = new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"CLASSLOADER_ADDED"}, "javax.management.Notification", "Notification that a classloader has been added to the extensible classloader"), new MBeanNotificationInfo(new String[]{"CLASS_REMOVED"}, "javax.management.Notification", "Notification that a class has been removed from the extensible classloader")};
        }
        return this.info;
    }

    @Override
    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.broadcaster.removeNotificationListener(listener);
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
        log.debug((Object)"postDeregister, clearing all references");
        this.classLoaders.clear();
        this.dynamicClassLoaders.clear();
        this.nonUCLClassLoader.clear();
        this.classLoaderURLs.clear();
        this.classes.clear();
        this.loaderToClassesMap.clear();
        this.loaderToResourcesMap.clear();
        this.globalResources.clear();
        this.packagesMap.clear();
        this.loaderToPackagesMap.clear();
    }

    String[] getPackageNames(DomainClassLoaderUCLImpl loader) {
        List<String> pkgNames = this.loaderToPackagesMap.get(loader);
        String[] tmp = new String[]{};
        if (pkgNames != null) {
            tmp = new String[pkgNames.size()];
            pkgNames.toArray(tmp);
        }
        return tmp;
    }

    private synchronized long getNextSequenceNumber() {
        return this.sequenceNumber++;
    }

    class PackageMapper
    implements ClassLoaderUtils.PkgNameListener {
        private DomainClassLoader loader;

        PackageMapper(DomainClassLoader loader) {
            this.loader = loader;
        }

        public void addPackage(String pkgName) {
            if (pkgName.startsWith("META-INF") || pkgName.startsWith("WEB-INF")) {
                return;
            }
            TreeSet<DomainClassLoader> pkgSet = (TreeSet<DomainClassLoader>)UnifiedLoaderRepositoryDCL.this.packagesMap.get((Object)pkgName);
            if (pkgSet == null) {
                pkgSet = new TreeSet<DomainClassLoader>(new DomainClassLoaderUCLImplComparator());
                UnifiedLoaderRepositoryDCL.this.packagesMap.put((Object)pkgName, pkgSet);
            }
            if (!pkgSet.contains(this.loader)) {
                pkgSet.add(this.loader);
                ArrayList<String> loaderPkgNames = (ArrayList<String>)UnifiedLoaderRepositoryDCL.this.loaderToPackagesMap.get(this.loader);
                if (loaderPkgNames == null) {
                    loaderPkgNames = new ArrayList<String>();
                    UnifiedLoaderRepositoryDCL.this.loaderToPackagesMap.put(this.loader, loaderPkgNames);
                }
                loaderPkgNames.add(pkgName);
                if (pkgSet.size() > 1) {
                    log.debug((Object)("Multiple class loaders found for pkg: " + pkgName));
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Indexed pkg: " + pkgName + ", UCL: " + this.loader));
                }
            }
        }
    }

    private static class DomainClassLoaderUCLImplComparator
    implements Comparator {
        private DomainClassLoaderUCLImplComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof LoadMgr3.PkgClassLoader) {
                LoadMgr3.PkgClassLoader pkg1 = (LoadMgr3.PkgClassLoader)o1;
                LoadMgr3.PkgClassLoader pkg2 = (LoadMgr3.PkgClassLoader)o2;
                RepositoryClassLoader rcl1 = pkg1.ucl;
                RepositoryClassLoader rcl2 = pkg2.ucl;
                int test = pkg1.order - pkg2.order;
                if (test != 0) {
                    return test;
                }
                return rcl1.getAddedOrder() - rcl2.getAddedOrder();
            }
            DomainClassLoaderUCLImpl rcl1 = (DomainClassLoaderUCLImpl)o1;
            DomainClassLoaderUCLImpl rcl2 = (DomainClassLoaderUCLImpl)o2;
            return rcl1.getAddedOrder() - rcl2.getAddedOrder();
        }
    }
}

