/*
 * Decompiled with CFR 0.152.
 */
package test.implementation.util;

import java.lang.reflect.Method;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.modelmbean.RequiredModelMBean;
import junit.framework.TestCase;
import org.jboss.mx.modelmbean.XMBean;
import org.jboss.mx.util.AgentID;
import org.jboss.mx.util.DefaultExceptionHandler;
import org.jboss.mx.util.MBeanProxy;
import org.jboss.mx.util.ProxyContext;
import org.jboss.mx.util.ProxyExceptionHandler;
import test.implementation.util.support.ExtendedResource;
import test.implementation.util.support.MyInterface;
import test.implementation.util.support.MyInterface2;
import test.implementation.util.support.Resource;
import test.implementation.util.support.ResourceIncorrectInfo;
import test.implementation.util.support.ResourceOverride;
import test.implementation.util.support.Trivial;
import test.implementation.util.support.Trivial2;
import test.implementation.util.support.Trivial2MBean;
import test.implementation.util.support.TrivialMBean;

public class MBeanProxyTEST
extends TestCase {
    public MBeanProxyTEST(String s) {
        super(s);
    }

    public void testGetWithServer() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        ObjectName oname = new ObjectName("test:name=test");
        server.registerMBean(new Trivial(), oname);
        TrivialMBean mbean = (TrivialMBean)MBeanProxy.get(TrivialMBean.class, (ObjectName)oname, (MBeanServer)server);
        mbean.doOperation();
    }

    public void testGetWithAgentID() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        String agentID = AgentID.get((MBeanServer)server);
        ObjectName oname = new ObjectName("test:name=test");
        server.registerMBean(new Trivial(), oname);
        TrivialMBean mbean = (TrivialMBean)MBeanProxy.get(TrivialMBean.class, (ObjectName)oname, (String)agentID);
        mbean.doOperation();
    }

    public void testCreateWithServer() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        ObjectName oname = new ObjectName("test:test=test");
        TrivialMBean mbean = (TrivialMBean)MBeanProxy.create(Trivial.class, TrivialMBean.class, (ObjectName)oname, (MBeanServer)server);
        mbean.doOperation();
    }

    public void testCreateWithAgentID() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        ObjectName oname = new ObjectName("test:test=test");
        String agentID = AgentID.get((MBeanServer)server);
        TrivialMBean mbean = (TrivialMBean)MBeanProxy.create(Trivial.class, TrivialMBean.class, (ObjectName)oname, (String)agentID);
        mbean.doOperation();
    }

    public void testProxyInvocations() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        ObjectName oname = new ObjectName("test:name=test");
        server.registerMBean(new Trivial(), oname);
        TrivialMBean mbean = (TrivialMBean)MBeanProxy.get(TrivialMBean.class, (ObjectName)oname, (String)AgentID.get((MBeanServer)server));
        mbean.doOperation();
        mbean.setSomething("JBossMX");
        MBeanProxyTEST.assertEquals((String)"JBossMX", (String)mbean.getSomething());
    }

    public void testProxyInvocationWithConflictingMBeanAndContextMethods() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        ObjectName oname = new ObjectName("test:test=test");
        server.registerMBean(new Trivial(), oname);
        TrivialMBean mbean = (TrivialMBean)MBeanProxy.get(TrivialMBean.class, (ObjectName)oname, (String)AgentID.get((MBeanServer)server));
        mbean.getMBeanServer();
        MBeanProxyTEST.assertTrue((boolean)mbean.isGMSInvoked());
    }

    public void testContextAccess() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        ObjectName oname = new ObjectName("test:test=test");
        Trivial2MBean mbean = (Trivial2MBean)MBeanProxy.create(Trivial2.class, Trivial2MBean.class, (ObjectName)oname, (MBeanServer)server);
        ProxyContext ctx = (ProxyContext)mbean;
        ctx.getMBeanServer();
    }

    public void testProxyInvocationBetweenServers() throws Exception {
        MBeanServer server1 = MBeanServerFactory.createMBeanServer();
        MBeanServer server2 = MBeanServerFactory.createMBeanServer();
        ObjectName oname1 = new ObjectName("test:name=target");
        ObjectName oname2 = new ObjectName("test:name=proxy");
        Trivial2MBean mbean = (Trivial2MBean)MBeanProxy.create(Trivial2.class, Trivial2MBean.class, (ObjectName)oname1, (MBeanServer)server1);
        server2.registerMBean(mbean, oname2);
        server2.invoke(oname2, "doOperation", null, null);
        MBeanProxyTEST.assertTrue((boolean)((Boolean)server1.getAttribute(oname1, "OperationInvoked")));
    }

    public void testSimultaneousTypedAndDetypedInvocations() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        ObjectName oname = new ObjectName("test:test=test");
        Trivial2MBean mbean = (Trivial2MBean)MBeanProxy.create(Trivial2.class, Trivial2MBean.class, (ObjectName)oname, (MBeanServer)server);
        mbean.setSomething("Kissa");
        MBeanProxyTEST.assertTrue((boolean)mbean.getSomething().equals("Kissa"));
        DynamicMBean mbean2 = (DynamicMBean)((Object)mbean);
        mbean2.setAttribute(new Attribute("Something", "Koira"));
        MBeanProxyTEST.assertTrue((boolean)mbean2.getAttribute("Something").equals("Koira"));
        server.setAttribute(oname, new Attribute("Something", "Kissa"));
        MBeanProxyTEST.assertTrue((boolean)server.getAttribute(oname, "Something").equals("Kissa"));
        mbean.doOperation();
        MBeanProxyTEST.assertTrue((boolean)mbean.isOperationInvoked());
        mbean.reset();
        mbean2.invoke("doOperation", null, null);
        MBeanProxyTEST.assertTrue((boolean)((Boolean)mbean2.getAttribute("OperationInvoked")));
        mbean2.invoke("reset", null, null);
        server.invoke(oname, "doOperation", null, null);
        MBeanProxyTEST.assertTrue((boolean)((Boolean)server.getAttribute(oname, "OperationInvoked")));
    }

    public void testContextAccessToMBeanServer() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        ObjectName oname = new ObjectName("test:test=test");
        Trivial2MBean mbean = (Trivial2MBean)MBeanProxy.create(Trivial2.class, Trivial2MBean.class, (ObjectName)oname, (MBeanServer)server);
        ProxyContext ctx = (ProxyContext)mbean;
        MBeanServer srvr = ctx.getMBeanServer();
        Set<ObjectInstance> mbeans = srvr.queryMBeans(new ObjectName("test:*"), null);
        ObjectInstance oi = mbeans.iterator().next();
        MBeanProxyTEST.assertTrue((boolean)oi.getObjectName().equals(oname));
        MBeanProxyTEST.assertTrue((boolean)srvr.getAttribute(new ObjectName("JMImplementation:type=MBeanServerDelegate"), "ImplementationName").equals("JBossMX"));
    }

    public void testArbitraryInterfaceWithProxy() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        ObjectName oname = new ObjectName("test:test=test");
        RequiredModelMBean rmm = new RequiredModelMBean();
        Resource resource = new Resource();
        rmm.setManagedResource(resource, "ObjectReference");
        rmm.setModelMBeanInfo(resource.getMBeanInfo());
        server.registerMBean(rmm, oname);
        MyInterface mbean = (MyInterface)MBeanProxy.get(MyInterface.class, (ObjectName)oname, (MBeanServer)server);
        mbean.setAttributeName("foo");
        mbean.setAttributeName2("bar");
        MBeanProxyTEST.assertTrue((boolean)mbean.getAttributeName2().equals("bar"));
        MBeanProxyTEST.assertTrue((boolean)mbean.doOperation().equals("tamppi"));
    }

    public void testCustomExceptionHandler() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        ObjectName oname = new ObjectName("test:test=test");
        ObjectName oname2 = new ObjectName("test:test=test2");
        RequiredModelMBean rmm = new RequiredModelMBean();
        Resource resource = new Resource();
        rmm.setManagedResource(resource, "ObjectReference");
        rmm.setModelMBeanInfo(resource.getMBeanInfo());
        server.registerMBean(rmm, oname);
        server.registerMBean(rmm, oname2);
        ProxyContext ctx = (ProxyContext)MBeanProxy.get(MyInterface.class, (ObjectName)oname, (MBeanServer)server);
        ctx.setExceptionHandler((ProxyExceptionHandler)new DefaultExceptionHandler(){

            public Object handleInstanceNotFound(ProxyContext proxyCtx, InstanceNotFoundException e, Method m, Object[] args) throws Exception {
                return proxyCtx.getMBeanServer().invoke(new ObjectName("test:test=test2"), m.getName(), args, null);
            }
        });
        server.unregisterMBean(oname);
        MyInterface mbean = (MyInterface)ctx;
        MBeanProxyTEST.assertTrue((boolean)mbean.doOperation().equals("tamppi"));
    }

    public void testObjectToStringOnProxy() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        ObjectName oname = new ObjectName("test:test=test");
        RequiredModelMBean rmm = new RequiredModelMBean();
        Resource resource = new Resource();
        rmm.setManagedResource(resource, "ObjectReference");
        rmm.setModelMBeanInfo(resource.getMBeanInfo());
        server.registerMBean(rmm, oname);
        MyInterface mbean = (MyInterface)MBeanProxy.get(MyInterface.class, (ObjectName)oname, (MBeanServer)server);
        mbean.toString();
        MyInterface o = mbean;
        o.toString();
    }

    public void testObjectToStringOverride() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        ObjectName oname = new ObjectName("test:test=test");
        RequiredModelMBean rmm = new RequiredModelMBean();
        ResourceOverride resource = new ResourceOverride();
        rmm.setManagedResource(resource, "ObjectReference");
        rmm.setModelMBeanInfo(resource.getMBeanInfo());
        server.registerMBean(rmm, oname);
        MyInterface mbean = (MyInterface)MBeanProxy.get(MyInterface.class, (ObjectName)oname, (MBeanServer)server);
        MBeanProxyTEST.assertTrue((boolean)mbean.toString().equals("Resource"));
        MyInterface o = mbean;
        MBeanProxyTEST.assertTrue((boolean)o.toString().equals("Resource"));
    }

    public void testObjectHashCodeOnProxy() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        ObjectName oname = new ObjectName("test:test=test");
        RequiredModelMBean rmm = new RequiredModelMBean();
        Resource resource = new Resource();
        rmm.setManagedResource(resource, "ObjectReference");
        rmm.setModelMBeanInfo(resource.getMBeanInfo());
        server.registerMBean(rmm, oname);
        MyInterface mbean = (MyInterface)MBeanProxy.get(MyInterface.class, (ObjectName)oname, (MBeanServer)server);
        mbean.hashCode();
        MyInterface o = mbean;
        o.toString();
    }

    public void testObjectHashCodeOverride() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        ObjectName oname = new ObjectName("test:test=test");
        RequiredModelMBean rmm = new RequiredModelMBean();
        ResourceOverride resource = new ResourceOverride();
        rmm.setManagedResource(resource, "ObjectReference");
        rmm.setModelMBeanInfo(resource.getMBeanInfo());
        server.registerMBean(rmm, oname);
        MyInterface mbean = (MyInterface)MBeanProxy.get(MyInterface.class, (ObjectName)oname, (MBeanServer)server);
        MBeanProxyTEST.assertTrue((mbean.hashCode() == 10 ? 1 : 0) != 0);
        MyInterface o = mbean;
        MBeanProxyTEST.assertTrue((o.hashCode() == 10 ? 1 : 0) != 0);
    }

    public void testObjectEqualsOnProxy() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        ObjectName oname = new ObjectName("test:test=test");
        XMBean mmbean = new XMBean();
        Resource resource = new Resource();
        mmbean.setManagedResource(resource, "ObjectReference");
        mmbean.setModelMBeanInfo(resource.getMBeanInfo());
        server.registerMBean(mmbean, oname);
        MyInterface mbean = (MyInterface)MBeanProxy.get(MyInterface.class, (ObjectName)oname, (MBeanServer)server);
        MyInterface mbean2 = (MyInterface)MBeanProxy.get(MyInterface.class, (ObjectName)oname, (MBeanServer)server);
        MBeanProxyTEST.assertTrue((boolean)mbean.equals(mbean));
        MBeanProxyTEST.assertTrue((!mbean.equals(mbean2) ? 1 : 0) != 0);
        MBeanProxyTEST.assertTrue((!mbean2.equals(mbean) ? 1 : 0) != 0);
    }

    public void testObjectEqualsOverride() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        ObjectName oname = new ObjectName("test:test=test");
        RequiredModelMBean rmm = new RequiredModelMBean();
        ResourceOverride resource = new ResourceOverride("state");
        rmm.setManagedResource(resource, "ObjectReference");
        rmm.setModelMBeanInfo(resource.getMBeanInfo());
        server.registerMBean(rmm, oname);
        MyInterface mbean = (MyInterface)MBeanProxy.get(MyInterface.class, (ObjectName)oname, (MBeanServer)server);
        MBeanProxyTEST.assertTrue((boolean)mbean.equals(mbean));
    }

    public void testAttributeNotFoundOnTypedProxy() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        ObjectName oname = new ObjectName("test:test=test");
        XMBean mmbean = new XMBean();
        ResourceIncorrectInfo resource = new ResourceIncorrectInfo();
        mmbean.setManagedResource(resource, "ObjectReference");
        mmbean.setModelMBeanInfo(resource.getMBeanInfo());
        server.registerMBean(mmbean, oname);
        MyInterface mbean = (MyInterface)MBeanProxy.get(MyInterface.class, (ObjectName)oname, (MBeanServer)server);
        ProxyContext ctx = (ProxyContext)mbean;
        ctx.setExceptionHandler((ProxyExceptionHandler)new DefaultExceptionHandler());
        try {
            mbean.setAttributeName2("some name");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    public void testAttributeNotFoundOnDeTypedProxy() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        ObjectName oname = new ObjectName("test:test=test");
        XMBean mmbean = new XMBean();
        ResourceIncorrectInfo resource = new ResourceIncorrectInfo();
        mmbean.setManagedResource(resource, "ObjectReference");
        mmbean.setModelMBeanInfo(resource.getMBeanInfo());
        server.registerMBean(mmbean, oname);
        DynamicMBean mbean = (DynamicMBean)MBeanProxy.get((ObjectName)oname, (MBeanServer)server);
        ProxyContext ctx = (ProxyContext)mbean;
        ctx.setExceptionHandler((ProxyExceptionHandler)new DefaultExceptionHandler());
        try {
            mbean.setAttribute(new Attribute("AttributeName2", "some name"));
        }
        catch (AttributeNotFoundException e) {
            // empty catch block
        }
    }

    public void testInheritanceInTypedProxyArgs() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        ObjectName oname = new ObjectName("test:test=test");
        XMBean mmbean = new XMBean();
        ExtendedResource resource = new ExtendedResource();
        mmbean.setManagedResource((Object)resource, "ObjectReference");
        mmbean.setModelMBeanInfo(resource.getMBeanInfo());
        server.registerMBean(mmbean, oname);
        MyInterface2 mbean = (MyInterface2)MBeanProxy.get(MyInterface2.class, (ObjectName)oname, (MBeanServer)server);
        MBeanProxyTEST.assertTrue((boolean)mbean.doOperation().equals("doOperation"));
        try {
            MBeanProxyTEST.assertTrue((boolean)mbean.executeThis("executeThis").equals("executeThis"));
        }
        catch (ClassCastException e) {
            MBeanProxyTEST.fail((String)"KNOWN ISSUE: proxy generates incorrect JMX invocation signature in case argument subclasses are used.");
        }
    }

    public void testInheritanceInProxyAttribute() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        ObjectName oname = new ObjectName("test:test=test");
        XMBean mmbean = new XMBean();
        ExtendedResource resource = new ExtendedResource();
        mmbean.setManagedResource((Object)resource, "ObjectReference");
        mmbean.setModelMBeanInfo(resource.getMBeanInfo());
        server.registerMBean(mmbean, oname);
        MyInterface2 mbean = (MyInterface2)MBeanProxy.get(MyInterface2.class, (ObjectName)oname, (MBeanServer)server);
        mbean.setAttribute3("Attribute3");
        MBeanProxyTEST.assertTrue((boolean)mbean.getAttribute3().equals("Attribute3"));
    }

    public void testInheritanceInProxyReturnType() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        ObjectName oname = new ObjectName("test:test=test");
        XMBean mmbean = new XMBean();
        ExtendedResource resource = new ExtendedResource();
        mmbean.setManagedResource((Object)resource, "ObjectReference");
        mmbean.setModelMBeanInfo(resource.getMBeanInfo());
        server.registerMBean(mmbean, oname);
        MyInterface2 mbean = (MyInterface2)MBeanProxy.get(MyInterface2.class, (ObjectName)oname, (MBeanServer)server);
        MBeanProxyTEST.assertTrue((boolean)mbean.runMe("runMe").equals("runMe"));
    }
}

