/*
 * Decompiled with CFR 0.152.
 */
package test.implementation.interceptor;

import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import junit.framework.TestCase;
import org.jboss.mx.server.Invocation;
import org.jboss.mx.server.InvocationContext;
import org.jboss.mx.server.ServerConstants;
import org.jboss.mx.service.ServiceConstants;
import test.implementation.interceptor.support.MySharedInterceptor;

public class SharedInterceptorTEST
extends TestCase
implements ServerConstants,
ServiceConstants {
    public SharedInterceptorTEST(String s) {
        super(s);
    }

    public void testSharedInterceptor() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        MySharedInterceptor shared = new MySharedInterceptor();
        ObjectName oname = shared.register(server);
        SharedInterceptorTEST.assertTrue((boolean)server.isRegistered(new ObjectName("JBossMX:type=Interceptor,name=MySharedInterceptor,ID=0")));
        InvocationContext ic = new InvocationContext();
        Invocation i = new Invocation();
        i.addContext(ic);
        i.setType("bloopah");
        server.invoke(oname, "invoke", new Object[]{i}, new String[]{Invocation.class.getName()});
        SharedInterceptorTEST.assertTrue((boolean)i.getType().equals("something"));
    }

    public void testIsShared() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        MySharedInterceptor shared = new MySharedInterceptor();
        SharedInterceptorTEST.assertTrue((!shared.isShared() ? 1 : 0) != 0);
        shared.register(server);
        SharedInterceptorTEST.assertTrue((shared.isShared() ? 1 : 0) != 0);
    }

    public void testLifecycleCallbacks() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        MySharedInterceptor shared = new MySharedInterceptor();
        SharedInterceptorTEST.assertTrue((!shared.isInit ? 1 : 0) != 0);
        SharedInterceptorTEST.assertTrue((!shared.isStart ? 1 : 0) != 0);
        ObjectName oname = shared.register(server);
        SharedInterceptorTEST.assertTrue((shared.isInit ? 1 : 0) != 0);
        SharedInterceptorTEST.assertTrue((shared.isStart ? 1 : 0) != 0);
        SharedInterceptorTEST.assertTrue((!shared.isStop ? 1 : 0) != 0);
        SharedInterceptorTEST.assertTrue((!shared.isDestroy ? 1 : 0) != 0);
        server.unregisterMBean(oname);
        SharedInterceptorTEST.assertTrue((shared.isStop ? 1 : 0) != 0);
        shared.isDestroy = true;
        SharedInterceptorTEST.assertTrue((boolean)true);
    }
}

