/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.management.mejb;

import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.management.Notification;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.jboss.logging.Logger;
import org.jboss.management.mejb.JMSNotificationListenerMBean;

public class JMSNotificationListener
implements JMSNotificationListenerMBean {
    private static final Logger log = Logger.getLogger(JMSNotificationListener.class);
    private transient QueueSender mSender;
    private transient QueueSession mSession;
    private String mJNDIName;
    private Queue mQueue;

    public JMSNotificationListener(String pJNDIName, Queue pQueue) throws JMSException {
        this.mJNDIName = pJNDIName;
        this.mQueue = pQueue;
    }

    public void handleNotification(Notification pNotification, Object pHandback) {
        try {
            if (this.mSender == null) {
                QueueConnection lConnection = this.getQueueConnection(this.mJNDIName);
                this.mSession = lConnection.createQueueSession(false, 1);
                this.mSender = this.mSession.createSender(this.mQueue);
            }
            ObjectMessage lMessage = this.mSession.createObjectMessage((Serializable)pNotification);
            this.mSender.send((Message)lMessage);
        }
        catch (Exception e) {
            log.error((Object)"failed to handle notification", (Throwable)e);
        }
    }

    public boolean equals(Object pTest) {
        if (pTest instanceof JMSNotificationListener) {
            try {
                return this.mQueue.getQueueName().equals(((JMSNotificationListener)pTest).mQueue.getQueueName());
            }
            catch (JMSException e) {
                log.error((Object)"unexpcted failure while tetsing equality", (Throwable)e);
            }
        }
        return false;
    }

    public int hashCode() {
        return this.mQueue.hashCode();
    }

    private QueueConnection getQueueConnection(String pJNDIName) throws NamingException, JMSException {
        InitialContext aJNDIContext = new InitialContext();
        Object aRef = aJNDIContext.lookup(pJNDIName);
        QueueConnectionFactory aFactory = (QueueConnectionFactory)PortableRemoteObject.narrow((Object)aRef, QueueConnectionFactory.class);
        QueueConnection lConnection = aFactory.createQueueConnection();
        lConnection.start();
        return lConnection;
    }
}

