/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.management.j2ee.deployers;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.management.j2ee.Servlet;
import org.jboss.management.j2ee.WebModule;
import org.jboss.management.j2ee.deployers.AbstractVFSJSR77Deployer;
import org.jboss.management.j2ee.factory.FactoryUtils;
import org.jboss.metadata.web.jboss.JBossWebMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebModuleJSR77Deployer
extends AbstractVFSJSR77Deployer<JBossWebMetaData> {
    public WebModuleJSR77Deployer() {
        super(JBossWebMetaData.class);
    }

    @Override
    protected void deployJsr77(MBeanServer server, VFSDeploymentUnit unit, JBossWebMetaData metaData) throws Throwable {
        String warName = unit.getSimpleName();
        ObjectName webModuleService = this.extractRootObjectName(server, (DeploymentUnit)unit, metaData);
        String earName = FactoryUtils.findEarParent((DeploymentUnit)unit);
        ObjectName jsr77Name = WebModule.create(server, earName, warName, unit.getRoot().toURL(), webModuleService);
        if (jsr77Name != null) {
            WebModuleJSR77Deployer.putObjectName((DeploymentUnit)unit, WebModule.class.getName(), jsr77Name);
            Iterable<ObjectName> servlets = this.extractComponentObjectNames(server, (DeploymentUnit)unit, metaData);
            for (ObjectName servletName : servlets) {
                try {
                    this.createServlet(server, unit, jsr77Name, servletName);
                }
                catch (Throwable e) {
                    this.log.debug((Object)("Failed to create JSR-77 servlet: " + servletName), e);
                }
            }
        }
    }

    @Override
    protected void undeployJsr77(MBeanServer server, VFSDeploymentUnit unit, JBossWebMetaData metaData) {
        ObjectName jsr77Name = WebModuleJSR77Deployer.removeObjectName((DeploymentUnit)unit, WebModule.class.getName());
        if (jsr77Name != null) {
            this.log.debug((Object)("Destroy module: " + jsr77Name));
            Iterable<ObjectName> servlets = this.extractComponentObjectNames(server, (DeploymentUnit)unit, metaData);
            for (ObjectName servletName : servlets) {
                try {
                    this.destroyServlet(server, unit, servletName);
                }
                catch (Throwable e) {
                    this.log.debug((Object)("Failed to destroy JSR-77 servlet: " + servletName), e);
                }
            }
            WebModule.destroy(server, jsr77Name);
        }
    }

    public ObjectName createServlet(MBeanServer mbeanServer, VFSDeploymentUnit unit, ObjectName webModuleName, ObjectName servletServiceName) {
        ObjectName jsr77Name = null;
        ObjectName webContainerName = null;
        try {
            this.log.debug((Object)("Creating servlet: " + servletServiceName));
            String servletName = servletServiceName.getKeyProperty("name");
            if (servletName != null) {
                jsr77Name = Servlet.create(mbeanServer, webModuleName, webContainerName, servletServiceName);
                WebModuleJSR77Deployer.putObjectName((DeploymentUnit)unit, servletServiceName.getCanonicalName(), jsr77Name);
                this.log.debug((Object)("Created servlet: " + servletServiceName + ", module: " + jsr77Name));
            }
        }
        catch (Exception e) {
            this.log.debug((Object)("Failed to create servlet: " + servletServiceName), (Throwable)e);
        }
        return jsr77Name;
    }

    public void destroyServlet(MBeanServer server, VFSDeploymentUnit unit, ObjectName servletServiceName) {
        ObjectName jsr77Name = WebModuleJSR77Deployer.removeObjectName((DeploymentUnit)unit, servletServiceName.getCanonicalName());
        this.log.debug((Object)("Destroy container: " + servletServiceName + ", module: " + jsr77Name));
        if (jsr77Name != null) {
            Servlet.destroy(server, jsr77Name);
        }
    }
}

