/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.management.j2ee.deployers;

import java.util.Collections;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.beans.metadata.api.annotations.Inject;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractSimpleRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJSR77Deployer<T>
extends AbstractSimpleRealDeployer<T> {
    private boolean requiresVFSDeployment;
    private MBeanServer server;

    protected AbstractJSR77Deployer(Class<T> input) {
        super(input);
        this.setOutput(ObjectName.class);
    }

    @Inject(bean="JMXKernel", property="mbeanServer")
    public void setServer(MBeanServer server) {
        this.server = server;
    }

    public void setRequiresVFSDeployment(boolean requiresVFSDeployment) {
        this.requiresVFSDeployment = requiresVFSDeployment;
    }

    protected abstract void deployJsr77(MBeanServer var1, DeploymentUnit var2, T var3) throws Throwable;

    protected abstract void undeployJsr77(MBeanServer var1, DeploymentUnit var2, T var3);

    protected static void putObjectName(DeploymentUnit unit, String attachmentName, ObjectName name) {
        if (name != null) {
            unit.addAttachment(attachmentName + "." + ObjectName.class.getSimpleName(), (Object)name, ObjectName.class);
        }
    }

    protected static ObjectName getObjectName(DeploymentUnit unit, String attachmentName) {
        return (ObjectName)unit.getAttachment(attachmentName + "." + ObjectName.class.getSimpleName(), ObjectName.class);
    }

    protected static ObjectName removeObjectName(DeploymentUnit unit, String attachmentName) {
        return (ObjectName)unit.removeAttachment(attachmentName + "." + ObjectName.class.getSimpleName(), ObjectName.class);
    }

    protected ObjectName extractRootObjectName(MBeanServer server, DeploymentUnit unit, T metaData) {
        try {
            return new ObjectName("jboss.service:type=" + metaData.getClass().getSimpleName() + ",unit=" + unit.getSimpleName());
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Cannot extract root ObjectName.", t);
        }
    }

    protected Iterable<ObjectName> extractComponentObjectNames(MBeanServer server, DeploymentUnit unit, T metaData) {
        return Collections.emptySet();
    }

    public void deploy(DeploymentUnit unit, T metaData) throws DeploymentException {
        if (this.server != null && unit instanceof VFSDeploymentUnit == this.requiresVFSDeployment) {
            try {
                this.deployJsr77(this.server, unit, metaData);
            }
            catch (Throwable t) {
                throw DeploymentException.rethrowAsDeploymentException((String)"Cannot deploy jsr77.", (Throwable)t);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"Missing mbean server or deployment unit type mismatch.");
        }
    }

    public void undeploy(DeploymentUnit unit, T metaData) {
        if (this.server != null && unit instanceof VFSDeploymentUnit == this.requiresVFSDeployment) {
            this.undeployJsr77(this.server, unit, metaData);
        } else if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"Missing mbean server or deployment unit type mismatch.");
        }
    }
}

