/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.mx.mxbean.test;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import junit.framework.AssertionFailedError;
import org.jboss.logging.Logger;
import org.jboss.mx.mxbean.CompositeDataInvocationHandler;
import org.jboss.mx.mxbean.MXBeanUtils;
import org.jboss.test.BaseTestCase;
import org.jboss.test.mx.mxbean.support.InvalidInterface;
import org.jboss.test.mx.mxbean.support.SimpleInterface;
import org.jboss.util.UnexpectedThrowable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMXBeanTest
extends BaseTestCase {
    private static Logger staticLog = Logger.getLogger(AbstractMXBeanTest.class);

    public AbstractMXBeanTest(String name) {
        super(name);
    }

    public static void checkThrowableDeep(Class<? extends Throwable> wrapperExpected, Class<? extends Throwable> deepExpected, Throwable throwable) throws Exception {
        AbstractMXBeanTest.assertNotNull(deepExpected);
        AbstractMXBeanTest.assertNotNull((Object)throwable);
        Throwable original = throwable;
        if (wrapperExpected != null) {
            if (!wrapperExpected.isInstance(original)) {
                if (original instanceof Exception) {
                    throw (Exception)original;
                }
                if (original instanceof Error) {
                    throw (Error)original;
                }
                throw new UnexpectedThrowable("UnexpectedThrowable", original);
            }
            staticLog.debug((Object)("Got expected " + wrapperExpected.getName() + "(" + original + ")"));
        }
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        if (!deepExpected.isInstance(throwable)) {
            if (original instanceof Exception) {
                throw (Exception)original;
            }
            if (original instanceof Error) {
                throw (Error)original;
            }
            throw new UnexpectedThrowable("UnexpectedThrowable", original);
        }
        staticLog.debug((Object)("Got expected " + deepExpected.getName() + "(" + throwable + ")"));
    }

    public static void checkThrowableDeep(Class<? extends Throwable> expected, Throwable throwable) throws Exception {
        AbstractMXBeanTest.checkThrowableDeep(null, expected, throwable);
    }

    public static <T> T assertInstanceOf(Class<T> expected, Object object) throws Exception {
        if (object == null) {
            return null;
        }
        AbstractMXBeanTest.assertTrue((String)(object.getClass().getName() + " is not an instance of " + expected.getName()), (boolean)expected.isInstance(object));
        return expected.cast(object);
    }

    public static void checkArrayEquals(Object expected, Object actual) {
        Object[] a1 = (Object[])expected;
        Object[] a2 = (Object[])actual;
        if (!Arrays.deepEquals(a1, a2)) {
            throw new AssertionFailedError("Expected: " + a1 + "=" + Arrays.deepToString(a1) + " got " + a2 + "=" + Arrays.deepToString(a2));
        }
    }

    public static void checkCompositeDataHandlerEquals(Object expected, Object actual) {
        if (expected == null) {
            AbstractMXBeanTest.assertEquals((Object)expected, (Object)actual);
            return;
        }
        CompositeDataInvocationHandler handler = (CompositeDataInvocationHandler)Proxy.getInvocationHandler(actual);
        CompositeData data = handler.getCompositeData();
        CompositeType type = data.getCompositeType();
        Set<String> names = type.keySet();
        Class<?> clazz = expected.getClass();
        for (String name : names) {
            OpenType<?> itemType = type.getType(name);
            try {
                Method method = MXBeanUtils.getCompositeDataMethod(clazz, (String)name, (itemType == SimpleType.BOOLEAN ? 1 : 0) != 0);
                Object expectedValue = method.invoke(expected, null);
                Object actualValue = handler.invoke(actual, method, null);
                AbstractMXBeanTest.assertEquals((Object)expectedValue, (Object)actualValue);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
    }

    public static void checkValueEquals(Object expected, Object actual) {
        if (actual == null) {
            AbstractMXBeanTest.assertEquals((Object)expected, (Object)actual);
        } else if (actual instanceof Proxy) {
            AbstractMXBeanTest.checkCompositeDataHandlerEquals(expected, actual);
        } else if (actual.getClass().isArray()) {
            AbstractMXBeanTest.checkArrayEquals(expected, actual);
        } else {
            AbstractMXBeanTest.assertEquals((Object)expected, (Object)actual);
        }
    }

    protected CompositeData createCompositeData(String name, String[] keys, Object[] values) throws Exception {
        this.assertNotNullArray("values", values);
        Class[] types = new Class[values.length];
        for (int i = 0; i < values.length; ++i) {
            types[i] = values[i].getClass();
        }
        return this.createCompositeData(name, keys, types, values);
    }

    protected CompositeData createCompositeData(String name, String[] keys, Class[] types, Object[] values) throws Exception {
        CompositeType compositeType = this.createCompositeType(name, keys, types);
        return new CompositeDataSupport(compositeType, keys, values);
    }

    protected CompositeData createCompositeData(String name, String[] keys, OpenType[] openTypes, Object[] values) throws Exception {
        CompositeType compositeType = this.createCompositeType(name, keys, openTypes);
        return new CompositeDataSupport(compositeType, keys, values);
    }

    protected CompositeType createCompositeType(String name, String[] keys, Class[] types) throws Exception {
        AbstractMXBeanTest.assertNotNull((Object)name);
        this.assertNotNullArray("keys", keys);
        this.assertNotNullArray("types", types);
        AbstractMXBeanTest.assertEquals((int)keys.length, (int)types.length);
        OpenType[] openTypes = new OpenType[types.length];
        for (int i = 0; i < types.length; ++i) {
            openTypes[i] = MXBeanUtils.getOpenType((Type)types[i]);
        }
        return new CompositeType(name, name, keys, keys, openTypes);
    }

    protected CompositeType createCompositeType(String name, String[] keys, OpenType[] openTypes) throws Exception {
        AbstractMXBeanTest.assertNotNull((Object)name);
        this.assertNotNullArray("keys", keys);
        this.assertNotNullArray("types", openTypes);
        AbstractMXBeanTest.assertEquals((int)keys.length, (int)openTypes.length);
        return new CompositeType(name, name, keys, keys, openTypes);
    }

    protected <T> T createCompositeDataProxy(Class<T> intf, String[] keys, Object[] values) throws Exception {
        AbstractMXBeanTest.assertNotNull(intf);
        return this.createCompositeDataProxy(intf, intf.getName(), keys, values);
    }

    protected <T> T createCompositeDataProxy(Class<T> intf, String name, String[] keys, Object[] values) throws Exception {
        CompositeData compositeData = this.createCompositeData(name, keys, values);
        return this.createCompositeDataProxy(intf, compositeData);
    }

    protected <T> T createCompositeDataProxy(Class<T> intf, String[] keys, Class[] types, Object[] values) throws Exception {
        AbstractMXBeanTest.assertNotNull(intf);
        return this.createCompositeDataProxy(intf, intf.getName(), keys, types, values);
    }

    protected <T> T createCompositeDataProxy(Class<T> intf, String name, String[] keys, Class[] types, Object[] values) throws Exception {
        CompositeData compositeData = this.createCompositeData(name, keys, types, values);
        return this.createCompositeDataProxy(intf, compositeData);
    }

    protected <T> T createCompositeDataProxy(Class<T> intf, String name, String[] keys, OpenType[] openTypes, Object[] values) throws Exception {
        CompositeData compositeData = this.createCompositeData(name, keys, openTypes, values);
        return this.createCompositeDataProxy(intf, compositeData);
    }

    protected <T> T createCompositeDataProxy(Class<T> intf, CompositeData compositeData) {
        return (T)MXBeanUtils.createCompositeDataProxy(intf, (CompositeData)compositeData);
    }

    protected CompositeData createTestCompositeData() throws Exception {
        return this.createCompositeData("Test", SimpleInterface.KEYS, SimpleInterface.VALUES);
    }

    protected SimpleInterface createTestCompositeDataProxy() throws Exception {
        return this.createCompositeDataProxy(SimpleInterface.class, SimpleInterface.KEYS, SimpleInterface.VALUES);
    }

    protected SimpleInterface createNullCompositeDataProxy() throws Exception {
        return this.createCompositeDataProxy(SimpleInterface.class, SimpleInterface.KEYS, SimpleInterface.TYPES, SimpleInterface.NULL_VALUES);
    }

    protected InvalidInterface createInvalidCompositeDataProxy() throws Exception {
        return this.createCompositeDataProxy(InvalidInterface.class, SimpleInterface.KEYS, SimpleInterface.VALUES);
    }

    protected SimpleInterface createTestCompositeDataProxy(String name) throws Exception {
        return this.createCompositeDataProxy(SimpleInterface.class, name, SimpleInterface.KEYS, SimpleInterface.VALUES);
    }

    protected MBeanServer createMBeanServer() {
        return MBeanServerFactory.newMBeanServer();
    }

    protected void assertNotNullArray(String context, Object[] array) throws Exception {
        AbstractMXBeanTest.assertNotNull((String)(context + " is null "), (Object)array);
        for (int i = 0; i < array.length; ++i) {
            AbstractMXBeanTest.assertNotNull((String)(context + "[" + i + "] is null"), (Object)array[i]);
        }
    }

    public static Date createDate(int year, int month, int day) {
        Calendar calender = Calendar.getInstance();
        calender.clear();
        calender.set(year, month - 1, day, 0, 0, 0);
        return calender.getTime();
    }

    public static String getUpperName(String name) {
        return Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }
}

