/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.mx.mxbean.test;

import java.lang.reflect.Type;
import javax.management.openmbean.OpenType;
import junit.framework.AssertionFailedError;
import org.jboss.mx.mxbean.MXBeanUtils;
import org.jboss.test.mx.mxbean.test.AbstractMXBeanTest;

public abstract class CompositeDataTest
extends AbstractMXBeanTest {
    public CompositeDataTest(String name) {
        super(name);
    }

    protected void constructReconstructTest(Object initialValue) throws Exception {
        this.constructReconstructTest(initialValue, initialValue);
    }

    protected void constructReconstructTest(Object initialValue, Type type) throws Exception {
        this.constructReconstructTest(initialValue, type, initialValue);
    }

    protected void constructReconstructTest(Object initialValue, Type type, Object expectedOpenData) throws Exception {
        this.constructReconstructTest(initialValue, type, expectedOpenData, initialValue);
    }

    protected void assertNullFailure(Type type) throws Exception {
        try {
            this.constructReconstructTest(null, type);
            CompositeDataTest.fail((String)"Should not be here");
        }
        catch (AssertionFailedError e) {
            throw e;
        }
        catch (Throwable t) {
            CompositeDataTest.checkThrowable(IllegalArgumentException.class, (Throwable)t);
        }
    }

    protected void constructReconstructTest(Object initialValue, Object expectedOpenData) throws Exception {
        this.constructReconstructTest(initialValue, expectedOpenData, initialValue);
    }

    protected void constructReconstructTest(Object initialValue, Object expectedOpenData, Object expected) throws Exception {
        Class<?> type = initialValue.getClass();
        this.constructReconstructTest(initialValue, type, expectedOpenData, expected);
    }

    protected void constructReconstructTest(Object initialValue, Type type, Object expectedOpenData, Object expected) throws Exception {
        OpenType openType = MXBeanUtils.getOpenType((Type)type);
        this.constructReconstructTest(initialValue, type, openType, expectedOpenData, expected);
    }

    protected void constructReconstructTest(Object initialValue, Type type, OpenType openType, Object expectedOpenData, Object expected) throws Exception {
        Object openData = this.construct(openType, type, initialValue);
        this.checkOpenDataEquals(expectedOpenData, openData);
        if (initialValue != null) {
            CompositeDataTest.assertTrue((String)(openData + " is not " + openType), (boolean)openType.isValue(openData));
        }
        Object finalValue = this.reconstruct(openType, type, openData);
        this.checkFinalEquals(expected, finalValue);
    }

    protected void checkOpenDataEquals(Object expected, Object actual) {
        this.checkEquals(expected, actual);
    }

    protected void checkFinalEquals(Object expected, Object actual) {
        this.checkEquals(expected, actual);
    }

    protected void checkEquals(Object expected, Object actual) {
        CompositeDataTest.assertEquals((Object)expected, (Object)actual);
    }

    protected Object construct(OpenType openType, Type type, Object value) throws Exception {
        return MXBeanUtils.construct((OpenType)openType, (Object)value, (Object)(((Object)((Object)this)).getClass().getName() + "#" + this.getName()));
    }

    protected Object reconstruct(OpenType openType, Type type, Object openData) throws Exception {
        return MXBeanUtils.reconstruct((OpenType)openType, (Type)type, (Object)openData, (Object)(((Object)((Object)this)).getClass().getName() + "#" + this.getName()));
    }
}

