/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.profileservice.management.templates;

import java.util.HashSet;
import java.util.Map;

import org.jboss.managed.api.Fields;
import org.jboss.managed.plugins.DefaultFieldsImpl;
import org.jboss.managed.plugins.ManagedObjectImpl;
import org.jboss.managed.plugins.ManagedPropertyImpl;
import org.jboss.metatype.api.types.CompositeMetaType;
import org.jboss.metatype.api.types.ImmutableCompositeMetaType;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.SimpleValueSupport;
import org.jboss.profileservice.management.plugins.BasicDeploymentTemplateInfo;
import org.jboss.system.metadata.ServiceDeployment;

/**
 * The properties used by the DsXmlDataSourceTemplate.
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision$
 */
public class DsXmlDataSourceTemplateInfo extends BasicDeploymentTemplateInfo
{
   private static final long serialVersionUID = 1;
   private Map<String, String> propertyNameMappings;
   private String attachmentName;
   private String dsTypeAttachmentName;

   public DsXmlDataSourceTemplateInfo(String name, String description, String attachmentName)
   {
      this(name, description, attachmentName, attachmentName);
   }
   public DsXmlDataSourceTemplateInfo(String name, String description,
         String attachmentName, String dsTypeAttachmentName)
   {
      super(name, description);
      this.attachmentName = attachmentName;
      this.dsTypeAttachmentName = dsTypeAttachmentName;
   }

   public Map<String, String> getPropertyNameMappings()
   {
      return propertyNameMappings;
   }
   public void setPropertyNameMappings(Map<String, String> propertyNameMappings)
   {
      this.propertyNameMappings = propertyNameMappings;
   }

   public void start()
   {
      ManagedObjectImpl mo = new ManagedObjectImpl(attachmentName);
      // The jndi name field info
      DefaultFieldsImpl f0 = new DefaultFieldsImpl();
      setFieldName("jndi-name", f0);
      f0.setDescription("The jndi name to bind the DataSource under");
      f0.setMandatory(true);
      f0.setMetaType(SimpleMetaType.STRING);
      ManagedPropertyImpl jndiName = new ManagedPropertyImpl(mo, f0);
      super.addProperty(jndiName);
      // The connection-url field info
      DefaultFieldsImpl f1 = new DefaultFieldsImpl();
      setFieldName("connection-url", f1);
      f1.setDescription("The jdbc url of the DataSource");
      f1.setMandatory(true);
      f1.setMetaType(SimpleMetaType.STRING);
      ManagedPropertyImpl conURL = new ManagedPropertyImpl(mo, f1);
      super.addProperty(conURL);
      // The user field info
      DefaultFieldsImpl f2 = new DefaultFieldsImpl();
      setFieldName("user-name", f2);
      f2.setDescription("The username for the connection-url");
      f2.setMandatory(false);
      f2.setMetaType(SimpleMetaType.STRING);
      ManagedPropertyImpl user = new ManagedPropertyImpl(mo, f2);
      super.addProperty(user);
      // The password field info
      DefaultFieldsImpl f3 = new DefaultFieldsImpl();
      setFieldName("password", f3);
      f3.setDescription("The password for the connection-url");
      f3.setMandatory(false);
      f3.setMetaType(SimpleMetaType.STRING);
      ManagedPropertyImpl password = new ManagedPropertyImpl(mo, f3);
      super.addProperty(password);
      // The security-domain field info   
      DefaultFieldsImpl f4 = new DefaultFieldsImpl();
      setFieldName("security-domain", f4);
      f4.setDescription("The security-domain used to validate connections");
      f4.setMandatory(false);
      f4.setMetaType(SimpleMetaType.STRING);
      ManagedPropertyImpl secDomain = new ManagedPropertyImpl(mo, f4);
      super.addProperty(secDomain);
      // The driver-class field info
      DefaultFieldsImpl f5 = new DefaultFieldsImpl();
      setFieldName("driver-class", f5);
      f5.setDescription("The jdbc driver class name");
      f5.setMandatory(true);
      f5.setMetaType(SimpleMetaType.STRING);
      ManagedPropertyImpl driverClass = new ManagedPropertyImpl(mo, f5);
      super.addProperty(driverClass);
      // The driver connection properties field info
      DefaultFieldsImpl f6 = new DefaultFieldsImpl();
      setFieldName("connection-properties", f6);
      f6.setDescription("The jdbc driver connection properties");
      f6.setMandatory(false);
      String[] itemNames = {"conn-prop1", "conn-prop2"};
      String[] itemDescriptions = {"conn-prop1 description", "conn-prop2 description"};
      MetaType[] itemTypes = {SimpleMetaType.STRING, SimpleMetaType.STRING};
      CompositeMetaType propsType = new ImmutableCompositeMetaType("java.lang.Properties", "DS connection properties",
            itemNames, itemDescriptions, itemTypes);
      f6.setMetaType(propsType);
      ManagedPropertyImpl connProps = new ManagedPropertyImpl(mo, f6);
      super.addProperty(connProps);

      // The type of the datasource
      ManagedObjectImpl mo2 = new ManagedObjectImpl(dsTypeAttachmentName);
      DefaultFieldsImpl f21 = new DefaultFieldsImpl();
      setFieldName("datasource-type", f21);
      f21.setDescription("The type of the DataSource");
      f21.setMandatory(true);
      f21.setValue("local-tx-datasource");
      HashSet<MetaValue> values = new HashSet<MetaValue>();
      values.add(SimpleValueSupport.wrap("local-tx-datasource"));
      values.add(SimpleValueSupport.wrap("no-tx-datasource"));
      values.add(SimpleValueSupport.wrap("xa-datasource"));
      f21.setLegalValues(values);
      f21.setMetaType(SimpleMetaType.STRING);
      ManagedPropertyImpl dsType = new ManagedPropertyImpl(mo2, f21);
      super.addProperty(dsType);
   }

   protected void setFieldName(String name, Fields f)
   {
      f.setField(Fields.NAME, name);
      if( propertyNameMappings != null )
      {
         String mappedName = propertyNameMappings.get(name);
         if( mappedName != null )
            f.setField(Fields.MAPPED_NAME, mappedName);
      }
   }
}
