/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.management.builders;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jboss.managed.api.Fields;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.plugins.ManagedObjectImpl;
import org.jboss.managed.plugins.ManagedPropertyImpl;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.values.SimpleValue;
import org.jboss.metatype.api.values.SimpleValueSupport;
import org.jboss.profileservice.management.builders.DomFields;
import org.jboss.util.xml.DOMWriter;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DomDataSourceManagedObject
extends ManagedObjectImpl {
    private static final long serialVersionUID = 1L;
    private static String[] dsTypes = new String[]{"local-tx-datasource", "no-tx-datasource", "xa-datasource"};
    private Document document;

    public DomDataSourceManagedObject(String attachmentName, Document document) {
        super(attachmentName);
        Object dsType;
        Element element;
        this.document = document;
        if (document == null) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                DOMImplementation impl = builder.getDOMImplementation();
                document = impl.createDocument(null, null, null);
                element = document.createElement("datasources");
                document.appendChild(element);
                Element child = document.createElement("local-tx-datasource");
                element.appendChild(child);
                element = child;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException("Error creating dom", e);
            }
        } else {
            String type;
            NodeList dses = document.getElementsByTagName("datasources");
            if (dses.getLength() == 0) {
                element = document.createElement("datasources");
                document.appendChild(element);
            } else {
                element = (Element)dses.item(0);
            }
            dsType = null;
            String[] arr$ = dsTypes;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (dsType = element.getElementsByTagName(type = arr$[i$])).getLength() <= 0; ++i$) {
            }
            if (dsType == null || dsType.getLength() == 0) {
                Element child = document.createElement("local-tx-datasource");
                element.appendChild(child);
                element = child;
            } else {
                element = (Element)dsType.item(0);
            }
        }
        Collection properties = this.getProperties().values();
        dsType = new DomFields(element, "datasource-type");
        ((DomFields)((Object)dsType)).setField("description", (Serializable)((Object)"The type of DataSource"));
        ((DomFields)((Object)dsType)).setField("mandatory", Boolean.TRUE);
        ((DomFields)((Object)dsType)).setField("metaType", (Serializable)SimpleMetaType.STRING);
        HashSet<SimpleValue> values = new HashSet<SimpleValue>();
        values.add(SimpleValueSupport.wrap((Serializable)((Object)"local-tx-datasource")));
        values.add(SimpleValueSupport.wrap((Serializable)((Object)"no-tx-datasource")));
        values.add(SimpleValueSupport.wrap((Serializable)((Object)"xa-datasource")));
        dsType.setLegalValues(values);
        DomFields jndiName = new DomFields(element, "jndi-name");
        jndiName.setField("description", (Serializable)((Object)"The jndi name to bind the DataSource under"));
        jndiName.setField("mandatory", Boolean.TRUE);
        jndiName.setField("metaType", (Serializable)SimpleMetaType.STRING);
        DomFields driverClass = new DomFields(element, "driver-class");
        driverClass.setField("description", (Serializable)((Object)"The jdbc driver class DataSource"));
        driverClass.setField("mandatory", Boolean.TRUE);
        driverClass.setField("metaType", (Serializable)SimpleMetaType.STRING);
        DomFields connURL = new DomFields(element, "connection-url");
        connURL.setField("description", (Serializable)((Object)"The jdbc url of the DataSource"));
        connURL.setField("mandatory", Boolean.TRUE);
        connURL.setField("metaType", (Serializable)SimpleMetaType.STRING);
        DomFields user = new DomFields(element, "user-name");
        user.setField("description", (Serializable)((Object)"The username for the connection-url"));
        user.setField("mandatory", Boolean.FALSE);
        user.setField("metaType", (Serializable)SimpleMetaType.STRING);
        DomFields password = new DomFields(element, "password", false);
        password.setField("description", (Serializable)((Object)"The password for the connection-url"));
        password.setField("mandatory", Boolean.FALSE);
        password.setField("metaType", (Serializable)SimpleMetaType.STRING);
        DomFields minPoolSize = new DomFields(element, "min-pool-size");
        password.setField("description", (Serializable)((Object)"The min pool size"));
        password.setField("mandatory", Boolean.FALSE);
        password.setField("metaType", (Serializable)SimpleMetaType.INTEGER);
        DomFields maxPoolSize = new DomFields(element, "max-pool-size");
        password.setField("description", (Serializable)((Object)"The max pool size"));
        password.setField("mandatory", Boolean.FALSE);
        password.setField("metaType", (Serializable)SimpleMetaType.INTEGER);
        DomFields secDomain = new DomFields(element, "security-domain");
        secDomain.setField("description", (Serializable)((Object)"The security-domain used to validate connections"));
        secDomain.setField("mandatory", Boolean.FALSE);
        secDomain.setField("metaType", (Serializable)SimpleMetaType.STRING);
        DomFields psCacheSize = new DomFields(element, "prepared-statement-cache-size");
        secDomain.setField("description", (Serializable)((Object)"The prepared statement cache size"));
        secDomain.setField("mandatory", Boolean.FALSE);
        secDomain.setField("metaType", (Serializable)SimpleMetaType.INTEGER);
        properties.add(new ManagedPropertyImpl((ManagedObject)this, (Fields)dsType));
        properties.add(new ManagedPropertyImpl((ManagedObject)this, (Fields)jndiName));
        properties.add(new ManagedPropertyImpl((ManagedObject)this, (Fields)driverClass));
        properties.add(new ManagedPropertyImpl((ManagedObject)this, (Fields)connURL));
        properties.add(new ManagedPropertyImpl((ManagedObject)this, (Fields)user));
        properties.add(new ManagedPropertyImpl((ManagedObject)this, (Fields)password));
        properties.add(new ManagedPropertyImpl((ManagedObject)this, (Fields)minPoolSize));
        properties.add(new ManagedPropertyImpl((ManagedObject)this, (Fields)maxPoolSize));
        properties.add(new ManagedPropertyImpl((ManagedObject)this, (Fields)secDomain));
        properties.add(new ManagedPropertyImpl((ManagedObject)this, (Fields)psCacheSize));
    }

    public String prettyPrint() {
        StringBuffer tmp = new StringBuffer(super.toString());
        tmp.append('[');
        tmp.append(DOMWriter.printNode((Node)this.document, (boolean)true));
        tmp.append(']');
        return tmp.toString();
    }

    public String toString() {
        return this.prettyPrint();
    }
}

