/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.management.templates;

import java.io.File;
import java.io.FileWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import org.jboss.deployers.spi.management.DeploymentTemplate;
import org.jboss.deployers.spi.management.DeploymentTemplateInfo;
import org.jboss.deployers.vfs.spi.client.VFSDeployment;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.profileservice.mock.ds.DataSourceDeployment;
import org.jboss.profileservice.mock.ds.FakeDataSourceDeployer;
import org.jboss.system.metadata.ServiceDeployment;
import org.jboss.system.metadata.ServiceMetaData;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FakeDsXmlDataSourceTemplate
implements DeploymentTemplate {
    private DeploymentTemplateInfo info;
    private FakeDataSourceDeployer deployer;
    private Map<String, String> propertyNameMappings;

    public Map<String, String> getPropertyNameMappings() {
        return this.propertyNameMappings;
    }

    public void setPropertyNameMappings(Map<String, String> propertyNameMappings) {
        this.propertyNameMappings = propertyNameMappings;
    }

    public FakeDataSourceDeployer getDeployer() {
        return this.deployer;
    }

    public void setDeployer(FakeDataSourceDeployer deployer) {
        this.deployer = deployer;
    }

    public VirtualFile applyTemplate(VirtualFile root, String deploymentBaseName, DeploymentTemplateInfo values) throws Exception {
        String dsName = deploymentBaseName + "-dsf.xml";
        URI dsXmlURI = new URI(root.toURI() + dsName);
        File dsXml = new File(dsXmlURI.getPath());
        this.writeTemplate(dsXml, values);
        return root.findChild(dsName);
    }

    public void updateTemplateDeployment(VFSDeployment ctx, DeploymentTemplateInfo values) throws Exception {
        ServiceDeployment service = new ServiceDeployment();
        ArrayList<ServiceMetaData> services = new ArrayList<ServiceMetaData>();
        DataSourceDeployment ds = new DataSourceDeployment();
        ds.parse(values.getProperties());
        ServiceMetaData dsMetaData = this.deployer.createDsServiceMetaData(ds);
        services.add(dsMetaData);
        service.setServices(services);
    }

    public DeploymentTemplateInfo getInfo() {
        return this.info;
    }

    public void setInfo(DeploymentTemplateInfo info) {
        this.info = info;
    }

    protected void writeTemplate(File dsXml, DeploymentTemplateInfo values) throws Exception {
        FileWriter fw = new FileWriter(dsXml);
        Map properties = values.getProperties();
        ManagedProperty type = (ManagedProperty)properties.get("datasource-type");
        String typeTag = "local-tx-datasource";
        if (type != null && type.getValue() != null) {
            typeTag = type.getValue().toString();
        }
        fw.write("<datasources>\n");
        fw.write("<" + typeTag + ">\n");
        fw.write("<jndi-name>default</jndi-name>\n");
        fw.write("<connection-url>jdbc:...</connection-url>\n");
        fw.write("<driver-class>default</driver-class>\n");
        fw.write("<user-name>default</user-name>\n");
        fw.write("<password>default</password>\n");
        fw.write("<min-pool-size>1</min-pool-size>\n");
        fw.write("<max-pool-size>10</max-pool-size>\n");
        fw.write("<security-domain>default</security-domain>\n");
        fw.write("</" + typeTag + ">\n");
        fw.write("</datasources>\n");
        fw.flush();
        fw.close();
    }
}

