/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.mock.ds;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.management.ObjectName;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.managed.ManagedObjectCreator;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.deployer.JAXPDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.managed.api.ComponentType;
import org.jboss.managed.api.Fields;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.plugins.DefaultFieldsImpl;
import org.jboss.managed.plugins.ManagedObjectImpl;
import org.jboss.managed.plugins.ManagedPropertyImpl;
import org.jboss.managed.plugins.advice.WrapperAdvice;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.values.SimpleValue;
import org.jboss.metatype.api.values.SimpleValueSupport;
import org.jboss.profileservice.management.builders.ServiceManagedObject;
import org.jboss.profileservice.mock.ds.DataSourceDeployment;
import org.jboss.profileservice.mock.ds.FakeDataSourceConn;
import org.jboss.system.metadata.ServiceAttributeMetaData;
import org.jboss.system.metadata.ServiceConstructorMetaData;
import org.jboss.system.metadata.ServiceDependencyMetaData;
import org.jboss.system.metadata.ServiceDeployment;
import org.jboss.system.metadata.ServiceMetaData;
import org.jboss.system.metadata.ServiceTextValueMetaData;
import org.jboss.system.metadata.ServiceValueMetaData;
import org.jboss.virtual.VirtualFile;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FakeDataSourceDeployer
extends JAXPDeployer<ServiceDeployment>
implements ManagedObjectCreator {
    private Map<String, String> propertyNameMappings = new HashMap<String, String>();

    public FakeDataSourceDeployer() {
        super(ServiceDeployment.class);
        this.setSuffix("-dsf.xml");
    }

    public Map<String, String> getPropertyNameMappings() {
        return this.propertyNameMappings;
    }

    public void setPropertyNameMappings(Map<String, String> mangedToMBeanNames) {
        for (String key : mangedToMBeanNames.keySet()) {
            String value = mangedToMBeanNames.get(key);
            this.propertyNameMappings.put(value, key);
        }
    }

    public void build(DeploymentUnit unit, Map<String, ManagedObject> map) throws DeploymentException {
        String name = unit.getSimpleName();
        if (name.endsWith("-dsf.xml")) {
            Map attachments = unit.getTransientManagedObjects().getAttachments();
            this.log.info((Object)(name + " attachments: " + attachments));
            ServiceDeployment service = (ServiceDeployment)unit.getAttachment(ServiceDeployment.class);
            if (service == null) {
                throw new DeploymentException("Failed to find ServiceDeployment in " + unit.getName());
            }
            List services = service.getServices();
            if (services.size() != 1) {
                throw new DeploymentException("Expected only 1 ServiceMetaData but saw " + services.size() + " in " + unit.getName());
            }
            ServiceMetaData dsMetaData = (ServiceMetaData)services.get(0);
            String attachName = ServiceMetaData.class.getName();
            ServiceManagedObject mo = new ServiceManagedObject(attachName, dsMetaData, this.propertyNameMappings);
            ManagedObject wrapMO = WrapperAdvice.wrapManagedObject((ManagedObject)mo);
            map.put(attachName, wrapMO);
            attachName = "FakeConnectionFactoryDeployer.datasource-type";
            ManagedObjectImpl typeMO = new ManagedObjectImpl(attachName);
            DefaultFieldsImpl f21 = new DefaultFieldsImpl();
            f21.setName("datasource-type");
            f21.setDescription("The type of the DataSource");
            f21.setMandatory(true);
            f21.setValue((Serializable)((Object)"local-tx-datasource"));
            HashSet<SimpleValue> values = new HashSet<SimpleValue>();
            values.add(SimpleValueSupport.wrap((Serializable)((Object)"local-tx-datasource")));
            values.add(SimpleValueSupport.wrap((Serializable)((Object)"no-tx-datasource")));
            values.add(SimpleValueSupport.wrap((Serializable)((Object)"xa-datasource")));
            f21.setLegalValues(values);
            f21.setMetaType((MetaType)SimpleMetaType.STRING);
            ManagedPropertyImpl dsType = new ManagedPropertyImpl((ManagedObject)typeMO, (Fields)f21);
            typeMO.getProperties().put("datasource-type", dsType);
            wrapMO = WrapperAdvice.wrapManagedObject((ManagedObject)typeMO);
            map.put(attachName, wrapMO);
        }
    }

    protected ServiceDeployment parse(VFSDeploymentUnit unit, VirtualFile file, Document document) throws Exception {
        ServiceDeployment deployment = new ServiceDeployment();
        DataSourceDeployment ds = new DataSourceDeployment();
        ds.parse(document);
        ServiceMetaData dsMbean = this.createDsServiceMetaData(ds);
        ArrayList<ServiceMetaData> services = new ArrayList<ServiceMetaData>();
        services.add(dsMbean);
        deployment.setServices(services);
        ComponentType type = new ComponentType("FakeDataSource", "LocalTx");
        unit.addAttachment(ComponentType.class, (Object)type);
        return deployment;
    }

    protected boolean allowsReparse() {
        return true;
    }

    public ServiceMetaData createDsServiceMetaData(DataSourceDeployment ds) throws Exception {
        ServiceMetaData dsMbean = new ServiceMetaData();
        this.log.info((Object)("DataSource settings: " + ds));
        String jndiName = ds.getJndiName() == null ? "DefaultFakeDS" : ds.getJndiName();
        ObjectName objectName = new ObjectName("jboss.jca:type=FakeDataSourceConn,jndiName=" + jndiName);
        dsMbean.setObjectName(objectName);
        dsMbean.setCode(FakeDataSourceConn.class.getName());
        ServiceConstructorMetaData constructor = new ServiceConstructorMetaData();
        constructor.setSignature(new String[]{DataSourceDeployment.class.getName()});
        constructor.setParameters(new Object[]{ds});
        dsMbean.setConstructor(constructor);
        ArrayList<ServiceAttributeMetaData> attributes = new ArrayList<ServiceAttributeMetaData>();
        ServiceAttributeMetaData attribute = new ServiceAttributeMetaData();
        attribute.setName("JndiName");
        attribute.setReplace(true);
        attribute.setTrim(true);
        attribute.setValue((ServiceValueMetaData)new ServiceTextValueMetaData(jndiName));
        attributes.add(attribute);
        attribute = new ServiceAttributeMetaData();
        attribute.setName("JdbcURL");
        if (ds.getJdbcURL() != null) {
            attribute.setValue((ServiceValueMetaData)new ServiceTextValueMetaData(ds.getJdbcURL()));
        }
        attributes.add(attribute);
        attribute = new ServiceAttributeMetaData();
        attribute.setName("DriverClass");
        if (ds.getDriverClass() != null) {
            attribute.setValue((ServiceValueMetaData)new ServiceTextValueMetaData(ds.getDriverClass()));
        }
        attributes.add(attribute);
        attribute = new ServiceAttributeMetaData();
        attribute.setName("Username");
        if (ds.getUsername() != null) {
            attribute.setValue((ServiceValueMetaData)new ServiceTextValueMetaData(ds.getUsername()));
        }
        attributes.add(attribute);
        attribute = new ServiceAttributeMetaData();
        attribute.setName("Password");
        if (ds.getPassword() != null) {
            attribute.setValue((ServiceValueMetaData)new ServiceTextValueMetaData(ds.getPassword()));
        }
        attributes.add(attribute);
        attribute = new ServiceAttributeMetaData();
        attribute.setName("SecurityDomain");
        if (ds.getSecurityDomain() != null) {
            attribute.setValue((ServiceValueMetaData)new ServiceTextValueMetaData(ds.getSecurityDomain()));
        }
        attributes.add(attribute);
        attribute = new ServiceAttributeMetaData();
        attribute.setName("MinPoolSize");
        if (ds.getMinPoolSize() != null) {
            attribute.setValue((ServiceValueMetaData)new ServiceTextValueMetaData(ds.getMinPoolSize()));
        }
        attributes.add(attribute);
        attribute = new ServiceAttributeMetaData();
        attribute.setName("MaxPoolSize");
        if (ds.getMaxPoolSize() != null) {
            attribute.setValue((ServiceValueMetaData)new ServiceTextValueMetaData(ds.getMaxPoolSize()));
        }
        attributes.add(attribute);
        attribute = new ServiceAttributeMetaData();
        attribute.setName("ConnectionProperties");
        if (ds.getMaxPoolSize() != null) {
            attribute.setValue((ServiceValueMetaData)new ServiceTextValueMetaData(ds.getMaxPoolSize()));
        }
        attributes.add(attribute);
        dsMbean.setAttributes(attributes);
        List<String> depends = ds.getDepends();
        ArrayList dependencies = new ArrayList();
        for (String iDependOn : depends) {
            ServiceDependencyMetaData sdmd = new ServiceDependencyMetaData();
            sdmd.setIDependOn(iDependOn);
        }
        dsMbean.setDependencies(dependencies);
        return dsMbean;
    }
}

