/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.profileservice.remoting;

import org.jboss.aop.joinpoint.InvocationResponse;
import org.jboss.aspects.remoting.AOPRemotingInvocationHandler;
import org.jboss.deployers.spi.management.ManagementView;
import org.jboss.deployers.spi.management.deploy.DeploymentManager;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.ServerInvocationHandler;

/**
 * The remoting ServerInvocationHandler implementation for the ProfileService.
 * 
 * @see AOPRemotingInvocationHandler
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision:$
 */
public class ProfileServiceInvocationHandler extends AOPRemotingInvocationHandler
   implements ServerInvocationHandler
{
   private ManagementView mgtViewProxy;
   private DeploymentManager deployMgrProxy;

   public ManagementView getManagementViewProxy()
   {
      return mgtViewProxy;
   }
   public void setManagementViewProxy(ManagementView mgtViewProxy)
   {
      this.mgtViewProxy = mgtViewProxy;
   }

   
   public DeploymentManager getDeployMgrProxy()
   {
      return deployMgrProxy;
   }
   public void setDeployMgrProxy(DeploymentManager deployMgrProxy)
   {
      this.deployMgrProxy = deployMgrProxy;
   }

   public Object invoke(InvocationRequest invocation)
      throws Throwable
   {
      InvocationResponse value = (InvocationResponse) super.invoke(invocation);
      if( value.getResponse() instanceof ManagementView )
      {
         // Replace the ManagementView with its proxy
         value.setResponse(mgtViewProxy);
      }
      if( value.getResponse() instanceof DeploymentManager )
      {
         // Replace the DeploymentManager with its proxy
         value.setResponse(deployMgrProxy);
      }

      return value;
   }

}
