/*
* JBoss, Home of Professional Open Source
* Copyright 2006, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.profileservice.management;

import java.lang.reflect.UndeclaredThrowableException;

import org.jboss.kernel.spi.registry.KernelBus;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.MetaValueFactory;

/**
 * Microcontainer KernelBus runtime component dispatcher.
 *
 * @author <a href="mailto:ales.justin@jboss.com">Ales Justin</a>
 */
public class KernelBusRuntimeComponentDispatcher extends AbstractRuntimeComponentDispatcher
{
   private KernelBus bus;

   public KernelBusRuntimeComponentDispatcher(KernelBus bus)
   {
      this(bus, null);
   }

   public KernelBusRuntimeComponentDispatcher(KernelBus bus, MetaValueFactory valueFactory)
   {
      super(valueFactory);
      if (bus == null)
         throw new IllegalArgumentException("Null kernel bus.");
      this.bus = bus;
   }

   public MetaValue get(Object componentName, String propertyName)
   {
      try
      {
         return create(bus.get(componentName, propertyName));
      }
      catch (Throwable t)
      {
         throw new UndeclaredThrowableException(t);
      }
   }

   public void set(Object componentName, String propertyName, MetaValue value)
   {
      try
      {
         bus.set(componentName, propertyName, unwrap(value));
      }
      catch (Throwable t)
      {
         throw new UndeclaredThrowableException(t);
      }
   }

   public Object invoke(Object componentName, String methodName, MetaValue... param)
   {
      try
      {
         return bus.invoke(componentName, methodName, toArguments(param), toSignature(param));
      }
      catch (Throwable t)
      {
         throw new UndeclaredThrowableException(t);
      }
   }
}
