/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.management;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.Arrays;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.registry.KernelBus;
import org.jboss.managed.api.ManagedOperation;
import org.jboss.managed.api.ManagedParameter;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.metatype.api.values.EnumValueSupport;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.MetaValueFactory;
import org.jboss.metatype.spi.values.MetaMapper;
import org.jboss.profileservice.management.AbstractRuntimeComponentDispatcher;
import org.jboss.profileservice.spi.types.ControllerStateMetaType;

public class KernelBusRuntimeComponentDispatcher
extends AbstractRuntimeComponentDispatcher {
    private KernelBus bus;
    private Kernel kernel;

    public KernelBusRuntimeComponentDispatcher(Kernel kernel) {
        this(kernel, null);
    }

    public KernelBusRuntimeComponentDispatcher(Kernel kernel, MetaValueFactory valueFactory) {
        super(valueFactory);
        if (kernel == null) {
            throw new IllegalArgumentException("Null kernel");
        }
        this.kernel = kernel;
        this.bus = kernel.getBus();
    }

    public void start() {
        if (this.kernel == null) {
            throw new IllegalArgumentException("Null kernel");
        }
        if (this.bus == null) {
            throw new IllegalArgumentException("Null kernel bus");
        }
    }

    public MetaValue get(Object componentName, String propertyName) {
        ManagedProperty prop = AbstractRuntimeComponentDispatcher.getActiveProperty();
        try {
            Object value = this.bus.get(componentName, propertyName);
            MetaValue mvalue = null;
            if (value != null) {
                MetaMapper mapper;
                mvalue = prop != null ? ((mapper = (MetaMapper)prop.getTransientAttachment(MetaMapper.class)) != null ? mapper.createMetaValue(prop.getMetaType(), value) : this.create(value)) : this.create(value);
            }
            return mvalue;
        }
        catch (Throwable t) {
            if (propertyName.equals("state") && prop.getMetaType().equals(ControllerStateMetaType.TYPE)) {
                String stateString = this.getState(componentName);
                EnumValueSupport state = new EnumValueSupport(ControllerStateMetaType.TYPE, stateString);
                return state;
            }
            throw new UndeclaredThrowableException(t, "Failed to get property '" + propertyName + "' on component '" + componentName + "'.");
        }
    }

    public void set(Object componentName, String propertyName, MetaValue value) {
        try {
            MetaMapper mapper;
            ManagedProperty prop = AbstractRuntimeComponentDispatcher.getActiveProperty();
            Object uvalue = null;
            uvalue = prop != null ? ((mapper = (MetaMapper)prop.getTransientAttachment(MetaMapper.class)) != null ? mapper.unwrapMetaValue(value) : this.unwrap(value)) : this.unwrap(value);
            this.bus.set(componentName, propertyName, uvalue);
        }
        catch (Throwable t) {
            throw new UndeclaredThrowableException(t, "Failed to set property '" + propertyName + "' on component '" + componentName + "' to value [" + value + "].");
        }
    }

    public Object invoke(Object componentName, String methodName, MetaValue ... param) {
        try {
            ManagedOperation op = AbstractRuntimeComponentDispatcher.getActiveOperation();
            String[] sig = new String[param.length];
            Object[] args = new Object[param.length];
            if (op != null) {
                ManagedParameter[] params = op.getParameters();
                if (params != null && params.length == param.length) {
                    for (int i = 0; i < param.length; ++i) {
                        ManagedParameter mp = params[i];
                        MetaMapper mapper = (MetaMapper)mp.getTransientAttachment(MetaMapper.class);
                        args[i] = mapper != null ? mapper.unwrapMetaValue(param[i]) : this.unwrap(param[i]);
                        sig[i] = mp.getMetaType().getTypeName();
                    }
                } else {
                    args = this.toArguments(param);
                    sig = KernelBusRuntimeComponentDispatcher.toSignature(param);
                }
            } else {
                args = this.toArguments(param);
                sig = KernelBusRuntimeComponentDispatcher.toSignature(param);
            }
            Object value = this.bus.invoke(componentName, methodName, args, sig);
            MetaValue mvalue = null;
            if (value != null) {
                MetaMapper returnTypeMapper = (MetaMapper)op.getTransientAttachment(MetaMapper.class);
                mvalue = returnTypeMapper != null ? returnTypeMapper.createMetaValue(op.getReturnType(), value) : this.create(value);
            }
            return mvalue;
        }
        catch (Throwable t) {
            throw new UndeclaredThrowableException(t, "Failed to invoke method '" + methodName + "' on component '" + componentName + "' with parameters " + Arrays.asList(param) + ".");
        }
    }

    public String getState(Object name) {
        KernelController controller = this.kernel.getController();
        ControllerContext context = controller.getContext(name, null);
        if (context == null) {
            throw new IllegalStateException("Context not installed: " + name);
        }
        ControllerState state = context.getState();
        return state.getStateString();
    }
}

