/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.management.upload;

import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.deployers.spi.management.deploy.DeploymentID;
import org.jboss.deployers.spi.management.deploy.DeploymentManager;
import org.jboss.deployers.spi.management.deploy.DeploymentProgress;
import org.jboss.deployers.spi.management.deploy.DeploymentStatus;
import org.jboss.deployers.spi.management.deploy.DeploymentTarget;
import org.jboss.logging.Logger;
import org.jboss.profileservice.management.upload.DeploymentProgressImpl;
import org.jboss.profileservice.management.upload.SerializableDeploymentID;
import org.jboss.profileservice.management.upload.remoting.StreamingDeploymentTarget;
import org.jboss.profileservice.spi.MutableProfile;
import org.jboss.profileservice.spi.NoSuchProfileException;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.ProfileRepository;
import org.jboss.remoting.InvokerLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentManagerImpl
implements DeploymentManager {
    private static Logger log = Logger.getLogger(DeploymentManagerImpl.class);
    private static final String BUNDLE_NAME = "org.jboss.profileservice.management.upload.messages";
    private ProfileRepository profileRepository;
    private ProfileKey defaultKey;
    private ProfileKey activeProfileKey;
    private ResourceBundle i18n;
    private Locale currentLocale;
    private MessageFormat formatter = new MessageFormat("");
    private InvokerLocator locator;
    private String remotingSubsystem = "DeploymentManager";

    public DeploymentManagerImpl() {
        this.currentLocale = Locale.getDefault();
        this.formatter.setLocale(this.currentLocale);
        this.i18n = ResourceBundle.getBundle(BUNDLE_NAME, this.currentLocale);
    }

    public ProfileKey getDefaultProfileKey() {
        return this.defaultKey;
    }

    public void setDefaultProfileKey(ProfileKey defaultKey) {
        this.defaultKey = defaultKey;
    }

    public ProfileRepository getProfileRepository() {
        return this.profileRepository;
    }

    public void setProfileRepository(ProfileRepository profileRepository) {
        this.profileRepository = profileRepository;
    }

    public InvokerLocator getLocator() {
        return this.locator;
    }

    public void setLocator(InvokerLocator locator) {
        this.locator = locator;
    }

    public String getRemotingSubsystem() {
        return this.remotingSubsystem;
    }

    public void setRemotingSubsystem(String remotingSubsystem) {
        this.remotingSubsystem = remotingSubsystem;
    }

    public Collection<ProfileKey> getProfiles() {
        return new ArrayList<ProfileKey>(this.profileRepository.getProfileKeys());
    }

    public DeploymentProgress distribute(String name, URL contentURL) throws Exception {
        return this.distribute(name, contentURL, true);
    }

    public DeploymentProgress distribute(String name, URL contentURL, boolean copyContent) {
        if (name == null) {
            throw new IllegalArgumentException("Null name.");
        }
        if (contentURL == null) {
            throw new IllegalArgumentException("Null content url.");
        }
        if (this.getTargetProfile() == null) {
            this.formatter.applyPattern(this.i18n.getString("DeploymentManager.NoProfileLoadedException"));
            Object[] args = new Object[]{};
            String msg = this.formatter.format(args);
            throw new IllegalStateException(msg);
        }
        List<DeploymentTarget> targets = this.getDeploymentTargets();
        SerializableDeploymentID deployment = new SerializableDeploymentID(name, this.getTargetProfile(), contentURL.toString());
        deployment.setContentURL(contentURL);
        deployment.setCopyContent(copyContent);
        return new DeploymentProgressImpl(targets, deployment, DeploymentStatus.CommandType.DISTRIBUTE);
    }

    public String[] getRepositoryNames(String[] names) throws Exception {
        List<DeploymentTarget> targets = this.getDeploymentTargets();
        SerializableDeploymentID deployment = new SerializableDeploymentID(names, this.getTargetProfile(), null);
        return targets.get(0).getRepositoryNames((DeploymentID)deployment);
    }

    public boolean isRedeploySupported() {
        return this.getTargetProfile() instanceof MutableProfile;
    }

    public void loadProfile(ProfileKey key) throws NoSuchProfileException {
        if (key.isDefaultKey() && this.defaultKey != null) {
            key = this.defaultKey;
        }
        this.checkProfile(key);
        this.activeProfileKey = key;
    }

    public void releaseProfile() {
        this.activeProfileKey = null;
    }

    public DeploymentProgress redeploy(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name.");
        }
        if (this.getTargetProfile() == null) {
            this.formatter.applyPattern(this.i18n.getString("DeploymentManager.NoProfileLoadedException"));
            Object[] args = new Object[]{};
            String msg = this.formatter.format(args);
            throw new IllegalStateException(msg);
        }
        List<DeploymentTarget> targets = this.getDeploymentTargets();
        SerializableDeploymentID deployment = new SerializableDeploymentID(name, this.getTargetProfile(), null);
        return new DeploymentProgressImpl(targets, deployment, DeploymentStatus.CommandType.REDEPLOY);
    }

    public DeploymentProgress prepare(String ... names) throws Exception {
        return this.doProgress(DeploymentStatus.CommandType.PREPARE, names);
    }

    public DeploymentProgress start(String ... names) {
        if (names == null) {
            throw new IllegalArgumentException("Null names.");
        }
        return this.doProgress(DeploymentStatus.CommandType.START, names);
    }

    public DeploymentProgress stop(String ... names) {
        if (names == null) {
            throw new IllegalArgumentException("Null names.");
        }
        return this.doProgress(DeploymentStatus.CommandType.STOP, names);
    }

    public DeploymentProgress remove(String ... names) {
        if (names == null) {
            throw new IllegalArgumentException("Null names.");
        }
        return this.doProgress(DeploymentStatus.CommandType.REMOVE, names);
    }

    protected DeploymentProgress doProgress(DeploymentStatus.CommandType type, String ... names) {
        if (this.getTargetProfile() == null) {
            this.formatter.applyPattern(this.i18n.getString("DeploymentManager.NoProfileLoadedException"));
            Object[] args = new Object[]{};
            String msg = this.formatter.format(args);
            throw new IllegalStateException(msg);
        }
        if (names == null || names.length == 0) {
            log.warn((Object)"Null or empty names.");
        }
        List<DeploymentTarget> targets = this.getDeploymentTargets();
        SerializableDeploymentID deployment = new SerializableDeploymentID(names, this.getTargetProfile(), null);
        return new DeploymentProgressImpl(targets, deployment, type);
    }

    public void checkProfile(ProfileKey key) throws NoSuchProfileException {
        if (!this.getProfiles().contains(key)) {
            this.formatter.applyPattern(this.i18n.getString("DeploymentManager.NoMutableProfileException"));
            Object[] args = new Object[]{key};
            String msg = this.formatter.format(args);
            throw new NoSuchProfileException(msg);
        }
    }

    protected ProfileKey getTargetProfile() {
        if (this.activeProfileKey == null) {
            return this.defaultKey;
        }
        return this.activeProfileKey;
    }

    protected List<DeploymentTarget> getDeploymentTargets() {
        String targetName = this.locator.getHost();
        ArrayList<DeploymentTarget> targets = new ArrayList<DeploymentTarget>();
        StreamingDeploymentTarget hostTarget = new StreamingDeploymentTarget(this.locator, targetName, this.remotingSubsystem);
        targets.add(hostTarget);
        return targets;
    }
}

