/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.integration.deployers;

import java.io.Externalizable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.ejb.EJBException;
import javax.ejb.Local;
import javax.ejb.LocalHome;
import javax.ejb.Remote;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.ejb.deployers.MergedJBossMetaDataDeployer;
import org.jboss.ejb3.annotation.LocalBinding;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.resteasy.integration.deployers.ResteasyDeploymentData;
import org.jboss.resteasy.util.GetRestful;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResteasyEjbDeployer
extends AbstractRealDeployer {
    private static final Logger LOGGER = Logger.getLogger(ResteasyEjbDeployer.class);

    public ResteasyEjbDeployer() {
        this.addRequiredInput(JBossWebMetaData.class);
        this.addRequiredInput(ResteasyDeploymentData.class);
        this.addRequiredInput(MergedJBossMetaDataDeployer.EJB_MERGED_ATTACHMENT_NAME);
        this.addOutput(JBossWebMetaData.class);
        this.setStage(DeploymentStages.PRE_REAL);
    }

    protected void internalDeploy(DeploymentUnit du) throws DeploymentException {
        ResteasyDeploymentData resteasy = (ResteasyDeploymentData)du.getAttachment(ResteasyDeploymentData.class);
        if (!resteasy.isScanResources()) {
            return;
        }
        JBossWebMetaData webdata = (JBossWebMetaData)du.getAttachment(JBossWebMetaData.class);
        JBossMetaData ejbs = (JBossMetaData)du.getAttachment(MergedJBossMetaDataDeployer.EJB_MERGED_ATTACHMENT_NAME);
        ClassLoader loader = du.getClassLoader();
        StringBuffer buf = null;
        for (JBossEnterpriseBeanMetaData ejb : ejbs.getEnterpriseBeans()) {
            Class<?> ejbClass = null;
            try {
                ejbClass = loader.loadClass(ejb.getEjbClass());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            if (!GetRestful.isRootResource(ejbClass)) continue;
            String jndiName = ResteasyEjbDeployer.getLocalJndiName(ejb, ejbClass);
            this.log.info((Object)("Found JAX-RS EJB: " + ejbClass.getName() + " local jndi name: " + jndiName));
            if (buf == null) {
                buf = new StringBuffer();
            } else {
                buf.append(",");
            }
            buf.append(jndiName).append(";").append(ejbClass.getName()).append(";").append("true");
            resteasy.getResources().remove(ejbClass.getName());
        }
        if (buf != null) {
            resteasy.createDispatcher();
            String paramValue = buf.toString();
            ParamValueMetaData param = new ParamValueMetaData();
            param.setParamName("resteasy.jndi.component.resources");
            param.setParamValue(paramValue);
            ArrayList<ParamValueMetaData> params = webdata.getContextParams();
            if (params == null) {
                params = new ArrayList<ParamValueMetaData>();
                webdata.setContextParams(params);
            }
            params.add(param);
            param = new ParamValueMetaData();
            param.setParamName("resteasy.unwrapped.exceptions");
            param.setParamValue(EJBException.class.getName());
            params.add(param);
        }
    }

    private static String getLocalJndiName(JBossEnterpriseBeanMetaData ejb, Class<?> ejbClass) {
        LocalBinding localBinding = ejbClass.getAnnotation(LocalBinding.class);
        if (localBinding == null || localBinding.jndiBinding() != null && localBinding.jndiBinding().trim().length() == 0) {
            String name = ejb.getLocalJndiName();
            return name;
        }
        return localBinding.jndiBinding();
    }

    public static Set<Class<?>> getBusinessInterfaces(Class<?> beanClass) {
        return ResteasyEjbDeployer.getBusinessInterfaces(beanClass, new HashSet());
    }

    public static Set<Class<?>> getBusinessInterfaces(Class<?> beanClass, boolean includeSupers) {
        return ResteasyEjbDeployer.getBusinessInterfaces(beanClass, new HashSet(), includeSupers);
    }

    private static Set<Class<?>> getBusinessInterfaces(Class<?> beanClass, Set<Class<?>> interfaces) {
        return ResteasyEjbDeployer.getBusinessInterfaces(beanClass, interfaces, true);
    }

    private static Set<Class<?>> getBusinessInterfaces(Class<?> beanClass, Set<Class<?>> interfaces, boolean includeSupers) {
        for (Class<?> intf : beanClass.getInterfaces()) {
            if (intf.equals(Externalizable.class) || intf.equals(Serializable.class) || intf.getName().startsWith("javax.ejb") || intf.getName().startsWith("org.jboss.aop")) continue;
            interfaces.add(intf);
        }
        if (!includeSupers || beanClass.getSuperclass() == null) {
            return interfaces;
        }
        return ResteasyEjbDeployer.getBusinessInterfaces(beanClass.getSuperclass(), interfaces);
    }

    public static Class<?>[] getLocalInterfaces(Class<?> beanClass) {
        HashSet localAndBusinessLocalInterfaces = new HashSet();
        Local localAnnotation = beanClass.getAnnotation(Local.class);
        LocalHome localHomeAnnotation = beanClass.getAnnotation(LocalHome.class);
        Remote remoteAnnotation = beanClass.getAnnotation(Remote.class);
        Set<Class<?>> businessInterfacesImplementedByBeanClass = ResteasyEjbDeployer.getBusinessInterfaces(beanClass);
        Set<Class<?>> businessInterfacesDirectlyImplementedByBeanClass = ResteasyEjbDeployer.getBusinessInterfaces(beanClass, false);
        for (Class<?> clazz : businessInterfacesImplementedByBeanClass) {
            if (!clazz.isAnnotationPresent(Local.class)) continue;
            localAndBusinessLocalInterfaces.add(clazz);
        }
        if (businessInterfacesDirectlyImplementedByBeanClass.size() == 1 && localAndBusinessLocalInterfaces.size() == 0) {
            Class<?> singleInterface = businessInterfacesDirectlyImplementedByBeanClass.iterator().next();
            if (remoteAnnotation == null && singleInterface.getAnnotation(Remote.class) == null) {
                Class[] returnValue = new Class[]{singleInterface};
                return returnValue;
            }
        }
        if (localAnnotation != null) {
            if (localAnnotation.value() == null || localAnnotation.value().length == 0) {
                if (businessInterfacesImplementedByBeanClass.size() == 0) {
                    return new Class[0];
                }
                if (businessInterfacesImplementedByBeanClass.size() > 1) {
                    return new Class[0];
                }
                if (remoteAnnotation == null) {
                    Class[] returnValue = businessInterfacesImplementedByBeanClass.toArray(new Class[0]);
                    return returnValue;
                }
            } else {
                for (Class clazz : localAnnotation.value()) {
                    localAndBusinessLocalInterfaces.add(clazz);
                }
                for (Class<?> clazz : businessInterfacesImplementedByBeanClass) {
                    if (!clazz.isAnnotationPresent(Local.class)) continue;
                    localAndBusinessLocalInterfaces.add(clazz);
                }
            }
        }
        if (localAndBusinessLocalInterfaces.size() > 0) {
            Class[] rtn = localAndBusinessLocalInterfaces.toArray(new Class[0]);
            return rtn;
        }
        return new Class[0];
    }
}

