/*
  * JBoss, Home of Professional Open Source
  * Copyright 2005, JBoss Inc., and individual contributors as indicated
  * by the @authors tag. See the copyright.txt in the distribution for a
  * full listing of individual contributors.
  *
  * This is free software; you can redistribute it and/or modify it
  * under the terms of the GNU Lesser General Public License as
  * published by the Free Software Foundation; either version 2.1 of
  * the License, or (at your option) any later version.
  *
  * This software is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this software; if not, write to the Free
  * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
  * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
  */
package org.jboss.security;

import javax.management.MBeanServer;

import org.jboss.logging.Logger;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.security.plugins.AuthorizationManagerServiceMBean;

//$Id: AuthorizationManagerFactory.java 46208 2006-07-11 19:39:14Z asaldhana $

/**
 *  Factory for obtaining the AuthorizationManager
 *  @author <a href="mailto:Anil.Saldhana@jboss.org">Anil Saldhana</a>
 *  @since  Jan 4, 2006 
 *  @version $Revision: 46208 $
 */
public class AuthorizationManagerFactory
{
   private static Logger log = Logger.getLogger(AuthorizationManagerFactory.class);
   
   public static AuthorizationManager getAuthorizationManager( String securityDomain)
   {
      log.debug("Enter getAuthorizationManager with securityDomain=" + securityDomain);
      AuthorizationManager manager = null; 
      MBeanServer server = MBeanServerLocator.locateJBoss(); 
      AuthorizationManagerServiceMBean mbean =(AuthorizationManagerServiceMBean)
                             MBeanProxyExt.create(AuthorizationManagerServiceMBean.class,
                                   AuthorizationManagerServiceMBean.OBJECT_NAME, server);
      manager = mbean.getAuthorizationManager(securityDomain); 
      log.debug("return getAuthorizationManager=" + manager);
      return manager;
   }
}
