/*
  * JBoss, Home of Professional Open Source
  * Copyright 2005, JBoss Inc., and individual contributors as indicated
  * by the @authors tag. See the copyright.txt in the distribution for a
  * full listing of individual contributors.
  *
  * This is free software; you can redistribute it and/or modify it
  * under the terms of the GNU Lesser General Public License as
  * published by the Free Software Foundation; either version 2.1 of
  * the License, or (at your option) any later version.
  *
  * This software is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this software; if not, write to the Free
  * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
  * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
  */
package org.jboss.security.plugins;
 
import javax.management.ObjectName;

import org.jboss.mx.util.ObjectNameFactory;
import org.jboss.security.AuthorizationManager;
import org.jboss.system.ServiceMBean;

//$Id: AuthorizationManagerServiceMBean.java 56406 2006-08-29 16:01:54Z anil.saldhana@jboss.com $

/**
 *  Management interface for the AuthorizationManagerService MBean
 *  @author <a href="mailto:Anil.Saldhana@jboss.org">Anil Saldhana</a>
 *  @since  Jan 2, 2006 
 *  @version $Revision: 56406 $
 */
public interface AuthorizationManagerServiceMBean 
extends ServiceMBean, AuthorizationManager
{  
   /** The default ObjectName */
   ObjectName OBJECT_NAME = ObjectNameFactory.create("jboss.security:service=AuthorizationManager");

   /**
    * Set the name of the class that provides the authorization manager implementation.
    * 
    * @exception ClassNotFoundException thrown if the className cannot be found
    * using the thread context class loader.
    * @exception ClassCastException thrown if the className does not implement the
    * org.jboss.security.AuthorizationManager interface.
    */
   void setAuthorizationManagerClassName(String className)
      throws ClassNotFoundException, ClassCastException; 
   
   /**
    * 
    * Get the name of the class that provides the authorization manager implementation.
    * 
    * @return
    */
   String getAuthorizationManagerClassName();
   
   /**
    * Gets an AuthorizationManager instance given a security domain
    * 
    * @param securityDomain
    * @return
    */
   AuthorizationManager getAuthorizationManager(String securityDomain);
}
