/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.integration;

import java.security.Principal;
import javax.security.auth.Subject;
import org.jboss.logging.Logger;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.ISecurityManagement;
import org.jboss.security.SubjectFactory;
import org.jboss.security.integration.SecurityActions;

public class JBossSecuritySubjectFactory
implements SubjectFactory {
    protected static Logger log = Logger.getLogger(JBossSecuritySubjectFactory.class);
    protected ISecurityManagement securityManagement;

    public Subject createSubject() {
        return this.createSubject("other");
    }

    public Subject createSubject(String securityDomainName) {
        if (this.securityManagement == null) {
            throw new IllegalStateException("SecurityManagement has not been injected");
        }
        Subject subject = new Subject();
        Principal principal = SecurityActions.getPrincipal();
        AuthenticationManager authenticationManager = this.securityManagement.getAuthenticationManager(securityDomainName);
        if (authenticationManager == null) {
            String defaultSecurityDomain = "other";
            if (log.isTraceEnabled()) {
                log.trace((Object)("AuthenticationManager for " + securityDomainName + " not found. Using " + defaultSecurityDomain));
            }
            authenticationManager = this.securityManagement.getAuthenticationManager(defaultSecurityDomain);
        }
        if (!authenticationManager.isValid(principal, SecurityActions.getCredential(), subject)) {
            throw new SecurityException("Unauthenticated caller:" + principal);
        }
        return subject;
    }

    public void setSecurityManagement(ISecurityManagement securityManagement) {
        this.securityManagement = securityManagement;
    }
}

