/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.logging.Logger;
import org.jboss.security.auth.AuthenticationTimedCachePolicy;
import org.jboss.security.integration.SecurityConstantsBridge;
import org.jboss.security.plugins.SecurityDomainContext;
import org.jboss.util.CachePolicy;
import org.jboss.util.TimedCachePolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthenticationCacheFlushThread
extends Thread {
    private static Logger log = Logger.getLogger(AuthenticationCacheFlushThread.class);
    private static ConcurrentHashMap<String, SecurityDomainContext> securityMgrMap;

    public AuthenticationCacheFlushThread(ConcurrentHashMap<String, SecurityDomainContext> securityMgrMap) {
        super("AuthenticationCacheFlushThread");
        AuthenticationCacheFlushThread.securityMgrMap = securityMgrMap;
    }

    @Override
    public void run() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Starting authentication cache flush thread");
        }
        while (true) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Running authentication cache flush thread");
            }
            for (Map.Entry<String, SecurityDomainContext> entry : securityMgrMap.entrySet()) {
                String securityDomain = entry.getKey();
                SecurityDomainContext securityDomainCtx = entry.getValue();
                CachePolicy cache = securityDomainCtx.getAuthenticationCache();
                AuthenticationTimedCachePolicy timedCache = null;
                if (cache instanceof TimedCachePolicy) {
                    timedCache = (AuthenticationTimedCachePolicy)cache;
                }
                if (timedCache == null) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Scanning security domain " + securityDomain + " for expired entries"));
                }
                List expiredEntries = timedCache.getInvalidKeys();
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Found " + expiredEntries.size() + " expired entries"));
                }
                for (Object expiredEntry : expiredEntries) {
                    timedCache.remove(expiredEntry);
                }
            }
            try {
                if (this.isInterrupted()) break;
                Thread.sleep(SecurityConstantsBridge.defaultCacheFlushPeriod * 1000);
            }
            catch (InterruptedException ie) {
                // empty catch block
                break;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Stopping authentication cache flush thread");
        }
    }
}

