/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.deployers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.aop.microcontainer.aspects.jmx.JMX;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.vfs.spi.deployer.AbstractSimpleVFSRealDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.ejb.EjbModule;
import org.jboss.ejb.deployers.EjbDeployerMBean;
import org.jboss.metadata.ApplicationMetaData;
import org.jboss.metadata.ejb.jboss.ContainerConfigurationMetaData;
import org.jboss.metadata.ejb.jboss.InvokerProxyBindingMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeansMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.security.ISecurityManagement;
import org.jboss.system.metadata.ServiceAttributeMetaData;
import org.jboss.system.metadata.ServiceConstructorMetaData;
import org.jboss.system.metadata.ServiceDependencyMetaData;
import org.jboss.system.metadata.ServiceDependencyValueMetaData;
import org.jboss.system.metadata.ServiceMetaData;
import org.jboss.system.metadata.ServiceValueMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JMX(name="jboss.ejb:service=EJBDeployer", exposedInterface=EjbDeployerMBean.class)
public class EjbDeployer
extends AbstractSimpleVFSRealDeployer<JBossMetaData>
implements EjbDeployerMBean {
    private String transactionManagerServiceName;
    private String webServiceName;
    private String ccmServiceName;
    private String timerServiceName;
    private boolean callByValue;
    private String unauthenticatedIdentity = null;
    private ISecurityManagement securityManagement;
    private String securityContextClassName;
    private String defaultSecurityDomain;

    public EjbDeployer() {
        super(JBossMetaData.class);
        this.setOutput(ServiceMetaData.class);
    }

    @Override
    public String getTransactionManagerServiceName() {
        return this.transactionManagerServiceName;
    }

    @Override
    public void setTransactionManagerServiceName(String transactionManagerServiceName) {
        this.transactionManagerServiceName = transactionManagerServiceName;
    }

    @Override
    public String getWebServiceName() {
        return this.webServiceName;
    }

    @Override
    public void setWebServiceName(String webServiceName) {
        this.webServiceName = webServiceName;
    }

    public String getCachedConnectionManagerName() {
        return this.ccmServiceName;
    }

    public void setCachedConnectionManagerName(String ccmServiceName) {
        this.ccmServiceName = ccmServiceName;
    }

    public String getTimerService() {
        return this.timerServiceName;
    }

    public void setTimerServiceName(String timerServiceName) {
        this.timerServiceName = timerServiceName;
    }

    @Override
    public boolean isCallByValue() {
        return this.callByValue;
    }

    @Override
    public void setCallByValue(boolean callByValue) {
        this.callByValue = callByValue;
    }

    public String getUnauthenticatedIdentity() {
        return this.unauthenticatedIdentity;
    }

    public void setUnauthenticatedIdentity(String unauthenticatedIdentity) {
        this.unauthenticatedIdentity = unauthenticatedIdentity;
    }

    public void setDefaultSecurityDomain(String defaultSecurityDomain) {
        this.defaultSecurityDomain = defaultSecurityDomain;
    }

    public void setSecurityManagement(ISecurityManagement sm) {
        this.securityManagement = sm;
    }

    public void setSecurityContextClassName(String securityContextClassName) {
        this.securityContextClassName = securityContextClassName;
    }

    public void deploy(VFSDeploymentUnit unit, JBossMetaData deployment) throws DeploymentException {
        if (!deployment.isEJB2x() && !deployment.isEJB1x()) {
            return;
        }
        ServiceMetaData ejbModule = new ServiceMetaData();
        ejbModule.setCode(EjbModule.class.getName());
        ObjectName moduleObjectName = null;
        try {
            moduleObjectName = this.getObjectName(unit, deployment);
        }
        catch (MalformedObjectNameException e) {
            throw new DeploymentException("Failed to create EJB module " + unit.getName() + ": malformed EjbModule name", (Throwable)e);
        }
        ejbModule.setObjectName(moduleObjectName);
        ServiceConstructorMetaData ctor = new ServiceConstructorMetaData();
        ctor.setSignature(new String[]{VFSDeploymentUnit.class.getName(), ApplicationMetaData.class.getName()});
        ApplicationMetaData legacyMD = new ApplicationMetaData(deployment);
        ctor.setParameters(new Object[]{unit, legacyMD});
        ejbModule.setConstructor(ctor);
        ArrayList<ServiceAttributeMetaData> attrs = new ArrayList<ServiceAttributeMetaData>();
        ServiceAttributeMetaData attr = new ServiceAttributeMetaData();
        attr.setName("TransactionManagerFactory");
        ServiceDependencyValueMetaData dependencyValue = new ServiceDependencyValueMetaData();
        dependencyValue.setDependency(this.getTransactionManagerServiceName());
        dependencyValue.setProxyType("attribute");
        attr.setValue((ServiceValueMetaData)dependencyValue);
        attrs.add(attr);
        String wsName = this.getWebServiceName();
        if (wsName != null) {
            ServiceAttributeMetaData ws = new ServiceAttributeMetaData();
            ws.setName("WebServiceName");
            ServiceDependencyValueMetaData wsDepends = new ServiceDependencyValueMetaData();
            wsDepends.setDependency(wsName);
            ws.setValue((ServiceValueMetaData)wsDepends);
            attrs.add(ws);
        }
        ServiceAttributeMetaData tms = new ServiceAttributeMetaData();
        ServiceDependencyValueMetaData tmsDepends = new ServiceDependencyValueMetaData();
        tms.setName("TimerService");
        tmsDepends.setDependency(this.timerServiceName);
        tmsDepends.setProxyType("attribute");
        tms.setValue((ServiceValueMetaData)tmsDepends);
        attrs.add(tms);
        ejbModule.setAttributes(attrs);
        ArrayList<ServiceDependencyMetaData> dependencies = new ArrayList<ServiceDependencyMetaData>();
        if (this.ccmServiceName != null && this.ccmServiceName.length() > 0) {
            ServiceDependencyMetaData ccm = new ServiceDependencyMetaData();
            ccm.setIDependOn(this.ccmServiceName);
            dependencies.add(ccm);
        }
        JBossEnterpriseBeansMetaData beans = deployment.getEnterpriseBeans();
        Iterator beansIter = beans.iterator();
        HashSet<String> invokerNames = new HashSet<String>();
        HashSet beanDepends = new HashSet();
        while (beansIter.hasNext()) {
            JBossEnterpriseBeanMetaData bmd = (JBossEnterpriseBeanMetaData)beansIter.next();
            Set depends = bmd.getDepends();
            if (depends != null) {
                beanDepends.addAll(depends);
            }
            String configName = bmd.getConfigurationName();
            ContainerConfigurationMetaData cmd = bmd.determineContainerConfiguration();
            Set invokers = cmd.getInvokerProxyBindingNames();
            if (invokers == null) continue;
            for (String iname : invokers) {
                InvokerProxyBindingMetaData imd = deployment.getInvokerProxyBinding(iname);
                if (imd == null) {
                    throw new DeploymentException("Failed to locate invoker: " + iname);
                }
                String invokerName = imd.getInvokerMBean();
                if (invokerName.equalsIgnoreCase("default") || invokerNames.contains(invokerName)) continue;
                invokerNames.add(invokerName);
                ServiceDependencyMetaData invoker = new ServiceDependencyMetaData();
                invoker.setIDependOn(invokerName);
                dependencies.add(invoker);
            }
        }
        try {
            for (String depend : beanDepends) {
                ObjectName n = new ObjectName(depend);
                ServiceDependencyMetaData sdmd = new ServiceDependencyMetaData();
                sdmd.setIDependOn(n.toString());
                dependencies.add(sdmd);
            }
        }
        catch (MalformedObjectNameException e) {
            throw new DeploymentException((Throwable)e);
        }
        ejbModule.setDependencies(dependencies);
        unit.addAttachment(ServiceMetaData.class, (Object)ejbModule);
        if (this.callByValue) {
            unit.addAttachment("EJB.callByValue", (Object)Boolean.TRUE, Boolean.class);
        }
        if (this.unauthenticatedIdentity != null) {
            unit.addAttachment("EJB.unauthenticatedIdentity", (Object)this.unauthenticatedIdentity, String.class);
        }
        if (this.securityManagement != null) {
            unit.addAttachment("EJB.securityManagement", (Object)this.securityManagement, ISecurityManagement.class);
        }
        if (this.securityContextClassName != null) {
            unit.addAttachment("EJB.securityContextClassName", (Object)this.securityContextClassName, String.class);
        }
        if (this.defaultSecurityDomain != null) {
            unit.addAttachment("EJB.defaultSecurityDomain", (Object)this.defaultSecurityDomain, String.class);
        }
    }

    public void undeploy(VFSDeploymentUnit unit, JBossMetaData deployment) {
    }

    protected ObjectName getObjectName(VFSDeploymentUnit unit, JBossMetaData metaData) throws MalformedObjectNameException {
        String name = metaData.getJmxName();
        if (name == null) {
            String unitShortName = unit.getName();
            if (unitShortName.endsWith("/")) {
                unitShortName = unitShortName.substring(0, unitShortName.length() - 1);
            }
            if (unitShortName.endsWith("!")) {
                unitShortName = unitShortName.substring(0, unitShortName.length() - 1);
            }
            unitShortName = unitShortName.substring(unitShortName.lastIndexOf("/") + 1);
            unitShortName = ObjectName.quote(unitShortName);
            name = "jboss.j2ee:service=EjbModule,module=" + unitShortName;
        }
        return new ObjectName(name);
    }
}

