/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import java.util.Set;
import javax.management.ObjectName;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.deployer.SchemaResolverDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.metadata.common.jboss.LoaderRepositoryConfigMetaData;
import org.jboss.metadata.common.jboss.LoaderRepositoryMetaData;
import org.jboss.metadata.web.jboss.ClassLoadingMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.WebMetaData;
import org.jboss.mx.loading.LoaderRepositoryFactory;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossWebAppParsingDeployer
extends SchemaResolverDeployer<JBossWebMetaData> {
    public JBossWebAppParsingDeployer() {
        super(JBossWebMetaData.class);
        this.setInput(WebMetaData.class);
        this.setName("jboss-web.xml");
    }

    public String getWebXmlPath() {
        return this.getName();
    }

    public void setWebXmlPath(String webXmlPath) {
        this.setName(webXmlPath);
    }

    protected void createMetaData(DeploymentUnit unit, String name, String suffix) throws DeploymentException {
        super.createMetaData(unit, name, suffix);
        WebMetaData specMetaData = (WebMetaData)unit.getAttachment(WebMetaData.class);
        JBossWebMetaData metaData = (JBossWebMetaData)unit.getAttachment(JBossWebMetaData.class);
        if (specMetaData == null && metaData == null) {
            return;
        }
        if (metaData == null) {
            metaData = new JBossWebMetaData();
        }
        JBossWebMetaData mergedMetaData = new JBossWebMetaData();
        mergedMetaData.merge(metaData, specMetaData);
        unit.getTransientManagedObjects().addAttachment(JBossWebMetaData.class, (Object)mergedMetaData);
        unit.addAttachment("Raw" + JBossWebMetaData.class.getName(), (Object)metaData, JBossWebMetaData.class);
    }

    protected void init(VFSDeploymentUnit unit, JBossWebMetaData metaData, VirtualFile file) throws Exception {
        ClassLoadingMetaData classLoading = metaData.getClassLoading();
        LoaderRepositoryMetaData lrmd = null;
        if (classLoading != null) {
            lrmd = classLoading.getLoaderRepository();
        }
        if (lrmd != null) {
            Set configs;
            LoaderRepositoryFactory.LoaderRepositoryConfig loaderConfig = new LoaderRepositoryFactory.LoaderRepositoryConfig();
            loaderConfig.repositoryClassName = lrmd.getLoaderRepositoryClass();
            if (lrmd.getName() != null) {
                loaderConfig.repositoryName = new ObjectName(lrmd.getName());
            }
            if ((configs = lrmd.getLoaderRepositoryConfig()) != null && !configs.isEmpty()) {
                LoaderRepositoryConfigMetaData config = (LoaderRepositoryConfigMetaData)configs.iterator().next();
                loaderConfig.configParserClassName = config.getConfigParserClass();
                loaderConfig.repositoryConfig = config.getConfig();
            }
            unit.addAttachment(LoaderRepositoryFactory.LoaderRepositoryConfig.class, (Object)loaderConfig);
        }
    }

    protected void createMetaData(DeploymentUnit unit, String name, String suffix, String key) throws DeploymentException {
        super.createMetaData(unit, name, suffix, key);
        WebMetaData wmd = (WebMetaData)unit.getTransientManagedObjects().getAttachment(WebMetaData.class);
        JBossWebMetaData result = (JBossWebMetaData)unit.getTransientManagedObjects().getAttachment(this.getOutput());
        if (result == null && wmd != null) {
            result = new JBossWebMetaData();
            result.merge(null, wmd);
            unit.getTransientManagedObjects().addAttachment(key, (Object)result, this.getOutput());
        }
    }
}

