/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import org.jboss.security.RunAs;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextFactory;
import org.jboss.security.plugins.SecurityContextAssociation;

class SecurityActions {
    SecurityActions() {
    }

    static ClassLoader getContextClassLoader() {
        return TCLAction.UTIL.getContextClassLoader();
    }

    static void setContextClassLoader(ClassLoader loader) {
        TCLAction.UTIL.setContextClassLoader(loader);
    }

    static RunAs peekRunAsIdentity() {
        if (System.getSecurityManager() == null) {
            return RunAsIdentityActions.NON_PRIVILEGED.peek();
        }
        return RunAsIdentityActions.PRIVILEGED.peek();
    }

    static void pushRunAsIdentity(RunAs principal) {
        if (System.getSecurityManager() == null) {
            RunAsIdentityActions.NON_PRIVILEGED.push(principal);
        } else {
            RunAsIdentityActions.PRIVILEGED.push(principal);
        }
    }

    static RunAs popRunAsIdentity() {
        if (System.getSecurityManager() == null) {
            return RunAsIdentityActions.NON_PRIVILEGED.pop();
        }
        return RunAsIdentityActions.PRIVILEGED.pop();
    }

    static Subject getContextSubject() throws PolicyContextException {
        if (System.getSecurityManager() == null) {
            return PolicyContextActions.NON_PRIVILEGED.getContextSubject();
        }
        return PolicyContextActions.PRIVILEGED.getContextSubject();
    }

    static void createAndSetSecurityContext(final Principal p, final Object cred, final String domain) throws PrivilegedActionException {
        AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                SecurityContext sc = SecurityContextFactory.createSecurityContext((Principal)p, (Object)cred, null, (String)domain);
                SecurityContextAssociation.setSecurityContext((SecurityContext)sc);
                return null;
            }
        });
    }

    static void createAndSetSecurityContext(final Principal p, final Object cred, final String domain, final Subject subject) throws PrivilegedActionException {
        AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                SecurityContext sc = SecurityContextFactory.createSecurityContext((String)domain);
                sc.getUtil().createSubjectInfo(p, cred, subject);
                SecurityContextAssociation.setSecurityContext((SecurityContext)sc);
                return null;
            }
        });
    }

    static void clearSecurityContext() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                SecurityContextAssociation.setSecurityContext(null);
                return null;
            }
        });
    }

    static SecurityContext getSecurityContext() {
        return (SecurityContext)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return SecurityContextAssociation.getSecurityContext();
            }
        });
    }

    static Exception getContextException() {
        return (Exception)AccessController.doPrivileged(new PrivilegedAction(){
            static final String EX_KEY = "org.jboss.security.exception";

            public Object run() {
                SecurityContext sc = SecurityActions.getSecurityContext();
                return sc.getData().get(EX_KEY);
            }
        });
    }

    static void pushSubjectContext(final Principal p, final Object cred, final Subject s) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                SecurityContext sc = SecurityActions.getSecurityContext();
                if (sc == null) {
                    throw new IllegalStateException("Security Context is null");
                }
                sc.getUtil().createSubjectInfo(p, cred, s);
                return null;
            }
        });
    }

    static void popSubjectContext() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                SecurityContext sc = SecurityActions.getSecurityContext();
                if (sc == null) {
                    throw new IllegalStateException("Security Context is null");
                }
                Principal p = sc.getUtil().getUserPrincipal();
                Object cred = sc.getUtil().getCredential();
                sc.getUtil().createSubjectInfo(p, cred, null);
                return null;
            }
        });
    }

    static void pushCallerRunAsIdentity(final RunAs ra) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                SecurityContext sc = SecurityContextAssociation.getSecurityContext();
                if (sc == null) {
                    throw new IllegalStateException("Security Context is null");
                }
                sc.setIncomingRunAs(ra);
                return null;
            }
        });
    }

    static void popCallerRunAsIdentity() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                SecurityContext sc = SecurityContextAssociation.getSecurityContext();
                if (sc == null) {
                    throw new IllegalStateException("Security Context is null");
                }
                sc.setIncomingRunAs(null);
                return null;
            }
        });
    }

    static interface TCLAction {
        public static final TCLAction NON_PRIVILEGED = new TCLAction(){

            public ClassLoader getContextClassLoader() {
                return Thread.currentThread().getContextClassLoader();
            }

            public ClassLoader getContextClassLoader(Thread thread) {
                return thread.getContextClassLoader();
            }

            public void setContextClassLoader(ClassLoader cl) {
                Thread.currentThread().setContextClassLoader(cl);
            }

            public void setContextClassLoader(Thread thread, ClassLoader cl) {
                thread.setContextClassLoader(cl);
            }
        };
        public static final TCLAction PRIVILEGED = new TCLAction(){
            private final PrivilegedAction getTCLPrivilegedAction = new PrivilegedAction(){

                public Object run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            };

            public ClassLoader getContextClassLoader() {
                return (ClassLoader)AccessController.doPrivileged(this.getTCLPrivilegedAction);
            }

            public ClassLoader getContextClassLoader(final Thread thread) {
                return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return thread.getContextClassLoader();
                    }
                });
            }

            public void setContextClassLoader(final ClassLoader cl) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Thread.currentThread().setContextClassLoader(cl);
                        return null;
                    }
                });
            }

            public void setContextClassLoader(final Thread thread, final ClassLoader cl) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        thread.setContextClassLoader(cl);
                        return null;
                    }
                });
            }
        };

        public ClassLoader getContextClassLoader();

        public ClassLoader getContextClassLoader(Thread var1);

        public void setContextClassLoader(ClassLoader var1);

        public void setContextClassLoader(Thread var1, ClassLoader var2);

        public static class UTIL {
            static TCLAction getTCLAction() {
                return System.getSecurityManager() == null ? NON_PRIVILEGED : PRIVILEGED;
            }

            static ClassLoader getContextClassLoader() {
                return UTIL.getTCLAction().getContextClassLoader();
            }

            static ClassLoader getContextClassLoader(Thread thread) {
                return UTIL.getTCLAction().getContextClassLoader(thread);
            }

            static void setContextClassLoader(ClassLoader cl) {
                UTIL.getTCLAction().setContextClassLoader(cl);
            }

            static void setContextClassLoader(Thread thread, ClassLoader cl) {
                UTIL.getTCLAction().setContextClassLoader(thread, cl);
            }
        }
    }

    static interface PolicyContextActions {
        public static final String SUBJECT_CONTEXT_KEY = "javax.security.auth.Subject.container";
        public static final PolicyContextActions PRIVILEGED = new PolicyContextActions(){
            private final PrivilegedExceptionAction exAction = new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return (Subject)PolicyContext.getContext((String)PolicyContextActions.SUBJECT_CONTEXT_KEY);
                }
            };

            public Subject getContextSubject() throws PolicyContextException {
                try {
                    return (Subject)AccessController.doPrivileged(this.exAction);
                }
                catch (PrivilegedActionException e) {
                    Exception ex = e.getException();
                    if (ex instanceof PolicyContextException) {
                        throw (PolicyContextException)ex;
                    }
                    throw new UndeclaredThrowableException(ex);
                }
            }
        };
        public static final PolicyContextActions NON_PRIVILEGED = new PolicyContextActions(){

            public Subject getContextSubject() throws PolicyContextException {
                return (Subject)PolicyContext.getContext((String)PolicyContextActions.SUBJECT_CONTEXT_KEY);
            }
        };

        public Subject getContextSubject() throws PolicyContextException;
    }

    static interface RunAsIdentityActions {
        public static final RunAsIdentityActions PRIVILEGED = new RunAsIdentityActions(){
            private final PrivilegedAction peekAction = new PrivilegedAction(){

                public Object run() {
                    SecurityContext sc = SecurityContextAssociation.getSecurityContext();
                    if (sc != null) {
                        return sc.getOutgoingRunAs();
                    }
                    return null;
                }
            };
            private final PrivilegedAction popAction = new PrivilegedAction(){

                public Object run() {
                    SecurityContext sc = SecurityContextAssociation.getSecurityContext();
                    if (sc == null) {
                        throw new IllegalStateException("Security Context is null");
                    }
                    RunAs ra = sc.getOutgoingRunAs();
                    sc.setOutgoingRunAs(null);
                    return ra;
                }
            };

            public RunAs peek() {
                return (RunAs)AccessController.doPrivileged(this.peekAction);
            }

            public void push(final RunAs id) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        SecurityContext sa = SecurityContextAssociation.getSecurityContext();
                        if (sa == null) {
                            throw new IllegalStateException("Security Context is null to push runas");
                        }
                        sa.setOutgoingRunAs(id);
                        return null;
                    }
                });
            }

            public RunAs pop() {
                return (RunAs)AccessController.doPrivileged(this.popAction);
            }
        };
        public static final RunAsIdentityActions NON_PRIVILEGED = new RunAsIdentityActions(){

            public RunAs peek() {
                SecurityContext sc = SecurityContextAssociation.getSecurityContext();
                if (sc != null) {
                    return sc.getOutgoingRunAs();
                }
                return null;
            }

            public void push(RunAs id) {
                SecurityContext sc = SecurityContextAssociation.getSecurityContext();
                if (sc == null) {
                    throw new IllegalStateException("Security Context is null to push runas");
                }
                sc.setOutgoingRunAs(id);
            }

            public RunAs pop() {
                SecurityContext sc = SecurityContextAssociation.getSecurityContext();
                if (sc == null) {
                    throw new IllegalStateException("Security Context is null");
                }
                RunAs ra = null;
                ra = sc.getOutgoingRunAs();
                sc.setOutgoingRunAs(null);
                return ra;
            }
        };

        public RunAs peek();

        public void push(RunAs var1);

        public RunAs pop();
    }
}

