/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.security.Principal;
import java.util.Collection;
import java.util.Date;
import javax.ejb.EJBContext;
import javax.ejb.EJBException;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import javax.transaction.UserTransaction;
import org.jboss.ejb.AllowedOperationsAssociation;
import org.jboss.ejb.AllowedOperationsFlags;
import org.jboss.ejb.Container;
import org.jboss.ejb.EnterpriseContext;
import org.jboss.metadata.MessageDrivenMetaData;
import org.jboss.util.NestedError;

public class MessageDrivenEnterpriseContext
extends EnterpriseContext {
    private MessageDrivenContext ctx = new MessageDrivenContextImpl();

    public MessageDrivenEnterpriseContext(Object instance, Container con) throws Exception {
        super(instance, con);
        ((MessageDrivenBean)instance).setMessageDrivenContext(this.ctx);
        try {
            AllowedOperationsAssociation.pushInMethodFlag(IN_EJB_CREATE);
            Method ejbCreate = instance.getClass().getMethod("ejbCreate", new Class[0]);
            ejbCreate.invoke(instance, new Object[0]);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof RuntimeException) {
                if (t instanceof EJBException) {
                    throw (EJBException)t;
                }
                throw new EJBException((Exception)((RuntimeException)t));
            }
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new NestedError("Unexpected Throwable", t);
        }
    }

    public MessageDrivenContext getMessageDrivenContext() {
        return this.ctx;
    }

    public void discard() throws RemoteException {
        ((MessageDrivenBean)this.instance).ejbRemove();
    }

    public EJBContext getEJBContext() {
        return this.ctx;
    }

    public class TimerServiceWrapper
    implements TimerService {
        private EnterpriseContext.EJBContextImpl context;
        private TimerService timerService;

        public TimerServiceWrapper(EnterpriseContext.EJBContextImpl ctx, TimerService timerService) {
            this.context = ctx;
            this.timerService = timerService;
        }

        public Timer createTimer(long duration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
            this.assertAllowedIn("TimerService.createTimer");
            return this.timerService.createTimer(duration, info);
        }

        public Timer createTimer(long initialDuration, long intervalDuration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
            this.assertAllowedIn("TimerService.createTimer");
            return this.timerService.createTimer(initialDuration, intervalDuration, info);
        }

        public Timer createTimer(Date expiration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
            this.assertAllowedIn("TimerService.createTimer");
            return this.timerService.createTimer(expiration, info);
        }

        public Timer createTimer(Date initialExpiration, long intervalDuration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
            this.assertAllowedIn("TimerService.createTimer");
            return this.timerService.createTimer(initialExpiration, intervalDuration, info);
        }

        public Collection getTimers() throws IllegalStateException, EJBException {
            this.assertAllowedIn("TimerService.getTimers");
            return this.timerService.getTimers();
        }

        private void assertAllowedIn(String timerMethod) {
            AllowedOperationsAssociation.assertAllowedIn(timerMethod, AllowedOperationsFlags.IN_BUSINESS_METHOD | AllowedOperationsFlags.IN_EJB_TIMEOUT);
        }
    }

    protected class MessageDrivenContextImpl
    extends EnterpriseContext.EJBContextImpl
    implements MessageDrivenContext {
        protected MessageDrivenContextImpl() {
            super(MessageDrivenEnterpriseContext.this);
        }

        public EJBHome getEJBHome() {
            throw new IllegalStateException("getEJBHome should not be access from a message driven bean");
        }

        public EJBLocalHome getEJBLocalHome() {
            throw new IllegalStateException("getEJBHome should not be access from a message driven bean");
        }

        public TimerService getTimerService() throws IllegalStateException {
            AllowedOperationsAssociation.assertAllowedIn("getTimerService", AllowedOperationsFlags.IN_EJB_CREATE | AllowedOperationsFlags.IN_EJB_REMOVE | AllowedOperationsFlags.IN_BUSINESS_METHOD | AllowedOperationsFlags.IN_EJB_TIMEOUT);
            return new TimerServiceWrapper(this, super.getTimerService());
        }

        public Principal getCallerPrincipal() {
            AllowedOperationsAssociation.assertAllowedIn("getCallerPrincipal", AllowedOperationsFlags.IN_BUSINESS_METHOD | AllowedOperationsFlags.IN_EJB_TIMEOUT);
            return super.getCallerPrincipal();
        }

        public boolean isCallerInRole(String id) {
            throw new IllegalStateException("isCallerInRole should not be access from a message driven bean");
        }

        public UserTransaction getUserTransaction() {
            if (MessageDrivenEnterpriseContext.this.isContainerManagedTx()) {
                throw new IllegalStateException("getUserTransaction should not be access for container managed Tx");
            }
            AllowedOperationsAssociation.assertAllowedIn("getUserTransaction", AllowedOperationsFlags.IN_EJB_CREATE | AllowedOperationsFlags.IN_EJB_REMOVE | AllowedOperationsFlags.IN_BUSINESS_METHOD | AllowedOperationsFlags.IN_EJB_TIMEOUT);
            return super.getUserTransaction();
        }

        public boolean getRollbackOnly() {
            if (MessageDrivenEnterpriseContext.this.isUserManagedTx()) {
                throw new IllegalStateException("getRollbackOnly should not be access for user managed Tx");
            }
            AllowedOperationsAssociation.assertAllowedIn("getRollbackOnly", AllowedOperationsFlags.IN_BUSINESS_METHOD | AllowedOperationsFlags.IN_EJB_TIMEOUT);
            if (!this.isTxRequired()) {
                throw new IllegalStateException("getRollbackOnly must only be called in the context of a transaction (EJB 2.0 - 15.5.1)");
            }
            return super.getRollbackOnly();
        }

        public void setRollbackOnly() {
            if (MessageDrivenEnterpriseContext.this.isUserManagedTx()) {
                throw new IllegalStateException("setRollbackOnly should not be access for user managed Tx");
            }
            AllowedOperationsAssociation.assertAllowedIn("getRollbackOnly", AllowedOperationsFlags.IN_BUSINESS_METHOD | AllowedOperationsFlags.IN_EJB_TIMEOUT);
            if (!this.isTxRequired()) {
                throw new IllegalStateException("setRollbackOnly must only be called in the context of a transaction (EJB 2.0 - 15.5.1)");
            }
            super.setRollbackOnly();
        }

        private boolean isTxRequired() {
            MessageDrivenMetaData md = (MessageDrivenMetaData)MessageDrivenEnterpriseContext.this.con.getBeanMetaData();
            return md.getMethodTransactionType() == 1;
        }
    }
}

